/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.value;

import java.lang.reflect.Constructor;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import org.jboss.msc.value.Value;

public final class LookupDeclaredConstructorValue
implements Value<Constructor> {
    private final Value<Class<?>> target;
    private final List<? extends Value<Class<?>>> parameterTypes;
    private final AccessControlContext context;
    private final boolean makeAccessible;

    public LookupDeclaredConstructorValue(Value<Class<?>> target, List<? extends Value<Class<?>>> parameterTypes, AccessControlContext context, boolean makeAccessible) {
        if (target == null) {
            throw new IllegalArgumentException("target is null");
        }
        if (parameterTypes == null) {
            throw new IllegalArgumentException("parameterTypes is null");
        }
        if (context == null) {
            throw new IllegalArgumentException("context is null");
        }
        this.target = target;
        this.parameterTypes = parameterTypes;
        this.context = context;
        this.makeAccessible = makeAccessible;
    }

    @Override
    public Constructor getValue() throws IllegalStateException {
        final Class[] types = new Class[this.parameterTypes.size()];
        int i = 0;
        for (Value<Class<?>> type : this.parameterTypes) {
            types[i++] = type.getValue();
        }
        final Class<?> targetClass = this.target.getValue();
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<Constructor>(){

                @Override
                public Constructor run() {
                    try {
                        Constructor constructor = targetClass.getDeclaredConstructor(types);
                        if (LookupDeclaredConstructorValue.this.makeAccessible) {
                            constructor.setAccessible(true);
                        }
                        return constructor;
                    }
                    catch (NoSuchMethodException e) {
                        throw new IllegalStateException("No such constructor found on " + targetClass);
                    }
                }
            }, this.context);
        }
        try {
            Constructor<?> constructor = targetClass.getDeclaredConstructor(types);
            if (this.makeAccessible) {
                constructor.setAccessible(true);
            }
            return constructor;
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("No such constructor found on " + targetClass);
        }
    }
}

