/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.value;

import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import org.jboss.msc.value.Value;

public final class LookupDeclaredMethodValue
implements Value<Method> {
    private final Value<Class<?>> target;
    private final String methodName;
    private final List<? extends Value<Class<?>>> parameterTypes;
    private final AccessControlContext context;
    private final boolean makeAccessible;

    public LookupDeclaredMethodValue(Value<Class<?>> target, String methodName, List<? extends Value<Class<?>>> parameterTypes, AccessControlContext context, boolean makeAccessible) {
        if (target == null) {
            throw new IllegalArgumentException("target is null");
        }
        if (methodName == null) {
            throw new IllegalArgumentException("methodName is null");
        }
        if (parameterTypes == null) {
            throw new IllegalArgumentException("parameterTypes is null");
        }
        if (context == null) {
            throw new IllegalArgumentException("context is null");
        }
        this.target = target;
        this.methodName = methodName;
        this.parameterTypes = parameterTypes;
        this.context = context;
        this.makeAccessible = makeAccessible;
    }

    @Override
    public Method getValue() throws IllegalStateException {
        final Class[] types = new Class[this.parameterTypes.size()];
        int i = 0;
        for (Value<Class<?>> type : this.parameterTypes) {
            types[i++] = type.getValue();
        }
        final Class<?> targetClass = this.target.getValue();
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<Method>(){

                @Override
                public Method run() {
                    try {
                        Method method = targetClass.getDeclaredMethod(LookupDeclaredMethodValue.this.methodName, types);
                        if (LookupDeclaredMethodValue.this.makeAccessible) {
                            method.setAccessible(true);
                        }
                        return method;
                    }
                    catch (NoSuchMethodException e) {
                        throw new IllegalStateException("No such method '" + LookupDeclaredMethodValue.this.methodName + "' found on " + targetClass);
                    }
                }
            }, this.context);
        }
        try {
            Method method = targetClass.getDeclaredMethod(this.methodName, types);
            if (this.makeAccessible) {
                method.setAccessible(true);
            }
            return method;
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("No such method '" + this.methodName + "' found on " + targetClass);
        }
    }
}

