/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.value;

import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.value.Value;

public final class LookupModuleClassValue
implements Value<Class<?>> {
    private final String className;
    private final ModuleIdentifier moduleIdentifier;
    private volatile Class<?> result;

    public LookupModuleClassValue(String className, ModuleIdentifier moduleIdentifier) {
        if (className == null) {
            throw new IllegalArgumentException("className is null");
        }
        if (moduleIdentifier == null) {
            throw new IllegalArgumentException("moduleIdentifier is null");
        }
        this.className = className;
        this.moduleIdentifier = moduleIdentifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> getValue() throws IllegalStateException {
        Class<?> result = this.result;
        if (result != null) {
            return result;
        }
        LookupModuleClassValue lookupModuleClassValue = this;
        synchronized (lookupModuleClassValue) {
            ModuleClassLoader classLoader;
            result = this.result;
            if (result != null) {
                return result;
            }
            try {
                classLoader = ModuleClassLoader.forModule((ModuleIdentifier)this.moduleIdentifier);
            }
            catch (ModuleLoadException e) {
                throw new IllegalStateException("No module available with name '" + this.moduleIdentifier + "'");
            }
            try {
                this.result = result = Class.forName(this.className, false, (ClassLoader)classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("No class available with name '" + this.className + "'");
            }
            return result;
        }
    }
}

