/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.io.PrintStream;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jboss.msc.service.BatchServiceTarget;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceNotFoundException;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.Value;

public final class DelegatingServiceContainer
implements ServiceContainer {
    private final ServiceTarget delegateTarget;
    private final ServiceRegistry delegateRegistry;

    public DelegatingServiceContainer(ServiceTarget delegateTarget, ServiceRegistry delegateRegistry) {
        this.delegateTarget = delegateTarget;
        this.delegateRegistry = delegateRegistry;
    }

    @Override
    public <T> ServiceBuilder<T> addServiceValue(ServiceName name, Value<? extends Service<T>> value) throws IllegalArgumentException {
        return this.delegateTarget.addServiceValue(name, value);
    }

    @Override
    public <T> ServiceBuilder<T> addService(ServiceName name, Service<T> service) throws IllegalArgumentException {
        return this.delegateTarget.addService(name, service);
    }

    @Override
    public ServiceTarget addListener(ServiceListener<Object> listener) {
        return this.delegateTarget.addListener(listener);
    }

    @Override
    public ServiceTarget addListener(ServiceListener<Object> ... listeners) {
        return this.delegateTarget.addListener(listeners);
    }

    @Override
    public ServiceTarget addListener(Collection<ServiceListener<Object>> listeners) {
        return this.delegateTarget.addListener(listeners);
    }

    @Override
    public ServiceTarget removeListener(ServiceListener<Object> listener) {
        return this.delegateTarget.removeListener(listener);
    }

    @Override
    public Set<ServiceListener<Object>> getListeners() {
        return this.delegateTarget.getListeners();
    }

    @Override
    public ServiceTarget addDependency(ServiceName dependency) {
        return this.delegateTarget.addDependency(dependency);
    }

    @Override
    public ServiceTarget addDependency(ServiceName ... dependencies) {
        return this.delegateTarget.addDependency(dependencies);
    }

    @Override
    public ServiceTarget addDependency(Collection<ServiceName> dependencies) {
        return this.delegateTarget.addDependency(dependencies);
    }

    @Override
    public ServiceTarget removeDependency(ServiceName dependency) {
        return this.delegateTarget.removeDependency(dependency);
    }

    @Override
    public Set<ServiceName> getDependencies() {
        return this.delegateTarget.getDependencies();
    }

    @Override
    public ServiceTarget subTarget() {
        return this.delegateTarget.subTarget();
    }

    @Override
    public BatchServiceTarget batchTarget() {
        return this.delegateTarget.batchTarget();
    }

    @Override
    public ServiceController<?> getRequiredService(ServiceName serviceName) throws ServiceNotFoundException {
        return this.delegateRegistry.getRequiredService(serviceName);
    }

    @Override
    public ServiceController<?> getService(ServiceName serviceName) {
        return this.delegateRegistry.getService(serviceName);
    }

    @Override
    public List<ServiceName> getServiceNames() {
        return this.delegateRegistry.getServiceNames();
    }

    @Override
    public String getName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isShutdownComplete() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dumpServices() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dumpServices(PrintStream stream) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addTerminateListener(ServiceContainer.TerminateListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void awaitTermination() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }
}

