/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.inject.Injectors;
import org.jboss.msc.service.IdentityHashSet;
import org.jboss.msc.service.Location;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceControllerImpl;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ServiceTargetImpl;
import org.jboss.msc.service.ValueInjection;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;

class ServiceBuilderImpl<T>
implements ServiceBuilder<T> {
    private final ServiceControllerImpl<?> parent;
    private final ServiceTargetImpl serviceTarget;
    private final Value<? extends Service<T>> serviceValue;
    private final ServiceName serviceName;
    private Location location;
    private ServiceController.Mode initialMode = ServiceController.Mode.ACTIVE;
    private final Set<ServiceName> aliases = new HashSet<ServiceName>(0);
    private final Map<ServiceName, Dependency> dependencies = new HashMap<ServiceName, Dependency>(0);
    private final Set<ServiceListener<? super T>> listeners = new IdentityHashSet<ServiceListener<? super T>>(0);
    private final List<ValueInjection<?>> valueInjections = new ArrayList(0);
    private final List<Injector<? super T>> outInjections = new ArrayList<Injector<? super T>>(0);
    private boolean installed = false;

    ServiceBuilderImpl(ServiceTargetImpl serviceTarget, Value<? extends Service<T>> serviceValue, ServiceName serviceName, ServiceControllerImpl<?> parent) {
        this.parent = parent;
        if (serviceTarget == null) {
            throw new IllegalArgumentException("ServiceTarget can not be null");
        }
        this.serviceTarget = serviceTarget;
        if (serviceValue == null) {
            throw new IllegalArgumentException("ServiceValue can not be null");
        }
        this.serviceValue = serviceValue;
        if (serviceName == null) {
            throw new IllegalArgumentException("ServiceName can not be null");
        }
        this.serviceName = serviceName;
    }

    @Override
    public ServiceBuilder<T> addAliases(ServiceName ... aliases) {
        if (aliases != null) {
            for (ServiceName alias : aliases) {
                if (alias == null || alias.equals(this.serviceName)) continue;
                this.aliases.add(alias);
            }
        }
        return this;
    }

    @Override
    public ServiceBuilderImpl<T> setLocation() {
        this.checkAlreadyInstalled();
        StackTraceElement element = new Throwable().getStackTrace()[1];
        String fileName = element.getFileName();
        int lineNumber = element.getLineNumber();
        return this.setLocation(new Location(fileName, lineNumber, -1, null));
    }

    @Override
    public ServiceBuilderImpl<T> setLocation(Location location) {
        this.checkAlreadyInstalled();
        this.location = location;
        return this;
    }

    @Override
    public ServiceBuilderImpl<T> setInitialMode(ServiceController.Mode mode) {
        this.checkAlreadyInstalled();
        if (mode == null) {
            throw new IllegalArgumentException("Initial mode is null");
        }
        if (mode == ServiceController.Mode.REMOVE) {
            throw new IllegalArgumentException("Initial mode cannot be set to REMOVE");
        }
        this.initialMode = mode;
        return this;
    }

    @Override
    public ServiceBuilder<T> addDependencies(ServiceName ... newDependencies) {
        return this.addDependencies(ServiceBuilder.DependencyType.REQUIRED, newDependencies);
    }

    @Override
    public ServiceBuilder<T> addDependencies(ServiceBuilder.DependencyType dependencyType, ServiceName ... newDependencies) {
        this.checkAlreadyInstalled();
        if (newDependencies != null) {
            for (ServiceName dependency : newDependencies) {
                if (dependency == null) {
                    throw new IllegalArgumentException("dependency is null");
                }
                if (this.serviceName.equals(dependency)) continue;
                this.doAddDependency(dependency, dependencyType);
            }
        }
        return this;
    }

    @Override
    @Deprecated
    public ServiceBuilder<T> addOptionalDependencies(ServiceName ... newDependencies) {
        return this.addDependencies(ServiceBuilder.DependencyType.OPTIONAL, newDependencies);
    }

    @Override
    public ServiceBuilder<T> addDependencies(Iterable<ServiceName> newDependencies) {
        return this.addDependencies(ServiceBuilder.DependencyType.REQUIRED, newDependencies);
    }

    ServiceBuilder<T> addDependenciesNoCheck(Iterable<ServiceName> newDependencies) {
        return this.addDependenciesNoCheck(newDependencies, ServiceBuilder.DependencyType.REQUIRED);
    }

    @Override
    @Deprecated
    public ServiceBuilder<T> addOptionalDependencies(Iterable<ServiceName> newDependencies) {
        return this.addDependencies(ServiceBuilder.DependencyType.OPTIONAL, newDependencies);
    }

    @Override
    public ServiceBuilder<T> addDependencies(ServiceBuilder.DependencyType dependencyType, Iterable<ServiceName> newDependencies) {
        this.checkAlreadyInstalled();
        return this.addDependenciesNoCheck(newDependencies, dependencyType);
    }

    ServiceBuilder<T> addDependenciesNoCheck(Iterable<ServiceName> newDependencies, ServiceBuilder.DependencyType dependencyType) {
        if (newDependencies != null) {
            for (ServiceName dependency : newDependencies) {
                if (dependency == null || this.serviceName.equals(dependency)) continue;
                this.doAddDependency(dependency, dependencyType);
            }
        }
        return this;
    }

    @Override
    public ServiceBuilder<T> addDependency(ServiceName dependency) {
        return this.addDependency(ServiceBuilder.DependencyType.REQUIRED, dependency);
    }

    @Override
    @Deprecated
    public ServiceBuilder<T> addOptionalDependency(ServiceName dependency) {
        return this.addDependency(ServiceBuilder.DependencyType.OPTIONAL, dependency);
    }

    @Override
    public ServiceBuilder<T> addDependency(ServiceBuilder.DependencyType dependencyType, ServiceName dependency) {
        this.checkAlreadyInstalled();
        if (!this.serviceName.equals(dependency)) {
            this.doAddDependency(dependency, dependencyType);
        }
        return this;
    }

    @Override
    public ServiceBuilder<T> addDependency(ServiceName dependency, Injector<Object> target) {
        return this.addDependency(ServiceBuilder.DependencyType.REQUIRED, dependency, target);
    }

    @Override
    @Deprecated
    public ServiceBuilder<T> addOptionalDependency(ServiceName dependency, Injector<Object> target) {
        return this.addDependency(ServiceBuilder.DependencyType.OPTIONAL, dependency, target);
    }

    @Override
    public ServiceBuilder<T> addDependency(ServiceBuilder.DependencyType dependencyType, ServiceName dependency, Injector<Object> target) {
        this.checkAlreadyInstalled();
        this.doAddDependency(dependency, dependencyType).getInjectorList().add(target);
        return this;
    }

    @Override
    public <I> ServiceBuilder<T> addDependency(ServiceName dependency, Class<I> type, Injector<I> target) {
        return this.addDependency(ServiceBuilder.DependencyType.REQUIRED, dependency, type, target);
    }

    @Override
    @Deprecated
    public <I> ServiceBuilder<T> addOptionalDependency(ServiceName dependency, Class<I> type, Injector<I> target) {
        return this.addDependency(ServiceBuilder.DependencyType.OPTIONAL, dependency, type, target);
    }

    @Override
    public <I> ServiceBuilder<T> addDependency(ServiceBuilder.DependencyType dependencyType, ServiceName dependency, Class<I> type, Injector<I> target) {
        this.checkAlreadyInstalled();
        this.doAddDependency(dependency, dependencyType).getInjectorList().add(Injectors.cast(target, type));
        return this;
    }

    private Dependency doAddDependency(ServiceName name, ServiceBuilder.DependencyType type) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        Dependency existing = this.dependencies.get(name);
        if (existing != null) {
            if (type == ServiceBuilder.DependencyType.REQUIRED) {
                existing.setDependencyType(ServiceBuilder.DependencyType.REQUIRED);
            }
            return existing;
        }
        Dependency newDep = new Dependency(name, type);
        this.dependencies.put(name, newDep);
        return newDep;
    }

    @Override
    public <I> ServiceBuilder<T> addInjection(Injector<? super I> target, I value) {
        return this.addInjectionValue(target, new ImmediateValue<I>(value));
    }

    @Override
    public <I> ServiceBuilder<T> addInjectionValue(Injector<? super I> target, Value<I> value) {
        this.checkAlreadyInstalled();
        this.valueInjections.add(new ValueInjection<I>(value, target));
        return this;
    }

    @Override
    public ServiceBuilder<T> addInjection(Injector<? super T> target) {
        this.checkAlreadyInstalled();
        this.outInjections.add(target);
        return this;
    }

    @Override
    public ServiceBuilderImpl<T> addListener(ServiceListener<? super T> listener) {
        this.checkAlreadyInstalled();
        this.listeners.add(listener);
        return this;
    }

    @Override
    public ServiceBuilderImpl<T> addListener(ServiceListener<? super T> ... serviceListeners) {
        this.checkAlreadyInstalled();
        for (ServiceListener<? super T> listener : serviceListeners) {
            Set<ServiceListener<T>> listeners = this.listeners;
            listeners.add(listener);
        }
        return this;
    }

    @Override
    public ServiceBuilderImpl<T> addListener(Collection<? extends ServiceListener<? super T>> serviceListeners) {
        this.checkAlreadyInstalled();
        return this.addListenerNoCheck(serviceListeners);
    }

    ServiceBuilderImpl<T> addListenerNoCheck(Collection<? extends ServiceListener<? super T>> serviceListeners) {
        this.listeners.addAll(serviceListeners);
        return this;
    }

    private void checkAlreadyInstalled() {
        if (this.installed) {
            throw new IllegalStateException("ServiceBuilder already installed");
        }
    }

    @Override
    public ServiceController<T> install() throws ServiceRegistryException {
        if (this.installed) {
            throw new IllegalStateException("ServiceBuilder is already installed");
        }
        this.installed = true;
        return this.serviceTarget.install(this);
    }

    Value<? extends Service<T>> getServiceValue() {
        return this.serviceValue;
    }

    ServiceName getName() {
        return this.serviceName;
    }

    ServiceName[] getAliases() {
        return this.aliases.toArray(new ServiceName[this.aliases.size()]);
    }

    Map<ServiceName, Dependency> getDependencies() {
        return this.dependencies;
    }

    Set<? extends ServiceListener<? super T>> getListeners() {
        return this.listeners;
    }

    List<ValueInjection<?>> getValueInjections() {
        return this.valueInjections;
    }

    ServiceController.Mode getInitialMode() {
        return this.initialMode;
    }

    Location getLocation() {
        return this.location;
    }

    ServiceTarget getTarget() {
        return this.serviceTarget;
    }

    ServiceControllerImpl<?> getParent() {
        return this.parent;
    }

    List<Injector<? super T>> getOutInjections() {
        return this.outInjections;
    }

    static final class Dependency {
        private final ServiceName name;
        private ServiceBuilder.DependencyType dependencyType;
        private List<Injector<Object>> injectorList = new ArrayList<Injector<Object>>(0);

        Dependency(ServiceName name, ServiceBuilder.DependencyType dependencyType) {
            this.name = name;
            this.dependencyType = dependencyType;
        }

        ServiceName getName() {
            return this.name;
        }

        List<Injector<Object>> getInjectorList() {
            return this.injectorList;
        }

        ServiceBuilder.DependencyType getDependencyType() {
            return this.dependencyType;
        }

        void setDependencyType(ServiceBuilder.DependencyType dependencyType) {
            this.dependencyType = dependencyType;
        }
    }
}

