/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.jboss.msc.service.Dependency;
import org.jboss.msc.service.Dependent;
import org.jboss.msc.service.IdentityHashSet;
import org.jboss.msc.service.Location;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceBuilderImpl;
import org.jboss.msc.service.ServiceContainerImpl;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceLogger;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistrationImpl;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ServiceTargetImpl;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.service.ValueInjection;
import org.jboss.msc.service.management.ServiceStatus;
import org.jboss.msc.value.Value;

final class ServiceControllerImpl<S>
implements ServiceController<S>,
Dependent {
    private static final String ILLEGAL_CONTROLLER_STATE = "Illegal controller state";
    private final Value<? extends Service<? extends S>> serviceValue;
    private final Location location;
    private final Dependency[] dependencies;
    private final ValueInjection<?>[] injections;
    private final ValueInjection<?>[] outInjections;
    private final IdentityHashSet<ServiceListener<? super S>> listeners;
    private final ServiceRegistrationImpl primaryRegistration;
    private final ServiceRegistrationImpl[] aliasRegistrations;
    private final ServiceControllerImpl<?> parent;
    private final IdentityHashSet<ServiceControllerImpl<?>> children;
    private final IdentityHashSet<ServiceName> immediateUnavailableDependencies;
    private StartException startException;
    private ServiceController.Mode mode = ServiceController.Mode.NEVER;
    private Substate state = Substate.NEW;
    private int demandedByCount;
    private int upperCount;
    private int downDependencies;
    private int runningDependents;
    private int failCount;
    private int transitiveUnavailableDepCount;
    private int asyncTasks;
    private volatile ChildServiceTarget childTarget;
    private volatile long lifecycleTime;
    private static final Dependent[] NO_DEPENDENTS = new Dependent[0];
    private static final String[] NO_STRINGS = new String[0];
    private static final ServiceName[] NO_NAMES = new ServiceName[0];

    ServiceControllerImpl(Value<? extends Service<? extends S>> serviceValue, Location location, Dependency[] dependencies, ValueInjection<?>[] injections, ValueInjection<?>[] outInjections, ServiceRegistrationImpl primaryRegistration, ServiceRegistrationImpl[] aliasRegistrations, Set<? extends ServiceListener<? super S>> listeners, ServiceControllerImpl<?> parent) {
        this.serviceValue = serviceValue;
        this.location = location;
        this.dependencies = dependencies;
        this.injections = injections;
        this.outInjections = outInjections;
        this.primaryRegistration = primaryRegistration;
        this.aliasRegistrations = aliasRegistrations;
        this.listeners = new IdentityHashSet<ServiceListener<S>>(listeners);
        this.parent = parent;
        int depCount = dependencies.length;
        this.upperCount = 0;
        this.downDependencies = parent == null ? depCount : depCount + 1;
        this.children = new IdentityHashSet();
        this.immediateUnavailableDependencies = new IdentityHashSet();
    }

    Substate getSubstateLocked() {
        return this.state;
    }

    void addAsyncTask() {
        ++this.asyncTasks;
    }

    void addAsyncTasks(int size) {
        this.asyncTasks += size;
    }

    void removeAsyncTask() {
        --this.asyncTasks;
    }

    void removeAsyncTasks(int size) {
        this.asyncTasks -= size;
    }

    void startInstallation() {
        for (Dependency dependency : this.dependencies) {
            dependency.addDependent(this);
        }
        if (this.parent != null) {
            this.parent.addChild(this);
        }
        this.primaryRegistration.setInstance(this);
        for (Dependency dependency : this.aliasRegistrations) {
            ((ServiceRegistrationImpl)dependency).setInstance(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commitInstallation(ServiceController.Mode initialMode) {
        assert (this.state == Substate.NEW);
        assert (initialMode != null);
        assert (!Thread.holdsLock(this));
        ArrayList<Runnable> listenerAddedTasks = new ArrayList<Runnable>(16);
        ArrayList<Runnable> tasks = new ArrayList<Runnable>(16);
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            this.getListenerTasks(ListenerNotification.LISTENER_ADDED, listenerAddedTasks);
            this.internalSetMode(initialMode, tasks);
            tasks.add(new ServiceAvailableTask());
            this.asyncTasks += listenerAddedTasks.size() + tasks.size() + 1;
        }
        this.doExecute(tasks);
        tasks.clear();
        for (Runnable listenerAddedTask : listenerAddedTasks) {
            listenerAddedTask.run();
        }
        serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            Dependent[][] dependents = this.getDependents();
            if (!this.immediateUnavailableDependencies.isEmpty() || this.transitiveUnavailableDepCount > 0) {
                tasks.add(new DependencyUnavailableTask(dependents));
            }
            if (this.failCount > 0) {
                tasks.add(new DependencyFailedTask(dependents));
            }
            this.state = Substate.DOWN;
            --this.asyncTasks;
            this.transition(tasks);
            this.asyncTasks += tasks.size();
        }
        this.doExecute(tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollbackInstallation() {
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            this.mode = ServiceController.Mode.REMOVE;
            ++this.asyncTasks;
            this.state = Substate.CANCELLED;
        }
        new RemoveTask().run();
    }

    private Transition getTransition() {
        assert (Thread.holdsLock(this));
        if (this.asyncTasks != 0) {
            return null;
        }
        switch (this.state) {
            case DOWN: {
                if (this.mode == ServiceController.Mode.REMOVE) {
                    return Transition.DOWN_to_REMOVING;
                }
                if (this.mode == ServiceController.Mode.NEVER) {
                    return Transition.DOWN_to_WONT_START;
                }
                if (this.upperCount > 0 && (this.mode != ServiceController.Mode.PASSIVE || this.downDependencies == 0)) {
                    return Transition.DOWN_to_START_REQUESTED;
                }
                if ((this.mode != ServiceController.Mode.ON_DEMAND || this.demandedByCount != 0) && (this.mode != ServiceController.Mode.PASSIVE || this.downDependencies <= 0)) break;
                return Transition.DOWN_to_WAITING;
            }
            case WAITING: {
                if (this.mode == ServiceController.Mode.ON_DEMAND && this.demandedByCount <= 0 || this.mode == ServiceController.Mode.PASSIVE && this.downDependencies != 0) break;
                return Transition.WAITING_to_DOWN;
            }
            case WONT_START: {
                if (this.mode == ServiceController.Mode.NEVER) break;
                return Transition.WONT_START_to_DOWN;
            }
            case STOPPING: {
                return Transition.STOPPING_to_DOWN;
            }
            case STOP_REQUESTED: {
                if (this.upperCount > 0 && this.downDependencies == 0) {
                    return Transition.STOP_REQUESTED_to_UP;
                }
                if (this.runningDependents != 0) break;
                return Transition.STOP_REQUESTED_to_STOPPING;
            }
            case UP: {
                if (this.upperCount > 0 && this.downDependencies <= 0) break;
                return Transition.UP_to_STOP_REQUESTED;
            }
            case START_FAILED: {
                if (this.upperCount > 0) {
                    if (this.downDependencies == 0) {
                        if (this.startException != null) break;
                        return Transition.START_FAILED_to_STARTING;
                    }
                    return Transition.START_FAILED_to_DOWN;
                }
                return Transition.START_FAILED_to_DOWN;
            }
            case START_INITIATING: {
                return Transition.START_INITIATING_to_STARTING;
            }
            case STARTING: {
                if (this.startException == null) {
                    return Transition.STARTING_to_UP;
                }
                return Transition.STARTING_to_START_FAILED;
            }
            case START_REQUESTED: {
                if (this.upperCount > 0) {
                    if (this.mode == ServiceController.Mode.PASSIVE && this.downDependencies > 0) {
                        return Transition.START_REQUESTED_to_DOWN;
                    }
                    if (!this.immediateUnavailableDependencies.isEmpty() || this.transitiveUnavailableDepCount > 0 || this.failCount > 0) {
                        return Transition.START_REQUESTED_to_PROBLEM;
                    }
                    if (this.downDependencies != 0) break;
                    return Transition.START_REQUESTED_to_START_INITIATING;
                }
                return Transition.START_REQUESTED_to_DOWN;
            }
            case PROBLEM: {
                if (this.upperCount != 0 && (!this.immediateUnavailableDependencies.isEmpty() || this.transitiveUnavailableDepCount != 0 || this.failCount != 0) && this.mode != ServiceController.Mode.PASSIVE) break;
                return Transition.PROBLEM_to_START_REQUESTED;
            }
            case REMOVING: {
                return Transition.REMOVING_to_REMOVED;
            }
        }
        return null;
    }

    void transition(ArrayList<Runnable> tasks) {
        assert (Thread.holdsLock(this));
        Transition transition = null;
        do {
            if ((transition = this.getTransition()) == null) {
                return;
            }
            switch (transition) {
                case DOWN_to_WAITING: {
                    this.getListenerTasks(ListenerNotification.WAITING, tasks);
                    break;
                }
                case WAITING_to_DOWN: {
                    this.getListenerTasks(ListenerNotification.WAITING_CLEARED, tasks);
                    break;
                }
                case DOWN_to_WONT_START: {
                    this.getListenerTasks(ListenerNotification.WONT_START, tasks);
                    tasks.add(new ServiceUnavailableTask());
                    break;
                }
                case WONT_START_to_DOWN: {
                    this.getListenerTasks(ListenerNotification.WONT_START_CLEARED, tasks);
                    tasks.add(new ServiceAvailableTask());
                    break;
                }
                case STOPPING_to_DOWN: {
                    this.getListenerTasks(transition.getAfter().getState(), tasks);
                    tasks.add(new DependentStoppedTask());
                    break;
                }
                case START_REQUESTED_to_DOWN: {
                    this.getListenerTasks(ListenerNotification.START_REQUEST_CLEARED, tasks);
                    break;
                }
                case START_REQUESTED_to_START_INITIATING: {
                    tasks.add(new DependentStartedTask());
                    break;
                }
                case START_REQUESTED_to_PROBLEM: {
                    if (!this.immediateUnavailableDependencies.isEmpty()) {
                        this.getListenerTasks(ListenerNotification.IMMEDIATE_DEPENDENCY_UNAVAILABLE, tasks);
                    }
                    if (this.transitiveUnavailableDepCount > 0) {
                        this.getListenerTasks(ListenerNotification.TRANSITIVE_DEPENDENCY_UNAVAILABLE, tasks);
                    }
                    if (this.failCount > 0) {
                        this.getListenerTasks(ListenerNotification.DEPENDENCY_FAILURE, tasks);
                    }
                    this.getListenerTasks(ListenerNotification.DEPENDENCY_PROBLEM, tasks);
                    break;
                }
                case UP_to_STOP_REQUESTED: {
                    this.getListenerTasks(ListenerNotification.STOP_REQUESTED, tasks);
                    this.lifecycleTime = System.nanoTime();
                    tasks.add(new DependencyStoppedTask(this.getDependents()));
                    break;
                }
                case STARTING_to_UP: {
                    this.getListenerTasks(transition.getAfter().getState(), tasks);
                    tasks.add(new DependencyStartedTask(this.getDependents()));
                    break;
                }
                case STARTING_to_START_FAILED: {
                    ChildServiceTarget childTarget = this.childTarget;
                    if (childTarget != null) {
                        childTarget.valid = false;
                        this.childTarget = null;
                    }
                    if (!this.children.isEmpty()) {
                        ++this.asyncTasks;
                        for (ServiceControllerImpl<?> child : this.children) {
                            child.setMode(ServiceController.Mode.REMOVE);
                        }
                    }
                    this.getListenerTasks(transition.getAfter().getState(), tasks);
                    tasks.add(new DependencyFailedTask(this.getDependents()));
                    break;
                }
                case START_FAILED_to_STARTING: {
                    this.getListenerTasks(ListenerNotification.FAILED_STARTING, tasks);
                    tasks.add(new DependencyRetryingTask(this.getDependents()));
                    tasks.add(new DependentStartedTask());
                    break;
                }
                case START_INITIATING_to_STARTING: {
                    this.getListenerTasks(transition.getAfter().getState(), tasks);
                    tasks.add(new StartTask(true));
                    break;
                }
                case START_FAILED_to_DOWN: {
                    this.startException = null;
                    --this.failCount;
                    this.getListenerTasks(ListenerNotification.FAILED_STOPPED, tasks);
                    tasks.add(new DependencyRetryingTask(this.getDependents()));
                    tasks.add(new StopTask(true));
                    tasks.add(new DependentStoppedTask());
                    break;
                }
                case STOP_REQUESTED_to_UP: {
                    this.getListenerTasks(ListenerNotification.STOP_REQUEST_CLEARED, tasks);
                    tasks.add(new DependencyStartedTask(this.getDependents()));
                    break;
                }
                case STOP_REQUESTED_to_STOPPING: {
                    ChildServiceTarget childTarget = this.childTarget;
                    if (childTarget != null) {
                        childTarget.valid = false;
                        this.childTarget = null;
                    }
                    if (!this.children.isEmpty()) {
                        ++this.asyncTasks;
                        for (ServiceControllerImpl<?> child : this.children) {
                            child.setMode(ServiceController.Mode.REMOVE);
                        }
                    }
                    this.getListenerTasks(transition.getAfter().getState(), tasks);
                    tasks.add(new StopTask(false));
                    break;
                }
                case DOWN_to_REMOVING: {
                    tasks.add(new ServiceUnavailableTask());
                    Dependent[][] dependents = this.getDependents();
                    if (!this.immediateUnavailableDependencies.isEmpty() || this.transitiveUnavailableDepCount > 0) {
                        tasks.add(new DependencyAvailableTask(dependents));
                    }
                    if (this.failCount > 0) {
                        tasks.add(new DependencyRetryingTask(dependents));
                    }
                    tasks.add(new RemoveTask());
                    break;
                }
                case REMOVING_to_REMOVED: {
                    this.getListenerTasks(transition.getAfter().getState(), tasks);
                    this.listeners.clear();
                    break;
                }
                case DOWN_to_START_REQUESTED: {
                    this.getListenerTasks(ListenerNotification.START_REQUESTED, tasks);
                    break;
                }
                case PROBLEM_to_START_REQUESTED: {
                    if (!this.immediateUnavailableDependencies.isEmpty()) {
                        this.getListenerTasks(ListenerNotification.IMMEDIATE_DEPENDENCY_AVAILABLE, tasks);
                    }
                    if (this.transitiveUnavailableDepCount > 0) {
                        this.getListenerTasks(ListenerNotification.TRANSITIVE_DEPENDENCY_AVAILABLE, tasks);
                    }
                    if (this.failCount > 0) {
                        this.getListenerTasks(ListenerNotification.DEPENDENCY_FAILURE_CLEAR, tasks);
                    }
                    this.getListenerTasks(ListenerNotification.DEPENDENCY_PROBLEM_CLEAR, tasks);
                    this.lifecycleTime = System.nanoTime();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            this.state = transition.getAfter();
        } while (tasks.isEmpty());
    }

    private void getListenerTasks(ServiceController.State newState, ArrayList<Runnable> tasks) {
        IdentityHashSet<ServiceListener<S>> listeners = this.listeners;
        for (ServiceListener<? super S> serviceListener : listeners) {
            tasks.add(new ListenerTask(serviceListener, newState));
        }
    }

    private void getListenerTasks(ListenerNotification notification, ArrayList<Runnable> tasks) {
        IdentityHashSet<ServiceListener<S>> listeners = this.listeners;
        for (ServiceListener<? super S> serviceListener : listeners) {
            tasks.add(new ListenerTask(serviceListener, notification));
        }
    }

    void doExecute(Runnable task) {
        assert (!Thread.holdsLock(this));
        if (task == null) {
            return;
        }
        try {
            this.primaryRegistration.getContainer().getExecutor().execute(task);
        }
        catch (RejectedExecutionException e) {
            task.run();
        }
    }

    void doExecute(ArrayList<Runnable> tasks) {
        assert (!Thread.holdsLock(this));
        if (tasks == null) {
            return;
        }
        Executor executor = this.primaryRegistration.getContainer().getExecutor();
        for (Runnable task : tasks) {
            try {
                executor.execute(task);
            }
            catch (RejectedExecutionException e) {
                task.run();
            }
        }
    }

    @Override
    public void setMode(ServiceController.Mode newMode) {
        this.internalSetMode(null, newMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean internalSetMode(ServiceController.Mode expectedMode, ServiceController.Mode newMode) {
        assert (!Thread.holdsLock(this));
        if (newMode == null) {
            throw new IllegalArgumentException("newMode is null");
        }
        if (newMode != ServiceController.Mode.REMOVE && this.primaryRegistration.getContainer().isShutdown()) {
            throw new IllegalArgumentException("Container is shutting down");
        }
        ArrayList<Runnable> tasks = new ArrayList<Runnable>(4);
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            ServiceController.Mode oldMode = this.mode;
            if (expectedMode != null && expectedMode != oldMode) {
                return false;
            }
            if (oldMode == newMode) {
                return true;
            }
            this.internalSetMode(newMode, tasks);
            if (tasks.isEmpty()) {
                this.transition(tasks);
            }
            this.asyncTasks += tasks.size();
        }
        this.doExecute(tasks);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void internalSetMode(ServiceController.Mode newMode, ArrayList<Runnable> taskList) {
        assert (Thread.holdsLock(this));
        ServiceController.Mode oldMode = this.mode;
        block0 : switch (oldMode) {
            case REMOVE: {
                switch (newMode) {
                    case REMOVE: {
                        break block0;
                    }
                }
                throw new IllegalStateException("Service removed");
            }
            case NEVER: {
                switch (newMode) {
                    case REMOVE: {
                        this.getListenerTasks(ListenerNotification.REMOVE_REQUESTED, taskList);
                        break;
                    }
                    case ON_DEMAND: {
                        if (this.demandedByCount <= 0) break;
                        assert (this.upperCount < 1);
                        ++this.upperCount;
                        taskList.add(new DemandParentsTask());
                        break;
                    }
                    case PASSIVE: {
                        assert (this.upperCount < 1);
                        ++this.upperCount;
                        if (this.demandedByCount <= 0) break;
                        taskList.add(new DemandParentsTask());
                        break;
                    }
                    case ACTIVE: {
                        taskList.add(new DemandParentsTask());
                        assert (this.upperCount < 1);
                        ++this.upperCount;
                        break;
                    }
                }
                break;
            }
            case ON_DEMAND: {
                switch (newMode) {
                    case REMOVE: {
                        this.getListenerTasks(ListenerNotification.REMOVE_REQUESTED, taskList);
                    }
                    case NEVER: {
                        if (this.demandedByCount <= 0) break;
                        --this.upperCount;
                        taskList.add(new UndemandParentsTask());
                        break;
                    }
                    case PASSIVE: {
                        if (this.demandedByCount != 0) break;
                        assert (this.upperCount < 1);
                        ++this.upperCount;
                        break;
                    }
                    case ACTIVE: {
                        taskList.add(new DemandParentsTask());
                        if (this.demandedByCount != 0) break;
                        assert (this.upperCount < 1);
                        ++this.upperCount;
                        break;
                    }
                }
                break;
            }
            case PASSIVE: {
                switch (newMode) {
                    case REMOVE: {
                        this.getListenerTasks(ListenerNotification.REMOVE_REQUESTED, taskList);
                    }
                    case NEVER: {
                        if (this.demandedByCount > 0) {
                            taskList.add(new UndemandParentsTask());
                        }
                        --this.upperCount;
                        break;
                    }
                    case ON_DEMAND: {
                        if (this.demandedByCount != 0) break;
                        --this.upperCount;
                        break;
                    }
                    case ACTIVE: {
                        taskList.add(new DemandParentsTask());
                        break;
                    }
                }
                break;
            }
            case ACTIVE: {
                switch (newMode) {
                    case REMOVE: {
                        this.getListenerTasks(ListenerNotification.REMOVE_REQUESTED, taskList);
                    }
                    case NEVER: {
                        taskList.add(new UndemandParentsTask());
                        --this.upperCount;
                        break;
                    }
                    case ON_DEMAND: {
                        if (this.demandedByCount != 0) break;
                        --this.upperCount;
                        taskList.add(new UndemandParentsTask());
                        break;
                    }
                    case PASSIVE: {
                        if (this.demandedByCount != 0) break;
                        taskList.add(new UndemandParentsTask());
                    }
                }
                break;
            }
        }
        this.mode = newMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void immediateDependencyAvailable(ServiceName dependencyName) {
        ArrayList<Runnable> tasks;
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            assert (this.immediateUnavailableDependencies.contains(dependencyName));
            this.immediateUnavailableDependencies.remove(dependencyName);
            if (!this.immediateUnavailableDependencies.isEmpty() || this.state.compareTo(Substate.CANCELLED) <= 0) {
                return;
            }
            tasks = new ArrayList<Runnable>(16);
            if (this.state == Substate.PROBLEM) {
                this.getListenerTasks(ListenerNotification.IMMEDIATE_DEPENDENCY_AVAILABLE, tasks);
            }
            if (this.transitiveUnavailableDepCount == 0) {
                tasks.add(new DependencyAvailableTask(this.getDependents()));
            }
            this.asyncTasks += tasks.size();
        }
        this.doExecute(tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void immediateDependencyUnavailable(ServiceName dependencyName) {
        ArrayList<Runnable> tasks;
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            this.immediateUnavailableDependencies.add(dependencyName);
            if (this.immediateUnavailableDependencies.size() != 1 || this.state.compareTo(Substate.CANCELLED) <= 0) {
                return;
            }
            tasks = new ArrayList<Runnable>(16);
            if (this.state == Substate.PROBLEM) {
                this.getListenerTasks(ListenerNotification.IMMEDIATE_DEPENDENCY_UNAVAILABLE, tasks);
            }
            if (this.transitiveUnavailableDepCount == 0) {
                tasks.add(new DependencyUnavailableTask(this.getDependents()));
            }
            this.asyncTasks += tasks.size();
        }
        this.doExecute(tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transitiveDependencyAvailable() {
        ArrayList<Runnable> tasks;
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            if (--this.transitiveUnavailableDepCount != 0 || this.state.compareTo(Substate.CANCELLED) <= 0) {
                return;
            }
            tasks = new ArrayList<Runnable>(16);
            if (this.state == Substate.PROBLEM) {
                this.getListenerTasks(ListenerNotification.TRANSITIVE_DEPENDENCY_AVAILABLE, tasks);
            }
            if (this.immediateUnavailableDependencies.isEmpty()) {
                tasks.add(new DependencyAvailableTask(this.getDependents()));
            }
            this.asyncTasks += tasks.size();
        }
        this.doExecute(tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transitiveDependencyUnavailable() {
        ArrayList<Runnable> tasks;
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            if (++this.transitiveUnavailableDepCount != 1 || this.state.compareTo(Substate.CANCELLED) <= 0) {
                return;
            }
            tasks = new ArrayList<Runnable>(16);
            if (this.state == Substate.PROBLEM) {
                this.getListenerTasks(ListenerNotification.TRANSITIVE_DEPENDENCY_UNAVAILABLE, tasks);
            }
            if (this.immediateUnavailableDependencies.isEmpty()) {
                tasks.add(new DependencyUnavailableTask(this.getDependents()));
            }
            this.asyncTasks += tasks.size();
        }
        this.doExecute(tasks);
    }

    @Override
    public ServiceControllerImpl<?> getController() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void immediateDependencyUp() {
        ArrayList<Runnable> tasks;
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            if (--this.downDependencies != 0) {
                return;
            }
            tasks = new ArrayList<Runnable>();
            this.transition(tasks);
            this.asyncTasks += tasks.size();
        }
        this.doExecute(tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void immediateDependencyDown() {
        ArrayList<Runnable> tasks;
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            if (++this.downDependencies != 1) {
                return;
            }
            tasks = new ArrayList<Runnable>();
            this.transition(tasks);
            this.asyncTasks += tasks.size();
        }
        this.doExecute(tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dependencyFailed() {
        ArrayList<Runnable> tasks;
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            if (++this.failCount != 1 || this.state.compareTo(Substate.CANCELLED) <= 0) {
                return;
            }
            tasks = new ArrayList<Runnable>();
            if (this.state == Substate.PROBLEM) {
                this.getListenerTasks(ListenerNotification.DEPENDENCY_FAILURE, tasks);
            }
            tasks.add(new DependencyFailedTask(this.getDependents()));
            this.asyncTasks += tasks.size();
        }
        this.doExecute(tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dependencyFailureCleared() {
        ArrayList<Runnable> tasks;
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            if (--this.failCount != 0 || this.state == Substate.CANCELLED) {
                return;
            }
            tasks = new ArrayList<Runnable>();
            if (this.state == Substate.PROBLEM) {
                this.getListenerTasks(ListenerNotification.DEPENDENCY_FAILURE_CLEAR, tasks);
            }
            tasks.add(new DependencyRetryingTask(this.getDependents()));
            this.asyncTasks += tasks.size();
        }
        this.doExecute(tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dependentStarted() {
        assert (!Thread.holdsLock(this));
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            ++this.runningDependents;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dependentStopped() {
        ArrayList<Runnable> tasks;
        assert (!Thread.holdsLock(this));
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            if (--this.runningDependents != 0) {
                return;
            }
            tasks = new ArrayList<Runnable>();
            this.transition(tasks);
            this.asyncTasks += tasks.size();
        }
        this.doExecute(tasks);
    }

    void newDependent(ServiceName dependencyName, Dependent dependent, ArrayList<Runnable> tasks) {
        assert (Thread.holdsLock(this));
        Dependent[][] dependents = new Dependent[][]{{dependent}};
        if (this.failCount > 0) {
            tasks.add(new DependencyFailedTask(dependents));
        }
        if (!this.immediateUnavailableDependencies.isEmpty() || this.transitiveUnavailableDepCount > 0) {
            tasks.add(new DependencyUnavailableTask(dependents));
        }
        if (this.state == Substate.WONT_START) {
            tasks.add(new ServiceUnavailableTask(dependencyName, dependent));
        } else if (this.state == Substate.UP) {
            tasks.add(new DependencyStartedTask(dependents));
        }
    }

    private void doDemandParents() {
        assert (!Thread.holdsLock(this));
        for (Dependency dependency : this.dependencies) {
            dependency.addDemand();
        }
        ServiceControllerImpl<?> parent = this.parent;
        if (parent != null) {
            parent.addDemand();
        }
    }

    private void doUndemandParents() {
        assert (!Thread.holdsLock(this));
        for (Dependency dependency : this.dependencies) {
            dependency.removeDemand();
        }
        ServiceControllerImpl<?> parent = this.parent;
        if (parent != null) {
            parent.removeDemand();
        }
    }

    void addDemand() {
        this.addDemands(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDemands(int demandedByCount) {
        assert (!Thread.holdsLock(this));
        ArrayList<Runnable> tasks = new ArrayList<Runnable>();
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            boolean propagate;
            int cnt = this.demandedByCount;
            this.demandedByCount += demandedByCount;
            boolean bl = propagate = cnt == 0 && this.mode.compareTo(ServiceController.Mode.NEVER) > 0;
            if (cnt == 0 && this.mode == ServiceController.Mode.ON_DEMAND) {
                assert (this.upperCount < 1);
                ++this.upperCount;
                this.transition(tasks);
            }
            if (propagate) {
                tasks.add(new DemandParentsTask());
            }
            this.asyncTasks += tasks.size();
        }
        this.doExecute(tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDemand() {
        assert (!Thread.holdsLock(this));
        ArrayList<Runnable> tasks = new ArrayList<Runnable>();
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            boolean propagate;
            int cnt = --this.demandedByCount;
            boolean bl = propagate = cnt == 0 && (this.mode == ServiceController.Mode.ON_DEMAND || this.mode == ServiceController.Mode.PASSIVE);
            if (cnt == 0 && this.mode == ServiceController.Mode.ON_DEMAND) {
                --this.upperCount;
                this.transition(tasks);
            }
            if (propagate) {
                tasks.add(new UndemandParentsTask());
            }
            this.asyncTasks += tasks.size();
        }
        this.doExecute(tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addChild(ServiceControllerImpl<?> child) {
        ArrayList<Runnable> tasks;
        assert (!Thread.holdsLock(this));
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            switch (this.state) {
                case STOP_REQUESTED: 
                case UP: 
                case START_INITIATING: 
                case STARTING: {
                    this.children.add(child);
                    tasks = new ArrayList<Runnable>();
                    this.newDependent(this.primaryRegistration.getName(), child, tasks);
                    break;
                }
                default: {
                    throw new IllegalStateException("Children cannot be added in state " + (Object)((Object)this.state.getState()));
                }
            }
            this.asyncTasks += tasks.size();
        }
        this.doExecute(tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeChild(ServiceControllerImpl<?> child) {
        ArrayList<Runnable> tasks;
        assert (!Thread.holdsLock(this));
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            block8: {
                block7: {
                    this.children.remove(child);
                    if (!this.children.isEmpty()) break block7;
                    switch (this.state) {
                        case STOPPING: 
                        case START_FAILED: {
                            --this.asyncTasks;
                            tasks = new ArrayList<Runnable>();
                            this.transition(tasks);
                            break block8;
                        }
                        default: {
                            return;
                        }
                    }
                }
                return;
            }
            this.asyncTasks += tasks.size();
        }
        this.doExecute(tasks);
    }

    IdentityHashSet<ServiceControllerImpl<?>> getChildren() {
        assert (Thread.holdsLock(this));
        return this.children;
    }

    @Override
    public ServiceController<?> getParent() {
        return this.parent;
    }

    @Override
    public ServiceContainerImpl getServiceContainer() {
        return this.primaryRegistration.getContainer();
    }

    @Override
    public ServiceController.State getState() {
        return this.state.getState();
    }

    @Override
    public S getValue() throws IllegalStateException {
        return (S)this.serviceValue.getValue().getValue();
    }

    @Override
    public ServiceName getName() {
        return this.primaryRegistration.getName();
    }

    @Override
    public ServiceName[] getAliases() {
        ServiceRegistrationImpl[] aliasRegistrations = this.aliasRegistrations;
        int len = aliasRegistrations.length;
        if (len == 0) {
            return NO_NAMES;
        }
        ServiceName[] names = new ServiceName[len];
        for (int i = 0; i < len; ++i) {
            names[i] = aliasRegistrations[i].getName();
        }
        return names;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(ServiceListener<? super S> listener) {
        Substate state;
        assert (!Thread.holdsLock(this));
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            state = this.state;
            if (state != Substate.REMOVED) {
                if (!this.listeners.add(listener)) {
                    throw new IllegalArgumentException("Listener " + listener + " already present on controller for " + this.primaryRegistration.getName());
                }
                if (state == Substate.NEW) {
                    return;
                }
                ++this.asyncTasks;
            } else {
                this.asyncTasks += 2;
            }
        }
        this.invokeListener(listener, ListenerNotification.LISTENER_ADDED, null);
        if (state == Substate.REMOVED) {
            this.invokeListener(listener, ListenerNotification.STATE, ServiceController.State.REMOVED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(ServiceListener<? super S> listener) {
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartException getStartException() {
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            return this.startException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void retry() {
        ArrayList<Runnable> tasks;
        assert (!Thread.holdsLock(this));
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            if (this.state.getState() != ServiceController.State.START_FAILED) {
                return;
            }
            --this.failCount;
            assert (this.failCount == 0);
            this.startException = null;
            tasks = new ArrayList<Runnable>();
            this.transition(tasks);
            this.asyncTasks += tasks.size();
        }
        this.doExecute(tasks);
    }

    @Override
    public synchronized Set<ServiceName> getImmediateUnavailableDependencies() {
        return this.immediateUnavailableDependencies.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceController.Mode getMode() {
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            return this.mode;
        }
    }

    @Override
    public boolean compareAndSetMode(ServiceController.Mode expectedMode, ServiceController.Mode newMode) {
        if (expectedMode == null) {
            throw new IllegalArgumentException("expectedMode is null");
        }
        return this.internalSetMode(expectedMode, newMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServiceStatus getStatus() {
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            String[] dependencyNames;
            String[] aliases;
            String parentName = this.parent == null ? null : this.parent.getName().getCanonicalName();
            String name = this.primaryRegistration.getName().getCanonicalName();
            ServiceRegistrationImpl[] aliasRegistrations = this.aliasRegistrations;
            int aliasLength = aliasRegistrations.length;
            if (aliasLength == 0) {
                aliases = NO_STRINGS;
            } else {
                aliases = new String[aliasLength];
                for (int i = 0; i < aliasLength; ++i) {
                    aliases[i] = aliasRegistrations[i].getName().getCanonicalName();
                }
            }
            String serviceClass = "<unknown>";
            try {
                Service<S> value = this.serviceValue.getValue();
                if (value != null) {
                    serviceClass = value.getClass().getName();
                }
            }
            catch (RuntimeException ignored) {
                // empty catch block
            }
            Dependency[] dependencies = this.dependencies;
            int dependenciesLength = dependencies.length;
            if (dependenciesLength == 0) {
                dependencyNames = NO_STRINGS;
            } else {
                dependencyNames = new String[dependenciesLength];
                for (int i = 0; i < dependenciesLength; ++i) {
                    dependencyNames[i] = dependencies[i].getName().getCanonicalName();
                }
            }
            StartException startException = this.startException;
            return new ServiceStatus(parentName, name, aliases, serviceClass, this.mode.name(), this.state.getState().name(), this.state.name(), dependencyNames, this.failCount != 0, startException != null ? startException.toString() : null, !this.immediateUnavailableDependencies.isEmpty() || this.transitiveUnavailableDepCount != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void invokeListener(ServiceListener<? super S> listener, ListenerNotification notification, ServiceController.State state) {
        assert (!Thread.holdsLock(this));
        try {
            switch (notification) {
                case LISTENER_ADDED: {
                    listener.listenerAdded(this);
                    return;
                }
                case STATE: {
                    switch (state) {
                        case DOWN: {
                            listener.serviceStopped(this);
                            return;
                        }
                        case STARTING: {
                            listener.serviceStarting(this);
                            return;
                        }
                        case START_FAILED: {
                            listener.serviceFailed(this, this.startException);
                            return;
                        }
                        case UP: {
                            listener.serviceStarted(this);
                            return;
                        }
                        case STOPPING: {
                            listener.serviceStopping(this);
                            return;
                        }
                        case REMOVED: {
                            listener.serviceRemoved(this);
                            return;
                        }
                    }
                    return;
                }
                case DEPENDENCY_FAILURE: {
                    listener.dependencyFailed(this);
                    return;
                }
                case DEPENDENCY_FAILURE_CLEAR: {
                    listener.dependencyFailureCleared(this);
                    return;
                }
                case IMMEDIATE_DEPENDENCY_UNAVAILABLE: {
                    listener.immediateDependencyUnavailable(this);
                    return;
                }
                case IMMEDIATE_DEPENDENCY_AVAILABLE: {
                    listener.immediateDependencyAvailable(this);
                    return;
                }
                case TRANSITIVE_DEPENDENCY_UNAVAILABLE: {
                    listener.transitiveDependencyUnavailable(this);
                    return;
                }
                case TRANSITIVE_DEPENDENCY_AVAILABLE: {
                    listener.transitiveDependencyAvailable(this);
                    return;
                }
                case DEPENDENCY_PROBLEM: {
                    listener.dependencyProblem(this);
                    return;
                }
                case DEPENDENCY_PROBLEM_CLEAR: {
                    listener.dependencyProblemCleared(this);
                    return;
                }
                case REMOVE_REQUESTED: {
                    listener.serviceRemoveRequested(this);
                    return;
                }
                case START_REQUESTED: {
                    listener.serviceStartRequested(this);
                    return;
                }
                case START_REQUEST_CLEARED: {
                    listener.serviceStartRequestCleared(this);
                    return;
                }
                case STOP_REQUESTED: {
                    listener.serviceStopRequested(this);
                    return;
                }
                case STOP_REQUEST_CLEARED: {
                    listener.serviceStopRequestCleared(this);
                    return;
                }
                case FAILED_STARTING: {
                    listener.failedServiceStarting(this);
                    return;
                }
                case FAILED_STOPPED: {
                    listener.failedServiceStopped(this);
                    return;
                }
                case WONT_START: {
                    listener.serviceWontStart(this);
                    return;
                }
                case WONT_START_CLEARED: {
                    listener.serviceWontStartCleared(this);
                    return;
                }
                case WAITING: {
                    listener.serviceWaiting(this);
                    return;
                }
                case WAITING_CLEARED: {
                    listener.serviceWaitingCleared(this);
                    return;
                }
            }
            return;
        }
        catch (Throwable t) {
            ServiceLogger.SERVICE.listenerFailed(t, listener);
            return;
        }
        finally {
            ArrayList<Runnable> tasks = new ArrayList<Runnable>();
            ServiceControllerImpl serviceControllerImpl = this;
            synchronized (serviceControllerImpl) {
                --this.asyncTasks;
                this.transition(tasks);
                this.asyncTasks += tasks.size();
            }
            this.doExecute(tasks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Substate getSubstate() {
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            return this.state;
        }
    }

    ServiceRegistrationImpl getPrimaryRegistration() {
        return this.primaryRegistration;
    }

    ServiceRegistrationImpl[] getAliasRegistrations() {
        return this.aliasRegistrations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dependent[][] getDependents() {
        IdentityHashSet<Dependent> dependentSet = this.primaryRegistration.getDependents();
        if (this.aliasRegistrations.length == 0) {
            IdentityHashSet<Dependent> identityHashSet = dependentSet;
            synchronized (identityHashSet) {
                return new Dependent[][]{dependentSet.toScatteredArray(NO_DEPENDENTS), this.children.toScatteredArray(NO_DEPENDENTS)};
            }
        }
        Dependent[][] dependents = new Dependent[this.aliasRegistrations.length + 2][];
        IdentityHashSet<Dependent> identityHashSet = dependentSet;
        synchronized (identityHashSet) {
            dependents[0] = dependentSet.toScatteredArray(NO_DEPENDENTS);
        }
        dependents[1] = this.children.toScatteredArray(NO_DEPENDENTS);
        for (int i = 0; i < this.aliasRegistrations.length; ++i) {
            IdentityHashSet<Dependent> aliasDependentSet;
            ServiceRegistrationImpl alias = this.aliasRegistrations[i];
            IdentityHashSet<Dependent> identityHashSet2 = aliasDependentSet = alias.getDependents();
            synchronized (identityHashSet2) {
                dependents[i + 2] = aliasDependentSet.toScatteredArray(NO_DEPENDENTS);
                continue;
            }
        }
        return dependents;
    }

    private Map<ServiceName, Dependent[]> getDependentsByDependencyName() {
        HashMap<ServiceName, Dependent[]> dependents = new HashMap<ServiceName, Dependent[]>();
        this.addDependentsByName(this.primaryRegistration, dependents);
        for (ServiceRegistrationImpl aliasRegistration : this.aliasRegistrations) {
            this.addDependentsByName(aliasRegistration, dependents);
        }
        return dependents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDependentsByName(ServiceRegistrationImpl registration, Map<ServiceName, Dependent[]> dependentsByName) {
        IdentityHashSet<Dependent> registrationDependents;
        IdentityHashSet<Dependent> identityHashSet = registrationDependents = registration.getDependents();
        synchronized (identityHashSet) {
            dependentsByName.put(registration.getName(), registrationDependents.toScatteredArray(NO_DEPENDENTS));
        }
    }

    private static <T> void doInject(ValueInjection<T> injection) {
        injection.getTarget().inject(injection.getSource().getValue());
    }

    public String toString() {
        return String.format("Controller for %s@%x", this.getName(), this.hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeProfileInfo(char statusChar, long startNanos, long endNanos) {
        ServiceRegistrationImpl primaryRegistration = this.primaryRegistration;
        ServiceName name = primaryRegistration.getName();
        ServiceContainerImpl container = primaryRegistration.getContainer();
        Writer profileOutput = container.getProfileOutput();
        if (profileOutput != null) {
            Writer writer = profileOutput;
            synchronized (writer) {
                try {
                    long startOffset = startNanos - container.getStart();
                    long duration = endNanos - startNanos;
                    profileOutput.write(String.format("%s\t%s\t%d\t%d\n", name.getCanonicalName(), Character.valueOf(statusChar), startOffset, duration));
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
    }

    static enum Transition {
        START_REQUESTED_to_DOWN(Substate.START_REQUESTED, Substate.DOWN),
        START_REQUESTED_to_PROBLEM(Substate.START_REQUESTED, Substate.PROBLEM),
        START_REQUESTED_to_START_INITIATING(Substate.START_REQUESTED, Substate.START_INITIATING),
        PROBLEM_to_START_REQUESTED(Substate.PROBLEM, Substate.START_REQUESTED),
        START_INITIATING_to_STARTING(Substate.START_INITIATING, Substate.STARTING),
        STARTING_to_UP(Substate.STARTING, Substate.UP),
        STARTING_to_START_FAILED(Substate.STARTING, Substate.START_FAILED),
        START_FAILED_to_STARTING(Substate.START_FAILED, Substate.START_INITIATING),
        START_FAILED_to_DOWN(Substate.START_FAILED, Substate.DOWN),
        UP_to_STOP_REQUESTED(Substate.UP, Substate.STOP_REQUESTED),
        STOP_REQUESTED_to_UP(Substate.STOP_REQUESTED, Substate.UP),
        STOP_REQUESTED_to_STOPPING(Substate.STOP_REQUESTED, Substate.STOPPING),
        STOPPING_to_DOWN(Substate.STOPPING, Substate.DOWN),
        REMOVING_to_REMOVED(Substate.REMOVING, Substate.REMOVED),
        DOWN_to_REMOVING(Substate.DOWN, Substate.REMOVING),
        DOWN_to_START_REQUESTED(Substate.DOWN, Substate.START_REQUESTED),
        DOWN_to_WAITING(Substate.DOWN, Substate.WAITING),
        DOWN_to_WONT_START(Substate.DOWN, Substate.WONT_START),
        WAITING_to_DOWN(Substate.WAITING, Substate.DOWN),
        WONT_START_to_DOWN(Substate.WONT_START, Substate.DOWN);

        private final Substate before;
        private final Substate after;

        private Transition(Substate before, Substate after) {
            this.before = before;
            this.after = after;
        }

        public Substate getBefore() {
            return this.before;
        }

        public Substate getAfter() {
            return this.after;
        }
    }

    static enum Substate {
        NEW(ServiceController.State.DOWN),
        CANCELLED(ServiceController.State.REMOVED),
        DOWN(ServiceController.State.DOWN),
        WAITING(ServiceController.State.DOWN),
        WONT_START(ServiceController.State.DOWN),
        PROBLEM(ServiceController.State.DOWN),
        START_REQUESTED(ServiceController.State.DOWN),
        START_INITIATING(ServiceController.State.STARTING),
        STARTING(ServiceController.State.STARTING),
        START_FAILED(ServiceController.State.START_FAILED),
        UP(ServiceController.State.UP),
        STOP_REQUESTED(ServiceController.State.UP),
        STOPPING(ServiceController.State.STOPPING),
        REMOVING(ServiceController.State.DOWN),
        REMOVED(ServiceController.State.REMOVED);

        private final ServiceController.State state;

        private Substate(ServiceController.State state) {
            this.state = state;
        }

        public ServiceController.State getState() {
            return this.state;
        }
    }

    private class StopContextImpl
    implements StopContext {
        private ContextState state = ContextState.SYNC;
        private final long startNanos;

        private StopContextImpl(long startNanos) {
            this.startNanos = startNanos;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void asynchronous() throws IllegalStateException {
            ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
            synchronized (serviceControllerImpl) {
                if (this.state != ContextState.SYNC) {
                    throw new IllegalStateException(ServiceControllerImpl.ILLEGAL_CONTROLLER_STATE);
                }
                this.state = ContextState.ASYNC;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void complete() throws IllegalStateException {
            ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
            synchronized (serviceControllerImpl) {
                if (this.state != ContextState.ASYNC) {
                    throw new IllegalStateException(ServiceControllerImpl.ILLEGAL_CONTROLLER_STATE);
                }
                this.state = ContextState.COMPLETE;
            }
            for (ValueInjection injection : ServiceControllerImpl.this.injections) {
                injection.getTarget().uninject();
            }
            ArrayList<Runnable> tasks = new ArrayList<Runnable>();
            ServiceControllerImpl serviceControllerImpl2 = ServiceControllerImpl.this;
            synchronized (serviceControllerImpl2) {
                if (ServiceContainerImpl.PROFILE_OUTPUT != null) {
                    ServiceControllerImpl.this.writeProfileInfo('X', this.startNanos, System.nanoTime());
                }
                ServiceControllerImpl.this.asyncTasks--;
                ServiceControllerImpl.this.transition(tasks);
                ServiceControllerImpl.this.asyncTasks += tasks.size();
            }
            ServiceControllerImpl.this.doExecute(tasks);
        }

        @Override
        public ServiceController<?> getController() {
            return ServiceControllerImpl.this;
        }

        @Override
        public void execute(Runnable command) {
            ServiceControllerImpl.this.doExecute(command);
        }

        @Override
        public long getElapsedTime() {
            return System.nanoTime() - ServiceControllerImpl.this.lifecycleTime;
        }
    }

    private final class ChildServiceTarget
    extends ServiceTargetImpl {
        private volatile boolean valid;

        private ChildServiceTarget(ServiceTargetImpl parentTarget) {
            super(parentTarget);
            this.valid = true;
        }

        @Override
        <T> ServiceController<T> install(ServiceBuilderImpl<T> serviceBuilder) throws ServiceRegistryException {
            if (!this.valid) {
                throw new IllegalStateException("Service target is no longer valid");
            }
            return super.install(serviceBuilder);
        }

        @Override
        protected <T> ServiceBuilder<T> createServiceBuilder(ServiceName name, Value<? extends Service<T>> value, ServiceControllerImpl<?> parent) throws IllegalArgumentException {
            return super.createServiceBuilder(name, value, ServiceControllerImpl.this);
        }

        @Override
        public ServiceTarget subTarget() {
            return new ChildServiceTarget(this);
        }
    }

    private class StartContextImpl
    implements StartContext {
        private ContextState state = ContextState.SYNC;
        private final long startNanos;

        private StartContextImpl(long startNanos) {
            this.startNanos = startNanos;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void failed(StartException reason) throws IllegalStateException {
            ArrayList<Runnable> tasks = new ArrayList<Runnable>();
            ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
            synchronized (serviceControllerImpl) {
                if (this.state != ContextState.ASYNC) {
                    throw new IllegalStateException(ServiceControllerImpl.ILLEGAL_CONTROLLER_STATE);
                }
                if (reason == null) {
                    reason = new StartException("Start failed, and additionally, a null cause was supplied");
                }
                this.state = ContextState.FAILED;
                ServiceName serviceName = ServiceControllerImpl.this.getName();
                reason.setServiceName(serviceName);
                ServiceLogger.FAIL.startFailed(reason, serviceName);
                ServiceControllerImpl.this.startException = reason;
                ServiceControllerImpl.this.failCount++;
                if (ServiceContainerImpl.PROFILE_OUTPUT != null) {
                    ServiceControllerImpl.this.writeProfileInfo('F', this.startNanos, System.nanoTime());
                }
                ServiceControllerImpl.this.asyncTasks--;
                ServiceControllerImpl.this.transition(tasks);
                ServiceControllerImpl.this.asyncTasks += tasks.size();
            }
            ServiceControllerImpl.this.doExecute(tasks);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ServiceTarget getChildTarget() {
            ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
            synchronized (serviceControllerImpl) {
                if (this.state == ContextState.COMPLETE || this.state == ContextState.FAILED) {
                    throw new IllegalStateException("Lifecycle context is no longer valid");
                }
                if (ServiceControllerImpl.this.childTarget == null) {
                    ServiceControllerImpl.this.childTarget = new ChildServiceTarget(ServiceControllerImpl.this.parent == null ? ServiceControllerImpl.this.getServiceContainer() : ((ServiceControllerImpl)ServiceControllerImpl.this.parent).childTarget);
                }
                return ServiceControllerImpl.this.childTarget;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void asynchronous() throws IllegalStateException {
            ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
            synchronized (serviceControllerImpl) {
                if (this.state != ContextState.SYNC) {
                    throw new IllegalStateException(ServiceControllerImpl.ILLEGAL_CONTROLLER_STATE);
                }
                this.state = ContextState.ASYNC;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void complete() throws IllegalStateException {
            ArrayList<Runnable> tasks = new ArrayList<Runnable>();
            ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
            synchronized (serviceControllerImpl) {
                if (this.state != ContextState.ASYNC) {
                    throw new IllegalStateException(ServiceControllerImpl.ILLEGAL_CONTROLLER_STATE);
                }
                this.state = ContextState.COMPLETE;
                if (ServiceContainerImpl.PROFILE_OUTPUT != null) {
                    ServiceControllerImpl.this.writeProfileInfo('S', this.startNanos, System.nanoTime());
                }
                ServiceControllerImpl.this.asyncTasks--;
                ServiceControllerImpl.this.transition(tasks);
                ServiceControllerImpl.this.asyncTasks += tasks.size();
            }
            ServiceControllerImpl.this.doExecute(tasks);
        }

        @Override
        public long getElapsedTime() {
            return System.nanoTime() - ServiceControllerImpl.this.lifecycleTime;
        }

        @Override
        public ServiceController<?> getController() {
            return ServiceControllerImpl.this;
        }

        @Override
        public void execute(Runnable command) {
            ServiceControllerImpl.this.doExecute(command);
        }
    }

    private class RemoveTask
    implements Runnable {
        RemoveTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                assert (ServiceControllerImpl.this.getMode() == ServiceController.Mode.REMOVE);
                assert (ServiceControllerImpl.this.getSubstate() == Substate.REMOVING || ServiceControllerImpl.this.getSubstate() == Substate.CANCELLED);
                ServiceControllerImpl.this.primaryRegistration.clearInstance(ServiceControllerImpl.this);
                for (ServiceRegistrationImpl registration : ServiceControllerImpl.this.aliasRegistrations) {
                    registration.clearInstance(ServiceControllerImpl.this);
                }
                for (Dependency dependency : ServiceControllerImpl.this.dependencies) {
                    dependency.removeDependent(ServiceControllerImpl.this);
                }
                ServiceControllerImpl parent = ServiceControllerImpl.this.parent;
                if (parent != null) {
                    parent.removeChild(ServiceControllerImpl.this);
                }
                ArrayList<Runnable> tasks = new ArrayList<Runnable>();
                ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
                synchronized (serviceControllerImpl) {
                    ServiceControllerImpl.this.asyncTasks--;
                    ServiceControllerImpl.this.transition(tasks);
                    ServiceControllerImpl.this.asyncTasks += tasks.size();
                }
                ServiceControllerImpl.this.doExecute(tasks);
            }
            catch (Throwable t) {
                ServiceLogger.SERVICE.internalServiceError(t, ServiceControllerImpl.this.primaryRegistration.getName());
            }
        }
    }

    private class DependencyUnavailableTask
    implements Runnable {
        private final Dependent[][] dependents;

        DependencyUnavailableTask(Dependent[][] dependents) {
            this.dependents = dependents;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Dependent[][] arr$ = this.dependents;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Dependent[] dependentArray;
                    for (Dependent dependent : dependentArray = arr$[i$]) {
                        if (dependent == null) continue;
                        dependent.transitiveDependencyUnavailable();
                    }
                }
                ArrayList<Runnable> tasks = new ArrayList<Runnable>();
                ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
                synchronized (serviceControllerImpl) {
                    ServiceControllerImpl.this.asyncTasks--;
                    ServiceControllerImpl.this.transition(tasks);
                    ServiceControllerImpl.this.asyncTasks += tasks.size();
                }
                ServiceControllerImpl.this.doExecute(tasks);
            }
            catch (Throwable t) {
                ServiceLogger.SERVICE.internalServiceError(t, ServiceControllerImpl.this.primaryRegistration.getName());
            }
        }
    }

    private class DependencyAvailableTask
    implements Runnable {
        private final Dependent[][] dependents;

        DependencyAvailableTask(Dependent[][] dependents) {
            this.dependents = dependents;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Dependent[][] arr$ = this.dependents;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Dependent[] dependentArray;
                    for (Dependent dependent : dependentArray = arr$[i$]) {
                        if (dependent == null) continue;
                        dependent.transitiveDependencyAvailable();
                    }
                }
                ArrayList<Runnable> tasks = new ArrayList<Runnable>();
                ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
                synchronized (serviceControllerImpl) {
                    ServiceControllerImpl.this.asyncTasks--;
                    ServiceControllerImpl.this.transition(tasks);
                    ServiceControllerImpl.this.asyncTasks += tasks.size();
                }
                ServiceControllerImpl.this.doExecute(tasks);
            }
            catch (Throwable t) {
                ServiceLogger.SERVICE.internalServiceError(t, ServiceControllerImpl.this.primaryRegistration.getName());
            }
        }
    }

    private class DependencyRetryingTask
    implements Runnable {
        private final Dependent[][] dependents;

        DependencyRetryingTask(Dependent[][] dependents) {
            this.dependents = dependents;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Dependent[][] arr$ = this.dependents;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Dependent[] dependentArray;
                    for (Dependent dependent : dependentArray = arr$[i$]) {
                        if (dependent == null) continue;
                        dependent.dependencyFailureCleared();
                    }
                }
                ArrayList<Runnable> tasks = new ArrayList<Runnable>();
                ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
                synchronized (serviceControllerImpl) {
                    ServiceControllerImpl.this.asyncTasks--;
                    ServiceControllerImpl.this.transition(tasks);
                    ServiceControllerImpl.this.asyncTasks += tasks.size();
                }
                ServiceControllerImpl.this.doExecute(tasks);
            }
            catch (Throwable t) {
                ServiceLogger.SERVICE.internalServiceError(t, ServiceControllerImpl.this.primaryRegistration.getName());
            }
        }
    }

    private class DependencyFailedTask
    implements Runnable {
        private final Dependent[][] dependents;

        DependencyFailedTask(Dependent[][] dependents) {
            this.dependents = dependents;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Dependent[][] arr$ = this.dependents;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Dependent[] dependentArray;
                    for (Dependent dependent : dependentArray = arr$[i$]) {
                        if (dependent == null) continue;
                        dependent.dependencyFailed();
                    }
                }
                ArrayList<Runnable> tasks = new ArrayList<Runnable>();
                ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
                synchronized (serviceControllerImpl) {
                    ServiceControllerImpl.this.asyncTasks--;
                    ServiceControllerImpl.this.transition(tasks);
                    ServiceControllerImpl.this.asyncTasks += tasks.size();
                }
                ServiceControllerImpl.this.doExecute(tasks);
            }
            catch (Throwable t) {
                ServiceLogger.SERVICE.internalServiceError(t, ServiceControllerImpl.this.primaryRegistration.getName());
            }
        }
    }

    private class DependencyStoppedTask
    implements Runnable {
        private final Dependent[][] dependents;

        DependencyStoppedTask(Dependent[][] dependents) {
            this.dependents = dependents;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Dependent[][] arr$ = this.dependents;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Dependent[] dependentArray;
                    for (Dependent dependent : dependentArray = arr$[i$]) {
                        if (dependent == null) continue;
                        dependent.immediateDependencyDown();
                    }
                }
                ArrayList<Runnable> tasks = new ArrayList<Runnable>();
                ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
                synchronized (serviceControllerImpl) {
                    ServiceControllerImpl.this.asyncTasks--;
                    ServiceControllerImpl.this.transition(tasks);
                    ServiceControllerImpl.this.asyncTasks += tasks.size();
                }
                ServiceControllerImpl.this.doExecute(tasks);
            }
            catch (Throwable t) {
                ServiceLogger.SERVICE.internalServiceError(t, ServiceControllerImpl.this.primaryRegistration.getName());
            }
        }
    }

    private class DependencyStartedTask
    implements Runnable {
        private final Dependent[][] dependents;

        DependencyStartedTask(Dependent[][] dependents) {
            this.dependents = dependents;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Dependent[][] arr$ = this.dependents;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Dependent[] dependentArray;
                    for (Dependent dependent : dependentArray = arr$[i$]) {
                        if (dependent == null) continue;
                        dependent.immediateDependencyUp();
                    }
                }
                ArrayList<Runnable> tasks = new ArrayList<Runnable>();
                ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
                synchronized (serviceControllerImpl) {
                    ServiceControllerImpl.this.asyncTasks--;
                    ServiceControllerImpl.this.transition(tasks);
                    ServiceControllerImpl.this.asyncTasks += tasks.size();
                }
                ServiceControllerImpl.this.doExecute(tasks);
            }
            catch (Throwable t) {
                ServiceLogger.SERVICE.internalServiceError(t, ServiceControllerImpl.this.primaryRegistration.getName());
            }
        }
    }

    private class ListenerTask
    implements Runnable {
        private final ListenerNotification notification;
        private final ServiceListener<? super S> listener;
        private final ServiceController.State state;

        ListenerTask(ServiceListener<? super S> listener, ServiceController.State state) {
            this.listener = listener;
            this.state = state;
            this.notification = ListenerNotification.STATE;
        }

        ListenerTask(ServiceListener<? super S> listener, ListenerNotification notification) {
            this.listener = listener;
            this.state = null;
            this.notification = notification;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            assert (!Thread.holdsLock(ServiceControllerImpl.this));
            if (ServiceContainerImpl.PROFILE_OUTPUT != null) {
                long start = System.nanoTime();
                try {
                    ServiceControllerImpl.this.invokeListener(this.listener, this.notification, this.state);
                }
                finally {
                    ServiceControllerImpl.this.writeProfileInfo('L', start, System.nanoTime());
                }
            } else {
                ServiceControllerImpl.this.invokeListener(this.listener, this.notification, this.state);
            }
        }
    }

    private class StopTask
    implements Runnable {
        private final boolean onlyUninject;

        StopTask(boolean onlyUninject) {
            this.onlyUninject = onlyUninject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block21: {
                assert (!Thread.holdsLock(ServiceControllerImpl.this));
                ServiceName serviceName = ServiceControllerImpl.this.primaryRegistration.getName();
                long startNanos = System.nanoTime();
                StopContextImpl context = new StopContextImpl(startNanos);
                boolean ok = false;
                try {
                    if (this.onlyUninject) break block21;
                    try {
                        Service service = (Service)ServiceControllerImpl.this.serviceValue.getValue();
                        if (service != null) {
                            service.stop(context);
                            ok = true;
                            break block21;
                        }
                        ServiceLogger.ROOT.stopServiceMissing(serviceName);
                    }
                    catch (Throwable t) {
                        ServiceLogger.FAIL.stopFailed(t, serviceName);
                    }
                }
                finally {
                    ArrayList<Runnable> tasks;
                    ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
                    synchronized (serviceControllerImpl) {
                        if (ok && context.state != ContextState.SYNC) {
                            return;
                        }
                        context.state = ContextState.COMPLETE;
                    }
                    this.uninject(serviceName, ServiceControllerImpl.this.injections);
                    this.uninject(serviceName, ServiceControllerImpl.this.outInjections);
                    serviceControllerImpl = ServiceControllerImpl.this;
                    synchronized (serviceControllerImpl) {
                        if (ServiceContainerImpl.PROFILE_OUTPUT != null) {
                            ServiceControllerImpl.this.writeProfileInfo('X', startNanos, System.nanoTime());
                        }
                        ServiceControllerImpl.this.asyncTasks--;
                        tasks = new ArrayList<Runnable>();
                        ServiceControllerImpl.this.transition(tasks);
                        ServiceControllerImpl.this.asyncTasks += tasks.size();
                    }
                    ServiceControllerImpl.this.doExecute(tasks);
                }
            }
        }

        private void uninject(ServiceName serviceName, ValueInjection<?>[] injections) {
            for (ValueInjection<?> injection : injections) {
                try {
                    injection.getTarget().uninject();
                }
                catch (Throwable t) {
                    ServiceLogger.ROOT.uninjectFailed(t, serviceName, injection);
                }
            }
        }
    }

    private class StartTask
    implements Runnable {
        private final boolean doInjection;

        StartTask(boolean doInjection) {
            this.doInjection = doInjection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            assert (!Thread.holdsLock(ServiceControllerImpl.this));
            ServiceName serviceName = ServiceControllerImpl.this.primaryRegistration.getName();
            long startNanos = System.nanoTime();
            StartContextImpl context = new StartContextImpl(startNanos);
            try {
                this.performInjections();
                Service service = (Service)ServiceControllerImpl.this.serviceValue.getValue();
                if (service == null) {
                    throw new IllegalArgumentException("Service is null");
                }
                service.start(context);
                ArrayList<Runnable> tasks = new ArrayList<Runnable>();
                ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
                synchronized (serviceControllerImpl) {
                    if (context.state != ContextState.SYNC) {
                        return;
                    }
                    context.state = ContextState.COMPLETE;
                    if (ServiceContainerImpl.PROFILE_OUTPUT != null) {
                        ServiceControllerImpl.this.writeProfileInfo('S', startNanos, System.nanoTime());
                    }
                    ServiceControllerImpl.this.asyncTasks--;
                    ServiceControllerImpl.this.transition(tasks);
                    ServiceControllerImpl.this.asyncTasks += tasks.size();
                }
                this.performOutInjections(serviceName);
                ServiceControllerImpl.this.doExecute(tasks);
            }
            catch (StartException e) {
                e.setServiceName(serviceName);
                this.startFailed(e, serviceName, context, startNanos);
            }
            catch (Throwable t) {
                StartException e = new StartException("Failed to start service", t, ServiceControllerImpl.this.location, serviceName);
                this.startFailed(e, serviceName, context, startNanos);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void performInjections() {
            if (this.doInjection) {
                int i;
                int injectionsLength = ServiceControllerImpl.this.injections.length;
                boolean ok = false;
                try {
                    for (i = 0; i < injectionsLength; ++i) {
                        ValueInjection injection = ServiceControllerImpl.this.injections[i];
                        ServiceControllerImpl.doInject(injection);
                    }
                    ok = true;
                }
                finally {
                    if (!ok) {
                        while (i >= 0) {
                            ServiceControllerImpl.this.injections[i].getTarget().uninject();
                            --i;
                        }
                    }
                }
            }
        }

        private void performOutInjections(ServiceName serviceName) {
            if (this.doInjection) {
                int injectionsLength = ServiceControllerImpl.this.outInjections.length;
                for (int i = 0; i < injectionsLength; ++i) {
                    ValueInjection injection = ServiceControllerImpl.this.outInjections[i];
                    try {
                        ServiceControllerImpl.doInject(injection);
                        continue;
                    }
                    catch (Throwable t) {
                        ServiceLogger.SERVICE.exceptionAfterComplete(t, serviceName);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startFailed(StartException e, ServiceName serviceName, StartContextImpl context, long startNanos) {
            ArrayList<Runnable> tasks;
            ServiceLogger.FAIL.startFailed(e, serviceName);
            ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
            synchronized (serviceControllerImpl) {
                ContextState oldState = context.state;
                if (oldState != ContextState.SYNC && oldState != ContextState.ASYNC) {
                    ServiceLogger.FAIL.exceptionAfterComplete(e, serviceName);
                    return;
                }
                context.state = ContextState.FAILED;
                ServiceControllerImpl.this.startException = e;
                if (ServiceContainerImpl.PROFILE_OUTPUT != null) {
                    ServiceControllerImpl.this.writeProfileInfo('F', startNanos, System.nanoTime());
                }
                ServiceControllerImpl.this.failCount++;
                ServiceControllerImpl.this.asyncTasks--;
                tasks = new ArrayList<Runnable>();
                ServiceControllerImpl.this.transition(tasks);
                ServiceControllerImpl.this.asyncTasks += tasks.size();
            }
            ServiceControllerImpl.this.doExecute(tasks);
        }
    }

    private class ServiceAvailableTask
    implements Runnable {
        private final Map<ServiceName, Dependent[]> dependents;
        private final Dependent[] children;

        public ServiceAvailableTask() {
            this.dependents = ServiceControllerImpl.this.getDependentsByDependencyName();
            this.children = ServiceControllerImpl.this.children.toScatteredArray(NO_DEPENDENTS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                for (Map.Entry<ServiceName, Dependent[]> dependentEntry : this.dependents.entrySet()) {
                    ServiceName serviceName = dependentEntry.getKey();
                    for (Dependent dependent : dependentEntry.getValue()) {
                        if (dependent == null) continue;
                        dependent.immediateDependencyAvailable(serviceName);
                    }
                }
                ServiceName primaryRegistrationName = ServiceControllerImpl.this.primaryRegistration.getName();
                for (Dependent child : this.children) {
                    if (child == null) continue;
                    child.immediateDependencyAvailable(primaryRegistrationName);
                }
                ArrayList<Runnable> tasks = new ArrayList<Runnable>();
                ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
                synchronized (serviceControllerImpl) {
                    ServiceControllerImpl.this.asyncTasks--;
                    ServiceControllerImpl.this.transition(tasks);
                    ServiceControllerImpl.this.asyncTasks += tasks.size();
                }
                ServiceControllerImpl.this.doExecute(tasks);
            }
            catch (Throwable t) {
                ServiceLogger.SERVICE.internalServiceError(t, ServiceControllerImpl.this.primaryRegistration.getName());
            }
        }
    }

    private class ServiceUnavailableTask
    implements Runnable {
        private final Map<ServiceName, Dependent[]> dependents;
        private final Dependent[] children;

        public ServiceUnavailableTask() {
            this.dependents = ServiceControllerImpl.this.getDependentsByDependencyName();
            this.children = ServiceControllerImpl.this.children.toScatteredArray(NO_DEPENDENTS);
        }

        public ServiceUnavailableTask(ServiceName serviceName, Dependent dependent) {
            this.dependents = new HashMap<ServiceName, Dependent[]>(1);
            this.dependents.put(serviceName, new Dependent[]{dependent});
            this.children = NO_DEPENDENTS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                for (Map.Entry<ServiceName, Dependent[]> dependentEntry : this.dependents.entrySet()) {
                    ServiceName serviceName = dependentEntry.getKey();
                    for (Dependent dependent : dependentEntry.getValue()) {
                        if (dependent == null) continue;
                        dependent.immediateDependencyUnavailable(serviceName);
                    }
                }
                ServiceName primaryRegistrationName = ServiceControllerImpl.this.primaryRegistration.getName();
                for (Dependent child : this.children) {
                    if (child == null) continue;
                    child.immediateDependencyUnavailable(primaryRegistrationName);
                }
                ArrayList<Runnable> tasks = new ArrayList<Runnable>();
                ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
                synchronized (serviceControllerImpl) {
                    ServiceControllerImpl.this.asyncTasks--;
                    ServiceControllerImpl.this.transition(tasks);
                    ServiceControllerImpl.this.asyncTasks += tasks.size();
                }
                ServiceControllerImpl.this.doExecute(tasks);
            }
            catch (Throwable t) {
                ServiceLogger.SERVICE.internalServiceError(t, ServiceControllerImpl.this.primaryRegistration.getName());
            }
        }
    }

    private class DependentStartedTask
    implements Runnable {
        private DependentStartedTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                for (Dependency dependency : ServiceControllerImpl.this.dependencies) {
                    dependency.dependentStarted();
                }
                ServiceControllerImpl parent = ServiceControllerImpl.this.parent;
                if (parent != null) {
                    parent.dependentStarted();
                }
                ArrayList<Runnable> tasks = new ArrayList<Runnable>();
                ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
                synchronized (serviceControllerImpl) {
                    ServiceControllerImpl.this.asyncTasks--;
                    ServiceControllerImpl.this.transition(tasks);
                    ServiceControllerImpl.this.asyncTasks += tasks.size();
                }
                ServiceControllerImpl.this.doExecute(tasks);
            }
            catch (Throwable t) {
                ServiceLogger.SERVICE.internalServiceError(t, ServiceControllerImpl.this.primaryRegistration.getName());
            }
        }
    }

    private class DependentStoppedTask
    implements Runnable {
        private DependentStoppedTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                for (Dependency dependency : ServiceControllerImpl.this.dependencies) {
                    dependency.dependentStopped();
                }
                ServiceControllerImpl parent = ServiceControllerImpl.this.parent;
                if (parent != null) {
                    parent.dependentStopped();
                }
                ArrayList<Runnable> tasks = new ArrayList<Runnable>();
                ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
                synchronized (serviceControllerImpl) {
                    ServiceControllerImpl.this.asyncTasks--;
                    ServiceControllerImpl.this.transition(tasks);
                    ServiceControllerImpl.this.asyncTasks += tasks.size();
                }
                ServiceControllerImpl.this.doExecute(tasks);
            }
            catch (Throwable t) {
                ServiceLogger.SERVICE.internalServiceError(t, ServiceControllerImpl.this.primaryRegistration.getName());
            }
        }
    }

    private class UndemandParentsTask
    implements Runnable {
        private UndemandParentsTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ServiceControllerImpl.this.doUndemandParents();
                ArrayList<Runnable> tasks = new ArrayList<Runnable>();
                ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
                synchronized (serviceControllerImpl) {
                    ServiceControllerImpl.this.asyncTasks--;
                    ServiceControllerImpl.this.transition(tasks);
                    ServiceControllerImpl.this.asyncTasks += tasks.size();
                }
                ServiceControllerImpl.this.doExecute(tasks);
            }
            catch (Throwable t) {
                ServiceLogger.SERVICE.internalServiceError(t, ServiceControllerImpl.this.primaryRegistration.getName());
            }
        }
    }

    private class DemandParentsTask
    implements Runnable {
        private DemandParentsTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ServiceControllerImpl.this.doDemandParents();
                ArrayList<Runnable> tasks = new ArrayList<Runnable>();
                ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
                synchronized (serviceControllerImpl) {
                    ServiceControllerImpl.this.asyncTasks--;
                    ServiceControllerImpl.this.transition(tasks);
                    ServiceControllerImpl.this.asyncTasks += tasks.size();
                }
                ServiceControllerImpl.this.doExecute(tasks);
            }
            catch (Throwable t) {
                ServiceLogger.SERVICE.internalServiceError(t, ServiceControllerImpl.this.primaryRegistration.getName());
            }
        }
    }

    static enum ContextState {
        SYNC,
        ASYNC,
        COMPLETE,
        FAILED;

    }

    private static enum ListenerNotification {
        LISTENER_ADDED,
        STATE,
        START_REQUESTED,
        START_REQUEST_CLEARED,
        STOP_REQUESTED,
        STOP_REQUEST_CLEARED,
        WONT_START,
        WONT_START_CLEARED,
        WAITING,
        WAITING_CLEARED,
        DEPENDENCY_FAILURE,
        DEPENDENCY_FAILURE_CLEAR,
        IMMEDIATE_DEPENDENCY_UNAVAILABLE,
        IMMEDIATE_DEPENDENCY_AVAILABLE,
        TRANSITIVE_DEPENDENCY_UNAVAILABLE,
        TRANSITIVE_DEPENDENCY_AVAILABLE,
        DEPENDENCY_PROBLEM,
        DEPENDENCY_PROBLEM_CLEAR,
        REMOVE_REQUESTED,
        FAILED_STARTING,
        FAILED_STOPPED;

    }
}

