/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jboss.msc.service.MultipleRemoveListener;
import org.jboss.msc.service.ServiceController;

public final class ServiceUtils {
    private ServiceUtils() {
    }

    public static void undeployAll(Runnable completeTask, ServiceController<?> ... controllers) {
        ServiceUtils.undeployAll(completeTask, controllers == null ? Collections.emptyList() : Arrays.asList(controllers));
    }

    public static void undeployAll(Runnable completeTask, List<ServiceController<?>> controllers) {
        MultipleRemoveListener<Runnable> listener = MultipleRemoveListener.create(completeTask);
        for (ServiceController serviceController : controllers == null ? Collections.emptyList() : controllers) {
            if (serviceController == null) continue;
            serviceController.setMode(ServiceController.Mode.REMOVE);
            serviceController.addListener(listener);
        }
        listener.done();
    }
}

