/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import org.jboss.msc.service.Location;
import org.jboss.msc.service.ServiceName;

public class StartException
extends Exception {
    private static final long serialVersionUID = 239274385917008839L;
    private final Location location;
    private volatile ServiceName serviceName;

    public StartException() {
        this.location = null;
        this.serviceName = null;
    }

    public StartException(String msg) {
        super(msg);
        this.location = null;
        this.serviceName = null;
    }

    public StartException(Throwable cause) {
        super(cause);
        this.location = null;
        this.serviceName = null;
    }

    public StartException(String msg, Throwable cause) {
        super(msg, cause);
        this.location = null;
        this.serviceName = null;
    }

    public StartException(Location location) {
        this.location = location;
        this.serviceName = null;
    }

    public StartException(String message, Location location) {
        super(message);
        this.location = location;
        this.serviceName = null;
    }

    public StartException(String message, Throwable cause, Location location) {
        super(message, cause);
        this.location = location;
        this.serviceName = null;
    }

    public StartException(Throwable cause, Location location) {
        super(cause);
        this.location = location;
        this.serviceName = null;
    }

    public StartException(String message, Throwable cause, Location location, ServiceName serviceName) {
        super(message, cause);
        this.location = location;
        this.serviceName = serviceName;
    }

    public ServiceName getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(ServiceName serviceName) {
        this.serviceName = serviceName;
    }

    @Override
    public String toString() {
        Location location;
        StringBuilder b = new StringBuilder(this.getClass().getName());
        if (this.serviceName != null) {
            b.append(" in ").append(this.serviceName);
        } else {
            b.append(" in anonymous service");
        }
        String m = this.getLocalizedMessage();
        if (m != null) {
            b.append(": ").append(m);
        }
        if ((location = this.location) != null) {
            b.append("\n\tAt file ").append(location);
        }
        return b.toString();
    }
}

