/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.StartException;

public final class TimingServiceListener
extends AbstractServiceListener<Object>
implements ServiceListener<Object> {
    private volatile int finished = 0;
    private volatile int count = 1;
    private volatile int totalServices = 0;
    private final long start = System.currentTimeMillis();
    private volatile long end;
    private final Runnable finishedTask;
    private static final AtomicIntegerFieldUpdater<TimingServiceListener> finishedUpdater = AtomicIntegerFieldUpdater.newUpdater(TimingServiceListener.class, "finished");
    private static final AtomicIntegerFieldUpdater<TimingServiceListener> countUpdater = AtomicIntegerFieldUpdater.newUpdater(TimingServiceListener.class, "count");
    private static final AtomicIntegerFieldUpdater<TimingServiceListener> totalServicesUpdater = AtomicIntegerFieldUpdater.newUpdater(TimingServiceListener.class, "totalServices");

    public TimingServiceListener() {
        this.finishedTask = null;
    }

    public TimingServiceListener(Runnable finishedTask) {
        this.finishedTask = finishedTask;
    }

    @Override
    public void listenerAdded(ServiceController<? extends Object> serviceController) {
        countUpdater.incrementAndGet(this);
        totalServicesUpdater.incrementAndGet(this);
    }

    @Override
    public void serviceStarted(ServiceController<? extends Object> serviceController) {
        if (countUpdater.decrementAndGet(this) == 0) {
            this.done();
        }
        serviceController.removeListener(this);
    }

    @Override
    public void serviceFailed(ServiceController<? extends Object> serviceController, StartException reason) {
        if (countUpdater.decrementAndGet(this) == 0) {
            this.done();
        }
        serviceController.removeListener(this);
    }

    private void done() {
        this.end = System.currentTimeMillis();
        if (this.finishedTask != null) {
            this.finishedTask.run();
        }
    }

    public void finishBatch() {
        if (finishedUpdater.getAndSet(this, 1) == 0 && countUpdater.decrementAndGet(this) == 0) {
            this.done();
        }
    }

    public boolean finished() {
        return this.finished != 0;
    }

    public int getRemainingCount() {
        return this.count;
    }

    public int getTotalCount() {
        return this.totalServices;
    }

    public long getElapsedTime() {
        long end = this.end;
        if (end == 0L) {
            return -1L;
        }
        return end - this.start;
    }
}

