/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.value;

import java.lang.reflect.Field;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.msc.value.Value;

@Deprecated
public final class LookupDeclaredFieldValue
implements Value<Field> {
    private final Value<Class<?>> target;
    private final String fieldName;
    private final AccessControlContext context;
    private final boolean makeAccessible;

    public LookupDeclaredFieldValue(Value<Class<?>> target, String fieldName, AccessControlContext context, boolean makeAccessible) {
        if (target == null) {
            throw new IllegalArgumentException("target is null");
        }
        if (fieldName == null) {
            throw new IllegalArgumentException("fieldName is null");
        }
        if (context == null) {
            throw new IllegalArgumentException("context is null");
        }
        this.target = target;
        this.fieldName = fieldName;
        this.context = context;
        this.makeAccessible = makeAccessible;
    }

    @Override
    public Field getValue() throws IllegalStateException {
        final Class<?> targetClass = this.target.getValue();
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<Field>(){

                @Override
                public Field run() {
                    try {
                        Field field = targetClass.getDeclaredField(LookupDeclaredFieldValue.this.fieldName);
                        if (LookupDeclaredFieldValue.this.makeAccessible) {
                            field.setAccessible(true);
                        }
                        return field;
                    }
                    catch (NoSuchFieldException e) {
                        throw new IllegalStateException("No such field '" + LookupDeclaredFieldValue.this.fieldName + "' found on " + targetClass);
                    }
                }
            }, this.context);
        }
        try {
            Field field = targetClass.getDeclaredField(this.fieldName);
            if (this.makeAccessible) {
                field.setAccessible(true);
            }
            return field;
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException("No such field '" + this.fieldName + "' found on " + targetClass);
        }
    }
}

