/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.value;

import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import org.jboss.msc.value.ErrorMessage;
import org.jboss.msc.value.Value;

@Deprecated
public final class LookupDeclaredMethodValue
implements Value<Method> {
    private final Value<Class<?>> target;
    private final String methodName;
    private final List<? extends Value<Class<?>>> parameterTypes;
    private final AccessControlContext context;
    private final boolean makeAccessible;
    private final int paramCount;

    public LookupDeclaredMethodValue(Value<Class<?>> target, String methodName, List<? extends Value<Class<?>>> parameterTypes, AccessControlContext context, boolean makeAccessible) {
        if (target == null) {
            throw new IllegalArgumentException("target is null");
        }
        if (methodName == null) {
            throw new IllegalArgumentException("methodName is null");
        }
        if (parameterTypes == null) {
            throw new IllegalArgumentException("parameterTypes is null");
        }
        if (context == null) {
            throw new IllegalArgumentException("context is null");
        }
        this.target = target;
        this.methodName = methodName;
        this.parameterTypes = parameterTypes;
        this.paramCount = parameterTypes.size();
        this.context = context;
        this.makeAccessible = makeAccessible;
    }

    public LookupDeclaredMethodValue(Value<Class<?>> target, String methodName, int paramCount, AccessControlContext context, boolean makeAccessible) {
        if (target == null) {
            throw new IllegalArgumentException("target is null");
        }
        if (methodName == null) {
            throw new IllegalArgumentException("methodName is null");
        }
        if (context == null) {
            throw new IllegalArgumentException("context is null");
        }
        this.target = target;
        this.methodName = methodName;
        this.parameterTypes = null;
        this.paramCount = paramCount;
        this.context = context;
        this.makeAccessible = makeAccessible;
    }

    @Override
    public Method getValue() throws IllegalStateException {
        Class[] types;
        Class[] classArray = types = this.parameterTypes == null ? null : new Class[this.parameterTypes.size()];
        if (types != null) {
            int i = 0;
            for (Value<Class<?>> type : this.parameterTypes) {
                types[i++] = type.getValue();
            }
        }
        final Class<?> targetClass = this.target.getValue();
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<Method>(){

                @Override
                public Method run() {
                    return LookupDeclaredMethodValue.this.getMethod(targetClass, types);
                }
            }, this.context);
        }
        return this.getMethod(targetClass, types);
    }

    private Method getMethod(Class<?> targetClass, Class<?>[] types) {
        Method method = null;
        if (types != null) {
            try {
                method = targetClass.getDeclaredMethod(this.methodName, types);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException(ErrorMessage.noSuchMethod(targetClass, this.methodName, this.parameterTypes));
            }
        } else {
            int paramCount = this.paramCount;
            for (Method declaredMethod : targetClass.getDeclaredMethods()) {
                if (!declaredMethod.getName().equals(this.methodName) || declaredMethod.getParameterTypes().length != paramCount) continue;
                method = declaredMethod;
                break;
            }
            if (method == null) {
                throw new IllegalStateException("No such method '" + this.methodName + "' found on " + targetClass);
            }
        }
        if (this.makeAccessible) {
            method.setAccessible(true);
        }
        return method;
    }
}

