/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.io.PrintStream;
import java.util.concurrent.TimeUnit;
import org.jboss.msc.service.ServiceContainerImpl;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;

public interface ServiceContainer
extends ServiceTarget,
ServiceRegistry {
    public void shutdown();

    public boolean isShutdownComplete();

    public void addTerminateListener(TerminateListener var1);

    public void awaitTermination() throws InterruptedException;

    public void awaitTermination(long var1, TimeUnit var3) throws InterruptedException;

    public void dumpServices();

    public void dumpServices(PrintStream var1);

    public String getName();

    public static interface TerminateListener {
        public void handleTermination(Info var1);

        public static final class Info {
            private final long shutdownInitiated;
            private final long shutdownCompleted;

            Info(long shutdownInitiated, long shutdownCompleted) {
                this.shutdownInitiated = shutdownInitiated;
                this.shutdownCompleted = shutdownCompleted;
            }

            public long getShutdownInitiated() {
                return this.shutdownInitiated;
            }

            public long getShutdownCompleted() {
                return this.shutdownCompleted;
            }
        }
    }

    public static class Factory {
        private Factory() {
        }

        public static ServiceContainer create() {
            int cpuCount = Runtime.getRuntime().availableProcessors();
            int coreSize = Math.max(cpuCount << 1, 2);
            return new ServiceContainerImpl(null, coreSize, 30L, TimeUnit.SECONDS, true);
        }

        public static ServiceContainer create(String name) {
            int cpuCount = Runtime.getRuntime().availableProcessors();
            int coreSize = Math.max(cpuCount << 1, 2);
            return new ServiceContainerImpl(name, coreSize, 30L, TimeUnit.SECONDS, true);
        }

        public static ServiceContainer create(int coreSize, long keepAliveTime, TimeUnit keepAliveTimeUnit) {
            return new ServiceContainerImpl(null, coreSize, keepAliveTime, keepAliveTimeUnit, true);
        }

        public static ServiceContainer create(String name, int coreSize, long keepAliveTime, TimeUnit keepAliveTimeUnit) {
            return new ServiceContainerImpl(name, coreSize, keepAliveTime, keepAliveTimeUnit, true);
        }

        public static ServiceContainer create(boolean autoShutdown) {
            int cpuCount = Runtime.getRuntime().availableProcessors();
            int coreSize = Math.max(cpuCount << 1, 2);
            return new ServiceContainerImpl(null, coreSize, 30L, TimeUnit.SECONDS, autoShutdown);
        }

        public static ServiceContainer create(String name, boolean autoShutdown) {
            int cpuCount = Runtime.getRuntime().availableProcessors();
            int coreSize = Math.max(cpuCount << 1, 2);
            return new ServiceContainerImpl(name, coreSize, 30L, TimeUnit.SECONDS, autoShutdown);
        }

        public static ServiceContainer create(int coreSize, long keepAliveTime, TimeUnit keepAliveTimeUnit, boolean autoShutdown) {
            return new ServiceContainerImpl(null, coreSize, keepAliveTime, keepAliveTimeUnit, autoShutdown);
        }

        public static ServiceContainer create(String name, int coreSize, long keepAliveTime, TimeUnit keepAliveTimeUnit, boolean autoShutdown) {
            return new ServiceContainerImpl(name, coreSize, keepAliveTime, keepAliveTimeUnit, autoShutdown);
        }
    }
}

