/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;

public final class TimingServiceListener
extends AbstractServiceListener<Object>
implements ServiceListener<Object> {
    private volatile int finished = 0;
    private volatile int count = 1;
    private volatile int totalServices = 0;
    private final long start = System.currentTimeMillis();
    private volatile long end;
    private final Runnable finishedTask;
    private static final AtomicIntegerFieldUpdater<TimingServiceListener> finishedUpdater = AtomicIntegerFieldUpdater.newUpdater(TimingServiceListener.class, "finished");
    private static final AtomicIntegerFieldUpdater<TimingServiceListener> countUpdater = AtomicIntegerFieldUpdater.newUpdater(TimingServiceListener.class, "count");
    private static final AtomicIntegerFieldUpdater<TimingServiceListener> totalServicesUpdater = AtomicIntegerFieldUpdater.newUpdater(TimingServiceListener.class, "totalServices");

    public TimingServiceListener() {
        this.finishedTask = null;
    }

    public TimingServiceListener(Runnable finishedTask) {
        this.finishedTask = finishedTask;
    }

    @Override
    public void listenerAdded(ServiceController<? extends Object> serviceController) {
        countUpdater.incrementAndGet(this);
        totalServicesUpdater.incrementAndGet(this);
    }

    @Override
    public void transition(ServiceController<? extends Object> controller, ServiceController.Transition transition) {
        switch (transition) {
            case STARTING_to_PROCESSING_CHILD_SERVICES: 
            case STARTING_to_START_FAILED: {
                if (countUpdater.decrementAndGet(this) == 0) {
                    this.done();
                }
                controller.removeListener(this);
            }
        }
    }

    private void done() {
        this.end = System.currentTimeMillis();
        if (this.finishedTask != null) {
            this.finishedTask.run();
        }
    }

    public void finishBatch() {
        if (finishedUpdater.getAndSet(this, 1) == 0 && countUpdater.decrementAndGet(this) == 0) {
            this.done();
        }
    }

    public boolean finished() {
        return this.finished != 0;
    }

    public int getRemainingCount() {
        return this.count;
    }

    public int getTotalCount() {
        return this.totalServices;
    }

    public long getElapsedTime() {
        long end = this.end;
        if (end == 0L) {
            return -1L;
        }
        return end - this.start;
    }
}

