/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

final class ContainerShutdownListener {
    private volatile int count = 1;
    private volatile int done;
    private static final AtomicIntegerFieldUpdater<ContainerShutdownListener> countUpdater = AtomicIntegerFieldUpdater.newUpdater(ContainerShutdownListener.class, "count");
    private static final AtomicIntegerFieldUpdater<ContainerShutdownListener> doneUpdater = AtomicIntegerFieldUpdater.newUpdater(ContainerShutdownListener.class, "done");
    private final Runnable callback;

    ContainerShutdownListener(Runnable callback) {
        this.callback = callback;
    }

    final void controllerAlive() {
        countUpdater.getAndIncrement(this);
    }

    final void controllerDied() {
        this.tick();
    }

    final void done() {
        if (doneUpdater.getAndSet(this, 1) == 0) {
            this.tick();
        }
    }

    private void tick() {
        if (countUpdater.decrementAndGet(this) == 0) {
            this.callback.run();
        }
    }
}

