/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.io.PrintStream;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jboss.msc.service.SecurityUtils;
import org.jboss.msc.service.ServiceContainerImpl;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.common.cpu.ProcessorInfo;

public interface ServiceContainer
extends ServiceTarget,
ServiceRegistry {
    public void shutdown();

    public boolean isShutdown();

    public boolean isShutdownComplete();

    public void addTerminateListener(TerminateListener var1);

    public void awaitTermination() throws InterruptedException;

    public void awaitTermination(long var1, TimeUnit var3) throws InterruptedException;

    public void awaitStability() throws InterruptedException;

    public boolean awaitStability(long var1, TimeUnit var3) throws InterruptedException;

    public void awaitStability(Set<? super ServiceController<?>> var1, Set<? super ServiceController<?>> var2) throws InterruptedException;

    public boolean awaitStability(long var1, TimeUnit var3, Set<? super ServiceController<?>> var4, Set<? super ServiceController<?>> var5) throws InterruptedException;

    public void dumpServices();

    public void dumpServices(PrintStream var1);

    public String getName();

    public static interface TerminateListener {
        public void handleTermination(Info var1);

        public static final class Info {
            private final long shutdownInitiated;
            private final long shutdownCompleted;

            Info(long shutdownInitiated, long shutdownCompleted) {
                this.shutdownInitiated = shutdownInitiated;
                this.shutdownCompleted = shutdownCompleted;
            }

            public long getShutdownInitiated() {
                return this.shutdownInitiated;
            }

            public long getShutdownCompleted() {
                return this.shutdownCompleted;
            }
        }
    }

    public static class Factory {
        private static final int CORE_THREADS_COUNT = Math.max(1, SecurityUtils.getSystemProperty("jboss.msc.core.container.threads", Math.max(ProcessorInfo.availableProcessors() << 1, 2)));
        private static final int MAX_THREADS_COUNT = Math.max(CORE_THREADS_COUNT, SecurityUtils.getSystemProperty("jboss.msc.max.container.threads", CORE_THREADS_COUNT << 3));

        private Factory() {
        }

        public static ServiceContainer create() {
            return new ServiceContainerImpl(null, CORE_THREADS_COUNT, MAX_THREADS_COUNT, 30L, TimeUnit.SECONDS, true);
        }

        public static ServiceContainer create(String name) {
            return new ServiceContainerImpl(name, CORE_THREADS_COUNT, MAX_THREADS_COUNT, 30L, TimeUnit.SECONDS, true);
        }

        public static ServiceContainer create(int poolSize, long keepAliveTime, TimeUnit keepAliveTimeUnit) {
            return Factory.create(null, poolSize, poolSize, keepAliveTime, keepAliveTimeUnit, true);
        }

        public static ServiceContainer create(String name, int poolSize, long keepAliveTime, TimeUnit keepAliveTimeUnit) {
            return Factory.create(name, poolSize, poolSize, keepAliveTime, keepAliveTimeUnit, true);
        }

        public static ServiceContainer create(String name, int coreSize, int maxSize, long keepAliveTime, TimeUnit keepAliveTimeUnit) {
            return Factory.create(name, coreSize, maxSize, keepAliveTime, keepAliveTimeUnit, true);
        }

        public static ServiceContainer create(boolean autoShutdown) {
            return Factory.create(null, CORE_THREADS_COUNT, MAX_THREADS_COUNT, 30L, TimeUnit.SECONDS, autoShutdown);
        }

        public static ServiceContainer create(String name, boolean autoShutdown) {
            return Factory.create(name, CORE_THREADS_COUNT, MAX_THREADS_COUNT, 30L, TimeUnit.SECONDS, autoShutdown);
        }

        public static ServiceContainer create(int poolSize, long keepAliveTime, TimeUnit keepAliveTimeUnit, boolean autoShutdown) {
            return Factory.create(null, poolSize, poolSize, keepAliveTime, keepAliveTimeUnit, autoShutdown);
        }

        public static ServiceContainer create(String name, int poolSize, long keepAliveTime, TimeUnit keepAliveTimeUnit, boolean autoShutdown) {
            return Factory.create(name, poolSize, poolSize, keepAliveTime, keepAliveTimeUnit, autoShutdown);
        }

        public static ServiceContainer create(String name, int coreSize, int maxSize, long keepAliveTime, TimeUnit keepAliveTimeUnit, boolean autoShutdown) {
            ServiceContainerImpl container = new ServiceContainerImpl(name, coreSize, maxSize, keepAliveTime, keepAliveTimeUnit, autoShutdown);
            container.registerShutdownCleaner();
            container.registerMBeanCleaner();
            return container;
        }

        private static int calculateCoreSize() {
            int cpuCount = Runtime.getRuntime().availableProcessors();
            return Factory.calculateCoreSize(Math.max(cpuCount << 1, 2));
        }

        private static int calculateCoreSize(int coreSize) {
            return Math.min(coreSize, MAX_THREADS_COUNT);
        }
    }
}

