/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.msc.service.LifecycleListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.Value;

public interface ServiceController<S>
extends Value<S> {
    public ServiceController<?> getParent();

    public ServiceContainer getServiceContainer();

    public Mode getMode();

    public boolean compareAndSetMode(Mode var1, Mode var2);

    public void setMode(Mode var1);

    public State getState();

    @Override
    @Deprecated
    public S getValue() throws IllegalStateException;

    @Deprecated
    public S awaitValue() throws IllegalStateException, InterruptedException;

    @Deprecated
    public S awaitValue(long var1, TimeUnit var3) throws IllegalStateException, InterruptedException, TimeoutException;

    @Deprecated
    public Service<S> getService() throws IllegalStateException;

    public ServiceName getName();

    public ServiceName[] getAliases();

    public void addListener(LifecycleListener var1);

    public void removeListener(LifecycleListener var1);

    public StartException getStartException();

    public void retry();

    public Collection<ServiceName> getUnavailableDependencies();

    public static enum Mode {
        REMOVE,
        NEVER,
        ON_DEMAND,
        LAZY,
        PASSIVE,
        ACTIVE;


        public boolean in(Mode ... modes) {
            for (Mode test : modes) {
                if (this != test) continue;
                return true;
            }
            return false;
        }
    }

    public static enum State {
        DOWN,
        STARTING,
        START_FAILED,
        UP,
        STOPPING,
        REMOVED;


        public boolean in(State ... states) {
            for (State test : states) {
                if (this != test) continue;
                return true;
            }
            return false;
        }
    }
}

