/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster;

import org.apache.catalina.Container;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.jboss.modcluster.JBossWebEventHandler;

public class BasicClusterListener
implements LifecycleListener,
ContainerListener {
    private volatile boolean init = false;
    private JBossWebEventHandler eventHandler;

    public BasicClusterListener(JBossWebEventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    public void containerEvent(ContainerEvent event) {
        Container container = event.getContainer();
        Object child = event.getData();
        String type = event.getType();
        if (type.equals("addChild")) {
            if (container instanceof Host) {
                ((Lifecycle)child).addLifecycleListener((LifecycleListener)this);
                this.eventHandler.addContext((Context)child);
            } else if (container instanceof Engine) {
                container.addContainerListener((ContainerListener)this);
            }
        } else if (type.equals("removeChild")) {
            if (container instanceof Host) {
                ((Lifecycle)child).removeLifecycleListener((LifecycleListener)this);
                this.eventHandler.removeContext((Context)child);
            } else if (container instanceof Engine) {
                container.removeContainerListener((ContainerListener)this);
            }
        }
    }

    public void lifecycleEvent(LifecycleEvent event) {
        Lifecycle source = event.getLifecycle();
        String type = event.getType();
        if (type.equals("start")) {
            if (source instanceof Context) {
                this.eventHandler.startContext((Context)source);
            }
        } else if (type.equals("after_start")) {
            if (source instanceof Server) {
                this.eventHandler.init();
                Server server = (Server)source;
                this.addListeners(server);
                this.eventHandler.startServer(server);
                this.init = true;
            }
        } else if (type.equals("stop")) {
            if (source instanceof Context) {
                this.eventHandler.stopContext((Context)source);
            } else if (source instanceof Server) {
                this.init = false;
                Server server = (Server)source;
                this.removeListeners(server);
                this.eventHandler.stopServer(server);
                this.eventHandler.shutdown();
            }
        } else if (type.equals("periodic") && this.init && source instanceof Engine) {
            this.eventHandler.status((Engine)source);
        }
    }

    private void addListeners(Server server) {
        Service[] services;
        for (Service service : services = server.findServices()) {
            Container[] containers;
            Engine engine = (Engine)service.getContainer();
            engine.addContainerListener((ContainerListener)this);
            ((Lifecycle)engine).addLifecycleListener((LifecycleListener)this);
            for (Container container : containers = engine.findChildren()) {
                Container[] childContainers;
                container.addContainerListener((ContainerListener)this);
                for (Container childContainer : childContainers = container.findChildren()) {
                    ((Lifecycle)childContainer).addLifecycleListener((LifecycleListener)this);
                }
            }
        }
    }

    private void removeListeners(Server server) {
        Service[] services;
        for (Service service : services = server.findServices()) {
            Container[] containers;
            Engine engine = (Engine)service.getContainer();
            engine.removeContainerListener((ContainerListener)this);
            ((Lifecycle)engine).removeLifecycleListener((LifecycleListener)this);
            for (Container container : containers = engine.findChildren()) {
                Container[] childContainers;
                container.removeContainerListener((ContainerListener)this);
                for (Container childContainer : childContainers = container.findChildren()) {
                    ((Lifecycle)childContainer).removeLifecycleListener((LifecycleListener)this);
                }
            }
        }
    }
}

