/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Engine;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.catalina.ServerFactory;
import org.apache.catalina.Service;
import org.apache.catalina.util.StringManager;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.modeler.Registry;
import org.jboss.logging.Logger;
import org.jboss.modcluster.BasicClusterListener;
import org.jboss.modcluster.Constants;
import org.jboss.modcluster.DefaultJBossWebEventHandler;
import org.jboss.modcluster.config.ModClusterConfig;
import org.jboss.modcluster.load.LoadBalanceFactorProvider;
import org.jboss.modcluster.mcmp.MCMPHandler;
import org.jboss.modcluster.mcmp.MCMPRequest;
import org.jboss.modcluster.mcmp.MCMPUtils;
import org.jboss.modcluster.mcmp.impl.DefaultMCMPHandler;
import org.jboss.modcluster.mcmp.impl.ResetRequestSourceImpl;

public class ClusterListener
extends ModClusterConfig
implements LifecycleListener,
ContainerListener {
    private static final Logger log;
    private final StringManager sm = StringManager.getManager((String)Constants.Package);
    private final LifecycleListener lifecycleListener;
    private final ContainerListener containerListener;
    private final MCMPHandler mcmpHandler;

    public ClusterListener() {
        this(null);
    }

    public ClusterListener(LoadBalanceFactorProvider loadBalanceFactorProvider) {
        this.mcmpHandler = new DefaultMCMPHandler(this, new ResetRequestSourceImpl(this, this));
        DefaultJBossWebEventHandler eventHandler = new DefaultJBossWebEventHandler(this, this, this, this.mcmpHandler, loadBalanceFactorProvider != null ? loadBalanceFactorProvider : this);
        BasicClusterListener listener = new BasicClusterListener(eventHandler);
        this.lifecycleListener = listener;
        this.containerListener = listener;
    }

    protected ClusterListener(MCMPHandler mcmpHandler, LifecycleListener lifecycleListener, ContainerListener containerListener) {
        this.mcmpHandler = mcmpHandler;
        this.lifecycleListener = lifecycleListener;
        this.containerListener = containerListener;
    }

    public String getProxyConfiguration() {
        return this.mcmpHandler.getProxyConfiguration();
    }

    public String getProxyInfo() {
        return this.mcmpHandler.getProxyInfo();
    }

    public void reset() {
        this.mcmpHandler.reset();
    }

    public void refresh() {
        this.mcmpHandler.markProxiesInError();
    }

    public boolean disable() {
        Service[] services;
        for (Service service : services = ServerFactory.getServer().findServices()) {
            Engine engine = (Engine)service.getContainer();
            MCMPRequest request = MCMPUtils.createDisableEngineRequest(engine);
            this.mcmpHandler.sendRequest(request);
        }
        return this.mcmpHandler.isProxyHealthOK();
    }

    public boolean enable() {
        Service[] services;
        for (Service service : services = ServerFactory.getServer().findServices()) {
            Engine engine = (Engine)service.getContainer();
            MCMPRequest request = MCMPUtils.createEnableEngineRequest(engine);
            this.mcmpHandler.sendRequest(request);
        }
        return this.mcmpHandler.isProxyHealthOK();
    }

    public void containerEvent(ContainerEvent event) {
        this.containerListener.containerEvent(event);
    }

    public void lifecycleEvent(LifecycleEvent event) {
        this.lifecycleListener.lifecycleEvent(event);
        Lifecycle source = event.getLifecycle();
        if (source instanceof Server) {
            Server server = (Server)source;
            if ("after_start".equals(event.getType())) {
                try {
                    ObjectName name = this.getObjectName(server);
                    Registry.getRegistry(null, null).registerComponent((Object)this, name, null);
                }
                catch (Exception e) {
                    log.error((Object)this.sm.getString("modcluster.error.jmxRregister"), (Throwable)e);
                }
            } else if ("stop".equals(event.getType())) {
                try {
                    ObjectName name = this.getObjectName(server);
                    Registry.getRegistry(null, null).unregisterComponent(name);
                }
                catch (Exception e) {
                    log.error((Object)this.sm.getString("modcluster.error.jmxUnregister"), (Throwable)e);
                }
            }
        }
    }

    private ObjectName getObjectName(Server server) throws MalformedObjectNameException {
        String domain = (String)IntrospectionUtils.getProperty((Object)server, (String)"domain");
        return ObjectName.getInstance(domain, "type", "ClusterListener");
    }

    static {
        if (Logger.getPluginClassName() == null) {
            String pluginClass = "org.jboss.logging.jdk.JDK14LoggerPlugin";
            try {
                ClusterListener.class.getClassLoader().loadClass(pluginClass);
                Logger.setPluginClassName((String)pluginClass);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        log = Logger.getLogger(ClusterListener.class);
    }
}

