/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.advertise.impl;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.catalina.util.StringManager;
import org.jboss.logging.Logger;
import org.jboss.modcluster.Constants;
import org.jboss.modcluster.advertise.AdvertiseListener;
import org.jboss.modcluster.advertise.MulticastSocketFactory;
import org.jboss.modcluster.advertise.impl.AdvertisedServer;
import org.jboss.modcluster.config.MCMPHandlerConfiguration;
import org.jboss.modcluster.mcmp.MCMPHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdvertiseListenerImpl
implements AdvertiseListener {
    public static final int DEFAULT_PORT = 23364;
    public static final String DEFAULT_GROUP = "224.0.1.105";
    public static final String DEFAULT_ENCODING = "8859_1";
    private static final Logger log = Logger.getLogger(AdvertiseListenerImpl.class);
    private static final String RFC_822_FMT = "EEE, d MMM yyyy HH:mm:ss Z";
    private int advertisePort = 23364;
    private InetAddress groupAddress = null;
    private MulticastSocketFactory socketFactory;
    MulticastSocket socket;
    private boolean initialized = false;
    volatile boolean listening = true;
    final AtomicBoolean running = new AtomicBoolean(false);
    final AtomicBoolean paused = new AtomicBoolean(false);
    private boolean daemon = true;
    private final byte[] secure = new byte[16];
    private String securityKey = null;
    MessageDigest md = null;
    final Map<String, AdvertisedServer> servers = new HashMap<String, AdvertisedServer>();
    final MCMPHandler commHandler;
    private Thread workerThread;
    private StringManager sm = StringManager.getManager((String)Constants.Package);

    private static void digestString(MessageDigest md, String s) {
        int len = s.length();
        byte[] b = new byte[len];
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            b[i] = c < '\u007f' ? (int)c : 63;
        }
        md.update(b);
    }

    public AdvertiseListenerImpl(MCMPHandler commHandler, MCMPHandlerConfiguration config, MulticastSocketFactory socketFactory) {
        this.commHandler = commHandler;
        this.socketFactory = socketFactory;
        try {
            this.setGroupAddress(config.getAdvertiseGroupAddress());
            this.setAdvertisePort(config.getAdvertisePort());
            this.setSecurityKey(config.getAdvertiseSecurityKey());
        }
        catch (IOException e) {
            log.error((Object)this.sm.getString("modcluster.error.startListener"), (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)this.sm.getString("modcluster.error.startListener"), (Throwable)e);
        }
    }

    public void setDaemon(boolean b) {
        this.daemon = b;
    }

    public boolean getDaemon() {
        return this.daemon;
    }

    public void setSecurityKey(String key) throws NoSuchAlgorithmException {
        this.securityKey = key;
        if (this.md == null) {
            this.md = MessageDigest.getInstance("MD5");
        }
    }

    public void setAdvertisePort(int port) {
        this.advertisePort = port > 0 ? port : 23364;
    }

    public int getAdvertisePort() {
        return this.advertisePort;
    }

    public void setGroupAddress(String address) throws UnknownHostException {
        this.groupAddress = InetAddress.getByName(address != null ? address : DEFAULT_GROUP);
    }

    public String getGroupAddress() {
        return this.groupAddress.getHostAddress();
    }

    public Collection<AdvertisedServer> getServers() {
        return this.servers.values();
    }

    public AdvertisedServer getServer(String name) {
        return this.servers.get(name);
    }

    public void removeServer(AdvertisedServer server) {
        this.servers.values().remove(server);
    }

    private synchronized void init() throws IOException {
        if (!this.initialized) {
            this.socket = this.socketFactory.createMulticastSocket(this.groupAddress, this.advertisePort);
            this.socket.setTimeToLive(16);
            this.socket.joinGroup(this.groupAddress);
            this.initialized = true;
        }
    }

    private void interruptDatagramReader() {
        if (!this.initialized) {
            return;
        }
        try {
            this.socket.setTimeToLive(0);
            DatagramPacket dp = new DatagramPacket(this.secure, this.secure.length, this.groupAddress, this.advertisePort);
            this.socket.send(dp);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void start() throws IOException {
        this.init();
        if (!this.running.compareAndSet(false, true)) return;
        SecureRandom random = new SecureRandom();
        byte[] byArray = this.secure;
        synchronized (this.secure) {
            random.nextBytes(this.secure);
            this.secure[0] = 0;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.paused.set(false);
            this.listening = true;
            AdvertiseListenerWorker aw = new AdvertiseListenerWorker();
            this.workerThread = new Thread(aw);
            this.workerThread.setDaemon(this.daemon);
            this.workerThread.start();
            return;
        }
    }

    @Override
    public void pause() {
        if (this.running.get() && this.paused.compareAndSet(false, true)) {
            this.interruptDatagramReader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void resume() {
        if (!this.running.get() || !this.paused.compareAndSet(true, false)) return;
        SecureRandom random = new SecureRandom();
        byte[] byArray = this.secure;
        synchronized (this.secure) {
            random.nextBytes(this.secure);
            this.secure[0] = 0;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void stop() {
        if (this.running.compareAndSet(true, false)) {
            this.interruptDatagramReader();
            this.workerThread = null;
        }
    }

    @Override
    public void destroy() throws IOException {
        this.stop();
        if (this.initialized) {
            this.socket.leaveGroup(this.groupAddress);
            this.socket.close();
            this.initialized = false;
            this.socket = null;
        }
    }

    boolean verifyDigest(String digest, String server, String date) {
        if (this.md == null) {
            return true;
        }
        if (this.securityKey == null) {
            return true;
        }
        this.md.reset();
        AdvertiseListenerImpl.digestString(this.md, this.securityKey);
        AdvertiseListenerImpl.digestString(this.md, date);
        AdvertiseListenerImpl.digestString(this.md, server);
        byte[] dst = new byte[digest.length() * 2];
        int j = 0;
        for (int i = 0; i < digest.length(); ++i) {
            char ch = digest.charAt(i);
            dst[j++] = (byte)(ch >= 'A' ? (ch & 0xDF) - 65 + 10 : ch - 48);
        }
        return true;
    }

    public boolean isListening() {
        return this.listening;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean matchesSecure(DatagramPacket dp) {
        byte[] data = dp.getData();
        byte[] byArray = this.secure;
        synchronized (this.secure) {
            if (dp.getLength() != this.secure.length) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return false;
            }
            for (int i = 0; i < this.secure.length; ++i) {
                if (data[i] == this.secure[i]) continue;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return false;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return true;
        }
    }

    class AdvertiseListenerWorker
    implements Runnable {
        private DateFormat df = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", Locale.US);

        AdvertiseListenerWorker() {
        }

        public void run() {
            byte[] buffer = new byte[512];
            while (AdvertiseListenerImpl.this.running.get()) {
                while (AdvertiseListenerImpl.this.paused.get()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                try {
                    byte[] data;
                    String s;
                    DatagramPacket dp = new DatagramPacket(buffer, buffer.length);
                    AdvertiseListenerImpl.this.socket.receive(dp);
                    if (!AdvertiseListenerImpl.this.running.get()) break;
                    if (AdvertiseListenerImpl.this.matchesSecure(dp) || !(s = new String(data = dp.getData(), 0, dp.getLength(), AdvertiseListenerImpl.DEFAULT_ENCODING)).startsWith("HTTP/1.")) continue;
                    String[] headers = s.split("\r\n");
                    String date_str = null;
                    Date date = null;
                    int status = 0;
                    String status_desc = null;
                    String digest = null;
                    String server_name = null;
                    AdvertisedServer server = null;
                    boolean added = false;
                    for (int i = 0; i < headers.length; ++i) {
                        if (i == 0) {
                            String[] sline = headers[i].split(" ", 3);
                            if (sline == null || sline.length != 3 || (status = Integer.parseInt(sline[1])) < 100) break;
                            status_desc = sline[2];
                            continue;
                        }
                        String[] hdrv = headers[i].split(": ", 2);
                        if (hdrv == null || hdrv.length != 2) break;
                        if (hdrv[0].equals("Date")) {
                            date_str = hdrv[1];
                            try {
                                date = this.df.parse(date_str);
                            }
                            catch (ParseException e) {
                                date = new Date();
                            }
                            continue;
                        }
                        if (hdrv[0].equals("Digest")) {
                            digest = hdrv[1];
                            continue;
                        }
                        if (hdrv[0].equals("Server")) {
                            server_name = hdrv[1];
                            server = AdvertiseListenerImpl.this.servers.get(server_name);
                            if (server != null) continue;
                            server = new AdvertisedServer(server_name);
                            added = true;
                            continue;
                        }
                        if (server == null) continue;
                        server.setParameter(hdrv[0], hdrv[1]);
                    }
                    if (server != null && status > 0) {
                        if (!AdvertiseListenerImpl.this.verifyDigest(digest, server_name, date_str)) continue;
                        server.setDate(date);
                        boolean rc = server.setStatus(status, status_desc);
                        if (added) {
                            AdvertiseListenerImpl.this.servers.put(server_name, server);
                            String proxy = server.getParameter(AdvertisedServer.MANAGER_ADDRESS);
                            if (proxy != null) {
                                AdvertiseListenerImpl.this.commHandler.addProxy(proxy);
                            }
                        } else if (rc) {
                            // empty if block
                        }
                    }
                    AdvertiseListenerImpl.this.listening = true;
                }
                catch (IOException e) {
                    AdvertiseListenerImpl.this.listening = false;
                    Thread.yield();
                }
            }
        }
    }
}

