/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.mcmp;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.jboss.modcluster.mcmp.AddressPort;
import org.jboss.modcluster.mcmp.MCMPHandler;
import org.jboss.modcluster.mcmp.MCMPUtils;

public abstract class AbstractMCMPHandler
implements MCMPHandler {
    public void addProxy(String address) {
        AddressPort ap = MCMPUtils.parseAddressPort(address);
        this.addProxy(ap.getAddress(), ap.getPort());
    }

    public void addProxy(String host, int port) {
        try {
            InetAddress address = InetAddress.getByName(host);
            this.addProxy(address, port);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void removeProxy(String host, int port) {
        try {
            InetAddress address = InetAddress.getByName(host);
            this.removeProxy(address, port);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

