/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.mcmp;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Globals;
import org.apache.catalina.Host;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.util.StringManager;
import org.apache.coyote.ProtocolHandler;
import org.apache.tomcat.util.IntrospectionUtils;
import org.jboss.logging.Logger;
import org.jboss.modcluster.Constants;
import org.jboss.modcluster.Utils;
import org.jboss.modcluster.config.BalancerConfiguration;
import org.jboss.modcluster.config.NodeConfiguration;
import org.jboss.modcluster.mcmp.AddressPort;
import org.jboss.modcluster.mcmp.MCMPRequest;
import org.jboss.modcluster.mcmp.MCMPRequestType;
import org.jboss.modcluster.mcmp.ResetRequestSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MCMPUtils {
    public static final int DEFAULT_PORT = 8000;
    private static final Map<String, String> EMPTY_MAP = Collections.emptyMap();
    public static final MCMPRequest INFO_REQUEST = new MCMPRequest(MCMPRequestType.INFO, false, null, EMPTY_MAP);
    public static final MCMPRequest DUMP_REQUEST = new MCMPRequest(MCMPRequestType.DUMP, true, null, EMPTY_MAP);
    private static final Logger log = Logger.getLogger(MCMPUtils.class);
    private static final StringManager sm = StringManager.getManager((String)Constants.Package);

    public static MCMPRequest createConfigRequest(Engine engine, NodeConfiguration nodeConfig, BalancerConfiguration balancerConfig) {
        return MCMPUtils.createConfigRequest(engine.getJvmRoute(), engine.getService().findConnectors(), nodeConfig, balancerConfig);
    }

    public static MCMPRequest createConfigRequest(String jvmRoute, Connector[] connectors, NodeConfiguration nodeConfig, BalancerConfiguration balancerConfig) {
        int maxAttempts;
        int workerTimeout;
        String balancer;
        int nodeTimeout;
        int ttl;
        int smax;
        int ping;
        int flushWait;
        Connector connector = Utils.findProxyConnector(connectors);
        HashMap<String, String> parameters = new HashMap<String, String>();
        ProtocolHandler handler = connector.getProtocolHandler();
        boolean reverseConnection = Boolean.TRUE.equals(IntrospectionUtils.getProperty((Object)handler, (String)"reverseConnection"));
        boolean ssl = Boolean.TRUE.equals(IntrospectionUtils.getProperty((Object)handler, (String)"SSLEnabled"));
        boolean ajp = ((String)IntrospectionUtils.getProperty((Object)handler, (String)"name")).startsWith("ajp-");
        if (reverseConnection) {
            parameters.put("Reversed", "true");
        }
        parameters.put("Host", Utils.getAddress(connector));
        parameters.put("Port", "" + connector.getPort());
        if (ajp) {
            parameters.put("Type", "ajp");
        } else if (ssl) {
            parameters.put("Type", "https");
        } else {
            parameters.put("Type", "http");
        }
        String domain = nodeConfig.getDomain();
        if (domain != null) {
            parameters.put("Domain", domain);
        }
        if (nodeConfig.getFlushPackets()) {
            parameters.put("flushpackets", "On");
        }
        if ((flushWait = nodeConfig.getFlushWait()) != -1) {
            parameters.put("flushwait", String.valueOf(flushWait));
        }
        if ((ping = nodeConfig.getPing()) != -1) {
            parameters.put("ping", String.valueOf(ping));
        }
        if ((smax = nodeConfig.getSmax()) != -1) {
            parameters.put("smax", String.valueOf(smax));
        }
        if ((ttl = nodeConfig.getTtl()) != -1) {
            parameters.put("ttl", String.valueOf(ttl));
        }
        if ((nodeTimeout = nodeConfig.getNodeTimeout()) != -1) {
            parameters.put("Timeout", String.valueOf(nodeTimeout));
        }
        if ((balancer = nodeConfig.getBalancer()) != null) {
            parameters.put("Balancer", balancer);
        }
        if (!balancerConfig.getStickySession()) {
            parameters.put("StickySession", "No");
        }
        if (!Globals.SESSION_COOKIE_NAME.equals("JSESSIONID")) {
            parameters.put("StickySessionCookie", Globals.SESSION_COOKIE_NAME);
        }
        if (!Globals.SESSION_PARAMETER_NAME.equals("jsessionid")) {
            parameters.put("StickySessionPath", Globals.SESSION_PARAMETER_NAME);
        }
        if (balancerConfig.getStickySessionRemove()) {
            parameters.put("StickySessionRemove", "Yes");
        }
        if (!balancerConfig.getStickySessionForce()) {
            parameters.put("StickySessionForce", "No");
        }
        if ((workerTimeout = balancerConfig.getWorkerTimeout()) != -1) {
            parameters.put("WaitWorker", "" + workerTimeout);
        }
        if ((maxAttempts = balancerConfig.getMaxAttempts()) != -1) {
            parameters.put("Maxattempts", "" + maxAttempts);
        }
        return new MCMPRequest(MCMPRequestType.CONFIG, false, jvmRoute, parameters);
    }

    public static MCMPRequest createEnableAppRequest(Context context) {
        return MCMPUtils.createRequest(MCMPRequestType.ENABLE_APP, context);
    }

    public static MCMPRequest createDisableAppRequest(Context context) {
        return MCMPUtils.createRequest(MCMPRequestType.DISABLE_APP, context);
    }

    public static MCMPRequest createStopAppRequest(Context context) {
        return MCMPUtils.createRequest(MCMPRequestType.STOP_APP, context);
    }

    public static MCMPRequest createRemoveAppRequest(Context context) {
        return MCMPUtils.createRequest(MCMPRequestType.REMOVE_APP, context);
    }

    private static MCMPRequest createRequest(MCMPRequestType type, Context context) {
        return MCMPUtils.createContextRequest(type, Utils.getJvmRoute(context), Utils.getAliases(context), context.getPath());
    }

    private static MCMPRequest createContextRequest(MCMPRequestType type, String jvmRoute, Set<String> aliases, String path) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("Context", "".equals(path) ? "/" : path);
        StringBuilder builder = new StringBuilder();
        Iterator<String> hosts = aliases.iterator();
        while (hosts.hasNext()) {
            builder.append(hosts.next());
            if (!hosts.hasNext()) continue;
            builder.append(',');
        }
        parameters.put("Alias", builder.toString());
        return new MCMPRequest(type, false, jvmRoute, parameters);
    }

    public static MCMPRequest createStatusRequest(Engine engine, int lbf) {
        return MCMPUtils.createStatusRequest(engine.getJvmRoute(), lbf);
    }

    public static MCMPRequest createStatusRequest(String jvmRoute, int lbf) {
        return new MCMPRequest(MCMPRequestType.STATUS, false, jvmRoute, Collections.singletonMap("Load", String.valueOf(lbf)));
    }

    public static MCMPRequest createEnableEngineRequest(Engine engine) {
        return MCMPUtils.createRequest(MCMPRequestType.ENABLE_APP, engine);
    }

    public static MCMPRequest createDisableEngineRequest(Engine engine) {
        return MCMPUtils.createRequest(MCMPRequestType.DISABLE_APP, engine);
    }

    public static MCMPRequest createRemoveAllRequest(Engine engine) {
        return MCMPUtils.createRequest(MCMPRequestType.REMOVE_APP, engine);
    }

    private static MCMPRequest createRequest(MCMPRequestType type, Engine engine) {
        return MCMPUtils.createEngineRequest(type, engine.getJvmRoute());
    }

    private static MCMPRequest createEngineRequest(MCMPRequestType type, String jvmRoute) {
        return new MCMPRequest(type, true, jvmRoute, EMPTY_MAP);
    }

    /*
     * WARNING - void declaration
     */
    public static List<MCMPRequest> getResetRequests(Map<String, Set<ResetRequestSource.VirtualHost>> response, Server server, NodeConfiguration nodeConfig, BalancerConfiguration balancerConfig) {
        ArrayList<MCMPRequest> requests = new ArrayList<MCMPRequest>();
        LinkedList<MCMPRequest> engineRequests = new LinkedList<MCMPRequest>();
        for (Service service : server.findServices()) {
            Engine engine = (Engine)service.getContainer();
            String jvmRoute = engine.getJvmRoute();
            engineRequests.add(MCMPUtils.createConfigRequest(jvmRoute, service.findConnectors(), nodeConfig, balancerConfig));
            Set<Object> responseHosts = Collections.emptySet();
            if (response.containsKey(jvmRoute)) {
                responseHosts = response.get(jvmRoute);
            }
            for (Container child : engine.findChildren()) {
                void var22_22;
                Host host = (Host)child;
                String hostName = host.getName();
                Set<String> aliases = Utils.getAliases(host);
                ResetRequestSource.VirtualHost responseHost = null;
                for (ResetRequestSource.VirtualHost virtualHost : responseHosts) {
                    if (!virtualHost.getAliases().contains(hostName)) continue;
                    responseHost = virtualHost;
                    break;
                }
                Set<String> responseAliases = Collections.emptySet();
                Map map = Collections.emptyMap();
                if (responseHost != null) {
                    responseAliases = responseHost.getAliases();
                    if (!((Object)aliases).equals(responseAliases)) {
                        engineRequests.add(0, MCMPUtils.createEngineRequest(MCMPRequestType.REMOVE_APP, jvmRoute));
                    } else {
                        Map<String, ResetRequestSource.Status> map2 = responseHost.getContexts();
                    }
                }
                HashSet obsoleteContexts = new HashSet(var22_22.keySet());
                for (Container container : host.findChildren()) {
                    Context context = (Context)container;
                    String path = context.getPath();
                    obsoleteContexts.remove(path);
                    ResetRequestSource.Status status = (ResetRequestSource.Status)((Object)var22_22.get(path));
                    if (Utils.isContextStarted(context)) {
                        if (status == ResetRequestSource.Status.ENABLED) continue;
                        engineRequests.add(MCMPUtils.createContextRequest(MCMPRequestType.ENABLE_APP, jvmRoute, aliases, path));
                        continue;
                    }
                    if (status != ResetRequestSource.Status.ENABLED) continue;
                    engineRequests.add(MCMPUtils.createContextRequest(MCMPRequestType.STOP_APP, jvmRoute, aliases, path));
                }
                if (obsoleteContexts.isEmpty()) continue;
                if (obsoleteContexts.size() == var22_22.size()) {
                    engineRequests.add(0, MCMPUtils.createEngineRequest(MCMPRequestType.REMOVE_APP, jvmRoute));
                    continue;
                }
                for (String context : obsoleteContexts) {
                    engineRequests.add(MCMPUtils.createContextRequest(MCMPRequestType.REMOVE_APP, jvmRoute, responseAliases, context));
                }
            }
            requests.addAll(engineRequests);
            engineRequests.clear();
        }
        return requests;
    }

    public static AddressPort parseAddressPort(String addressPort) {
        try {
            return MCMPUtils.parseAddressPort(addressPort, 0);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static List<AddressPort> parseProxies(String proxyList) {
        if (proxyList == null) {
            return Collections.emptyList();
        }
        String[] tokens = proxyList.split(",");
        ArrayList<AddressPort> proxies = new ArrayList<AddressPort>(tokens.length);
        for (String token : tokens) {
            try {
                AddressPort addressPort = MCMPUtils.parseAddressPort(token.trim(), 8000);
                proxies.add(addressPort);
            }
            catch (UnknownHostException e) {
                log.error((Object)sm.getString("modcluster.error.invalidHost", (Object)token), (Throwable)e);
            }
        }
        return proxies;
    }

    private static AddressPort parseAddressPort(String addressPort, int defaultPort) throws UnknownHostException {
        int pos = addressPort.indexOf(58);
        boolean colonExists = pos >= 0;
        String address = colonExists ? addressPort.substring(0, pos) : addressPort;
        int port = colonExists ? Integer.parseInt(addressPort.substring(pos + 1)) : defaultPort;
        InetAddress inetAddress = address != null && address.length() > 0 ? InetAddress.getByName(address) : null;
        return new AddressPort(inetAddress, port);
    }

    private MCMPUtils() {
    }
}

