/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster;

import org.apache.catalina.Engine;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.ServerFactory;
import org.apache.catalina.Service;
import org.jboss.modcluster.DefaultJBossWebEventHandler;
import org.jboss.modcluster.JBossWebEventHandlerAdapter;
import org.jboss.modcluster.ModClusterServiceMBean;
import org.jboss.modcluster.config.ModClusterConfig;
import org.jboss.modcluster.load.LoadBalanceFactorProviderFactory;
import org.jboss.modcluster.mcmp.MCMPHandler;
import org.jboss.modcluster.mcmp.MCMPRequest;
import org.jboss.modcluster.mcmp.MCMPUtils;
import org.jboss.modcluster.mcmp.impl.DefaultMCMPHandler;
import org.jboss.modcluster.mcmp.impl.ResetRequestSourceImpl;

public abstract class AbstractModClusterService
extends ModClusterConfig
implements LifecycleListener,
LoadBalanceFactorProviderFactory,
ModClusterServiceMBean {
    private final MCMPHandler mcmpHandler;
    private final LifecycleListener lifecycleListener;

    public AbstractModClusterService() {
        this.mcmpHandler = new DefaultMCMPHandler(this, new ResetRequestSourceImpl(this, this));
        DefaultJBossWebEventHandler eventHandler = new DefaultJBossWebEventHandler(this, this, this, this.mcmpHandler, this);
        this.lifecycleListener = new JBossWebEventHandlerAdapter(eventHandler);
    }

    protected AbstractModClusterService(MCMPHandler mcmpHandler, LifecycleListener lifecycleListener) {
        this.mcmpHandler = mcmpHandler;
        this.lifecycleListener = lifecycleListener;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        this.lifecycleListener.lifecycleEvent(event);
    }

    public void addProxy(String host, int port) {
        this.mcmpHandler.addProxy(host, port);
    }

    public void removeProxy(String host, int port) {
        this.mcmpHandler.removeProxy(host, port);
    }

    public String getProxyConfiguration() {
        return this.mcmpHandler.getProxyConfiguration();
    }

    public String getProxyInfo() {
        return this.mcmpHandler.getProxyInfo();
    }

    public void reset() {
        this.mcmpHandler.reset();
    }

    public void refresh() {
        this.mcmpHandler.markProxiesInError();
    }

    public boolean disable() {
        for (Service service : ServerFactory.getServer().findServices()) {
            Engine engine = (Engine)service.getContainer();
            MCMPRequest request = MCMPUtils.createDisableEngineRequest(engine);
            this.mcmpHandler.sendRequest(request);
        }
        return this.mcmpHandler.isProxyHealthOK();
    }

    public boolean enable() {
        for (Service service : ServerFactory.getServer().findServices()) {
            Engine engine = (Engine)service.getContainer();
            MCMPRequest request = MCMPUtils.createEnableEngineRequest(engine);
            this.mcmpHandler.sendRequest(request);
        }
        return this.mcmpHandler.isProxyHealthOK();
    }
}

