/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.load.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.modcluster.load.LoadBalanceFactorProvider;
import org.jboss.modcluster.load.impl.DynamicLoadBalanceFactorProviderMBean;
import org.jboss.modcluster.load.metric.LoadContext;
import org.jboss.modcluster.load.metric.LoadMetric;
import org.jboss.modcluster.load.metric.LoadMetricMBean;
import org.jboss.modcluster.load.metric.LoadMetricSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicLoadBalanceFactorProvider
implements LoadBalanceFactorProvider,
DynamicLoadBalanceFactorProviderMBean {
    public static final int DEFAULT_DECAY_FACTOR = 2;
    public static final int DEFAULT_HISTORY = 9;
    private final Logger log = Logger.getLogger(this.getClass());
    private final Map<LoadMetricSource<LoadContext>, Map<LoadMetric<LoadContext>, List<Double>>> loadHistory = new LinkedHashMap<LoadMetricSource<LoadContext>, Map<LoadMetric<LoadContext>, List<Double>>>();
    private volatile int decayFactor = 2;
    private volatile int history = 9;

    public DynamicLoadBalanceFactorProvider(Set<LoadMetric<LoadContext>> metrics) {
        for (LoadMetric<LoadContext> metric : metrics) {
            LoadMetricSource<LoadContext> source = metric.getSource();
            Map<LoadMetric<LoadContext>, List<Double>> sourceLoadHistory = this.loadHistory.get(source);
            if (sourceLoadHistory == null) {
                sourceLoadHistory = new LinkedHashMap<LoadMetric<LoadContext>, List<Double>>();
                this.loadHistory.put(source, sourceLoadHistory);
            }
            sourceLoadHistory.put(metric, new ArrayList(this.history + 1));
        }
    }

    @Override
    public Collection<LoadMetricMBean> getMetrics() {
        LinkedList<LoadMetric<LoadContext>> metrics = new LinkedList<LoadMetric<LoadContext>>();
        for (Map<LoadMetric<LoadContext>, List<Double>> sourceLoadHistory : this.loadHistory.values()) {
            for (LoadMetric<LoadContext> metric : sourceLoadHistory.keySet()) {
                metrics.add(metric);
            }
        }
        return Collections.unmodifiableCollection(metrics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int getLoadBalanceFactor() {
        int totalWeight = 0;
        double totalWeightedLoad = 0.0;
        for (Map.Entry<LoadMetricSource<LoadContext>, Map<LoadMetric<LoadContext>, List<Double>>> loadHistoryEntry : this.loadHistory.entrySet()) {
            LoadMetricSource<LoadContext> source = loadHistoryEntry.getKey();
            Map<LoadMetric<LoadContext>, List<Double>> sourceLoadHistory = loadHistoryEntry.getValue();
            boolean skip = true;
            for (LoadMetric<LoadContext> metric : sourceLoadHistory.keySet()) {
                skip = skip && metric.getWeight() <= 0;
            }
            if (skip) continue;
            LoadContext context = source.createContext();
            try {
                for (Map.Entry<LoadMetric<LoadContext>, List<Double>> entry : sourceLoadHistory.entrySet()) {
                    LoadMetric<LoadContext> metric = entry.getKey();
                    int weight = metric.getWeight();
                    if (weight <= 0) continue;
                    List<Double> metricLoadHistory = entry.getValue();
                    try {
                        this.recordLoad(metricLoadHistory, metric.getLoad(context) / metric.getCapacity());
                        totalWeight += weight;
                        totalWeightedLoad += this.average(metricLoadHistory) * (double)weight;
                    }
                    catch (Exception e) {
                        this.log.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
            finally {
                context.close();
            }
        }
        int load = (int)Math.round(100.0 * totalWeightedLoad / (double)totalWeight);
        return 100 - Math.max(0, Math.min(load, 100));
    }

    private void recordLoad(List<Double> queue, double load) {
        if (!queue.isEmpty()) {
            for (int i = queue.size() - 1; i >= this.history; --i) {
                queue.remove(i);
            }
        }
        queue.add(0, new Double(load));
    }

    private double average(List<Double> queue) {
        assert (!queue.isEmpty());
        double totalLoad = 0.0;
        double totalDecay = 0.0;
        double decayFactor = this.decayFactor;
        for (int i = 0; i < queue.size(); ++i) {
            double decay = 1.0 / Math.pow(decayFactor, i);
            totalDecay += decay;
            totalLoad += queue.get(i) * decay;
        }
        return totalLoad / totalDecay;
    }

    @Override
    public int getDecayFactor() {
        return this.decayFactor;
    }

    @Override
    public void setDecayFactor(int decayFactor) {
        this.decayFactor = Math.max(1, decayFactor);
    }

    @Override
    public int getHistory() {
        return this.history;
    }

    @Override
    public void setHistory(int history) {
        this.history = Math.max(0, history);
    }
}

