/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster;

import org.apache.catalina.Engine;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.jboss.modcluster.CatalinaEventHandler;
import org.jboss.modcluster.CatalinaEventHandlerAdapter;
import org.jboss.modcluster.ModClusterServiceMBean;
import org.jboss.modcluster.ServerProvider;
import org.jboss.modcluster.advertise.impl.AdvertiseListenerFactoryImpl;
import org.jboss.modcluster.config.ModClusterConfig;
import org.jboss.modcluster.load.LoadBalanceFactorProviderFactory;
import org.jboss.modcluster.mcmp.MCMPHandler;
import org.jboss.modcluster.mcmp.MCMPRequest;
import org.jboss.modcluster.mcmp.MCMPRequestFactory;
import org.jboss.modcluster.mcmp.impl.DefaultMCMPHandler;
import org.jboss.modcluster.mcmp.impl.DefaultMCMPRequestFactory;
import org.jboss.modcluster.mcmp.impl.ResetRequestSourceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModClusterService
extends ModClusterConfig
implements LifecycleListener,
LoadBalanceFactorProviderFactory,
ModClusterServiceMBean,
ServerProvider<Server> {
    private final MCMPHandler mcmpHandler;
    private final LifecycleListener lifecycleListener;
    private final MCMPRequestFactory requestFactory;
    private final ServerProvider<Server> serverProvider;

    public AbstractModClusterService() {
        CatalinaEventHandler eventHandler;
        this.requestFactory = new DefaultMCMPRequestFactory();
        ResetRequestSourceImpl source = new ResetRequestSourceImpl(this, this, this, this.requestFactory);
        this.mcmpHandler = new DefaultMCMPHandler(this, source, this.requestFactory);
        this.serverProvider = eventHandler = new CatalinaEventHandler(this, this, this, this.mcmpHandler, source, this.requestFactory, this, new AdvertiseListenerFactoryImpl());
        this.lifecycleListener = new CatalinaEventHandlerAdapter(eventHandler);
    }

    protected AbstractModClusterService(MCMPHandler mcmpHandler, MCMPRequestFactory requestFactory, ServerProvider<Server> serverProvider, LifecycleListener lifecycleListener) {
        this.mcmpHandler = mcmpHandler;
        this.requestFactory = requestFactory;
        this.serverProvider = serverProvider;
        this.lifecycleListener = lifecycleListener;
    }

    @Override
    public Server getServer() {
        return this.serverProvider.getServer();
    }

    public void lifecycleEvent(LifecycleEvent event) {
        this.lifecycleListener.lifecycleEvent(event);
    }

    @Override
    public void addProxy(String host, int port) {
        this.mcmpHandler.addProxy(host, port);
    }

    @Override
    public void removeProxy(String host, int port) {
        this.mcmpHandler.removeProxy(host, port);
    }

    @Override
    public String getProxyConfiguration() {
        return this.mcmpHandler.getProxyConfiguration();
    }

    @Override
    public String getProxyInfo() {
        return this.mcmpHandler.getProxyInfo();
    }

    @Override
    public void reset() {
        this.mcmpHandler.reset();
    }

    @Override
    public void refresh() {
        this.mcmpHandler.markProxiesInError();
    }

    @Override
    public boolean disable() {
        for (Service service : this.serverProvider.getServer().findServices()) {
            Engine engine = (Engine)service.getContainer();
            MCMPRequest request = this.requestFactory.createDisableRequest(engine);
            this.mcmpHandler.sendRequest(request);
        }
        return this.mcmpHandler.isProxyHealthOK();
    }

    @Override
    public boolean enable() {
        for (Service service : this.serverProvider.getServer().findServices()) {
            Engine engine = (Engine)service.getContainer();
            MCMPRequest request = this.requestFactory.createEnableRequest(engine);
            this.mcmpHandler.sendRequest(request);
        }
        return this.mcmpHandler.isProxyHealthOK();
    }
}

