/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.mcmp.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.net.SocketFactory;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.apache.catalina.util.StringManager;
import org.jboss.logging.Logger;
import org.jboss.modcluster.Constants;
import org.jboss.modcluster.Utils;
import org.jboss.modcluster.config.MCMPHandlerConfiguration;
import org.jboss.modcluster.mcmp.AbstractMCMPHandler;
import org.jboss.modcluster.mcmp.MCMPRequest;
import org.jboss.modcluster.mcmp.MCMPRequestFactory;
import org.jboss.modcluster.mcmp.MCMPServerState;
import org.jboss.modcluster.mcmp.MCMPURLEncoder;
import org.jboss.modcluster.mcmp.ResetRequestSource;
import org.jboss.modcluster.mcmp.impl.JSSESocketFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class DefaultMCMPHandler
extends AbstractMCMPHandler {
    private static final String NEW_LINE = "\r\n";
    protected static final Logger log = Logger.getLogger(DefaultMCMPHandler.class);
    protected StringManager sm = StringManager.getManager((String)Constants.Package);
    private final MCMPHandlerConfiguration config;
    private final ResetRequestSource resetRequestSource;
    private final MCMPRequestFactory requestFactory;
    private final ReadWriteLock proxiesLock = new ReentrantReadWriteLock();
    private final Lock addRemoveProxiesLock = new ReentrantLock();
    @GuardedBy(value="proxiesLock")
    private final List<Proxy> proxies = new ArrayList<Proxy>();
    @GuardedBy(value="addRemoveProxiesLock")
    private final List<Proxy> addProxies = new ArrayList<Proxy>();
    @GuardedBy(value="addRemoveProxiesLock")
    private final List<Proxy> removeProxies = new ArrayList<Proxy>();
    private volatile boolean init = false;

    public DefaultMCMPHandler(MCMPHandlerConfiguration config, ResetRequestSource source, MCMPRequestFactory requestFactory) {
        this.resetRequestSource = source;
        this.config = config;
        this.requestFactory = requestFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(List<InetSocketAddress> initialProxies) {
        Lock lock = this.proxiesLock.writeLock();
        lock.lock();
        try {
            if (initialProxies != null) {
                for (InetSocketAddress initialProxy : initialProxies) {
                    this.addProxyInternal(initialProxy.getAddress(), initialProxy.getPort());
                }
            }
            this.status(false);
        }
        finally {
            lock.unlock();
        }
        this.init = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        this.init = false;
        Lock lock = this.proxiesLock.readLock();
        lock.lock();
        try {
            for (Proxy proxy : this.proxies) {
                proxy.closeConnection();
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void addProxy(InetAddress address, int port) {
        this.addProxyInternal(address, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Proxy addProxyInternal(InetAddress address, int port) {
        Proxy proxy = new Proxy(address, port, this.config);
        this.addRemoveProxiesLock.lock();
        try {
            Lock lock = this.proxiesLock.readLock();
            lock.lock();
            try {
                Iterator<Proxy> i$ = this.proxies.iterator();
                while (true) {
                    if (i$.hasNext()) {
                        Proxy candidate = i$.next();
                        if (!candidate.equals(proxy)) continue;
                        Proxy proxy2 = candidate;
                        return proxy2;
                        continue;
                    }
                    break;
                }
            }
            finally {
                lock.unlock();
            }
            for (Proxy candidate : this.addProxies) {
                if (!candidate.equals(proxy)) continue;
                Proxy proxy3 = candidate;
                return proxy3;
            }
            for (Proxy candidate : this.removeProxies) {
                if (!candidate.equals(proxy)) continue;
                Proxy proxy4 = candidate;
                return proxy4;
            }
            proxy.setState(MCMPServerState.State.ERROR);
            this.addProxies.add(proxy);
        }
        finally {
            this.addRemoveProxiesLock.unlock();
        }
        return proxy;
    }

    @Override
    public void addProxy(InetAddress address, int port, boolean established) {
        Proxy proxy = this.addProxyInternal(address, port);
        proxy.setEstablished(established);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeProxy(InetAddress address, int port) {
        Proxy proxy = new Proxy(address, port, this.config);
        this.addRemoveProxiesLock.lock();
        try {
            this.removeProxies.add(proxy);
        }
        finally {
            this.addRemoveProxiesLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<MCMPServerState> getProxyStates() {
        Lock lock = this.proxiesLock.readLock();
        lock.lock();
        try {
            if (this.proxies.isEmpty()) {
                Set<MCMPServerState> set = Collections.emptySet();
                return set;
            }
            LinkedHashSet<MCMPServerState> result = new LinkedHashSet<MCMPServerState>(this.proxies.size());
            for (Proxy proxy : this.proxies) {
                result.add(new MCMPServerStateImpl(proxy));
            }
            LinkedHashSet<MCMPServerState> linkedHashSet = result;
            return linkedHashSet;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isProxyHealthOK() {
        Lock lock = this.proxiesLock.readLock();
        lock.lock();
        try {
            for (Proxy proxy : this.proxies) {
                if (proxy.getState() == MCMPServerState.State.OK) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markProxiesInError() {
        Lock lock = this.proxiesLock.readLock();
        lock.lock();
        try {
            for (Proxy proxy : this.proxies) {
                if (proxy.getState() != MCMPServerState.State.OK) continue;
                proxy.setState(MCMPServerState.State.ERROR);
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public String getProxyConfiguration() {
        return this.getProxyMessage(this.requestFactory.createDumpRequest());
    }

    @Override
    public String getProxyInfo() {
        return this.getProxyMessage(this.requestFactory.createInfoRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getProxyMessage(MCMPRequest request) {
        StringBuilder result = null;
        Lock lock = this.proxiesLock.readLock();
        lock.lock();
        try {
            for (int i = 0; i < this.proxies.size(); ++i) {
                Proxy proxy = this.proxies.get(i);
                String string = this.sendRequest(request, proxy);
                if (string == null) continue;
                if (result == null) {
                    result = new StringBuilder();
                }
                result.append("Proxy[").append(i).append("]: [").append(proxy.getAddress()).append(':').append(proxy.getPort()).append("]: ").append(NEW_LINE);
                result.append(string).append(NEW_LINE);
            }
        }
        finally {
            lock.unlock();
        }
        return result != null ? result.toString() : null;
    }

    /*
     * Exception decompiling
     */
    @Override
    public InetAddress getLocalAddress() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        Lock lock = this.proxiesLock.readLock();
        lock.lock();
        try {
            for (Proxy proxy : this.proxies) {
                if (proxy.getState() != MCMPServerState.State.DOWN) continue;
                proxy.setState(MCMPServerState.State.ERROR);
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public synchronized void status() {
        if (!this.init) {
            return;
        }
        this.status(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void status(boolean sendResetRequests) {
        this.processPendingDiscoveryEvents();
        Lock lock = this.proxiesLock.readLock();
        lock.lock();
        try {
            for (Proxy proxy : this.proxies) {
                if (proxy.getState() != MCMPServerState.State.ERROR) continue;
                proxy.setState(MCMPServerState.State.OK);
                String response = this.sendRequest(this.requestFactory.createInfoRequest(), proxy);
                if (proxy.getState() != MCMPServerState.State.OK) continue;
                proxy.setIoExceptionLogged(false);
                if (!sendResetRequests) continue;
                Map<String, Set<ResetRequestSource.VirtualHost>> parsedResponse = this.parseInfoResponse(response);
                List<MCMPRequest> requests = this.resetRequestSource.getResetRequests(parsedResponse);
                log.trace(requests);
                this.sendRequests(requests);
            }
        }
        finally {
            lock.unlock();
        }
    }

    private Map<String, Set<ResetRequestSource.VirtualHost>> parseInfoResponse(String response) {
        if (response == null) {
            return Collections.emptyMap();
        }
        log.trace((Object)response);
        HashMap<String, String> nodeMap = new HashMap<String, String>();
        HashMap virtualHostMap = new HashMap();
        block0: for (String line : response.split("\r\n|\r|\n")) {
            String hostId;
            String[] ids;
            String[] entries;
            if (line.startsWith("Node:")) {
                entries = line.split(",");
                String nodeId = this.parseIds(entries[0])[0];
                for (int i = 1; i < entries.length; ++i) {
                    String entry = entries[i];
                    int index = entry.indexOf(58);
                    if (index < 0) {
                        throw new IllegalArgumentException(response);
                    }
                    String key = entry.substring(0, index).trim();
                    String value = entry.substring(index + 1).trim();
                    if (!"Name".equals(key)) continue;
                    nodeMap.put(nodeId, value);
                    virtualHostMap.put(value, new HashMap());
                    continue block0;
                }
                continue;
            }
            if (line.startsWith("Vhost:")) {
                String hostId2;
                entries = line.split(",");
                ids = this.parseIds(entries[0]);
                if (ids.length != 3) {
                    throw new IllegalArgumentException(response);
                }
                String node = (String)nodeMap.get(ids[0]);
                if (node == null) {
                    throw new IllegalArgumentException(response);
                }
                Map hostMap = (Map)virtualHostMap.get(node);
                ResetRequestSource.VirtualHost host = (ResetRequestSource.VirtualHost)hostMap.get(hostId2 = ids[1]);
                if (host == null) {
                    host = new VirtualHostImpl();
                    hostMap.put(hostId2, host);
                }
                for (int i = 1; i < entries.length; ++i) {
                    String entry = entries[i];
                    int index = entry.indexOf(58);
                    if (index < 0) {
                        throw new IllegalArgumentException(response);
                    }
                    String key = entry.substring(0, index).trim();
                    String value = entry.substring(index + 1).trim();
                    if (!"Alias".equals(key)) continue;
                    host.getAliases().add(value);
                    continue block0;
                }
                continue;
            }
            if (!line.startsWith("Context:")) continue;
            entries = line.split(",");
            ids = this.parseIds(entries[0]);
            if (ids.length != 3) {
                throw new IllegalArgumentException(response);
            }
            String nodeId = ids[0];
            String node = (String)nodeMap.get(nodeId);
            if (node == null) {
                throw new IllegalArgumentException(response);
            }
            Map hostMap = (Map)virtualHostMap.get(node);
            ResetRequestSource.VirtualHost host = (ResetRequestSource.VirtualHost)hostMap.get(hostId = ids[1]);
            if (host == null) {
                throw new IllegalArgumentException(response);
            }
            String context = null;
            ResetRequestSource.Status status = null;
            for (int i = 1; i < entries.length; ++i) {
                String entry = entries[i];
                int index = entry.indexOf(58);
                if (index < 0) {
                    throw new IllegalArgumentException(response);
                }
                String key = entry.substring(0, index).trim();
                String value = entry.substring(index + 1).trim();
                if ("Context".equals(key)) {
                    context = value;
                    continue;
                }
                if (!"Status".equals(key)) continue;
                status = ResetRequestSource.Status.valueOf(value);
            }
            if (context == null || status == null) {
                throw new IllegalArgumentException(response);
            }
            host.getContexts().put(context, status);
        }
        HashMap<String, Set<ResetRequestSource.VirtualHost>> result = new HashMap<String, Set<ResetRequestSource.VirtualHost>>();
        for (Map.Entry entry : virtualHostMap.entrySet()) {
            result.put((String)entry.getKey(), new HashSet(((Map)entry.getValue()).values()));
        }
        log.trace(result);
        return result;
    }

    private String[] parseIds(String entry) {
        String[] stringArray;
        int end;
        int start = entry.indexOf(91) + 1;
        if (start >= (end = entry.indexOf(93))) {
            throw new IllegalArgumentException(entry);
        }
        String ids = entry.substring(start, end);
        if (ids.length() > 2) {
            stringArray = ids.split(":");
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = ids;
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendRequest(MCMPRequest request) {
        Lock lock = this.proxiesLock.readLock();
        lock.lock();
        try {
            for (Proxy proxy : this.proxies) {
                this.sendRequest(request, proxy);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendRequests(List<MCMPRequest> requests) {
        Lock lock = this.proxiesLock.readLock();
        lock.lock();
        try {
            for (Proxy proxy : this.proxies) {
                for (MCMPRequest request : requests) {
                    this.sendRequest(request, proxy);
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPendingDiscoveryEvents() {
        block7: {
            this.addRemoveProxiesLock.lock();
            try {
                if (this.addProxies.isEmpty() && this.removeProxies.isEmpty()) break block7;
                Lock lock = this.proxiesLock.writeLock();
                lock.lock();
                try {
                    this.proxies.addAll(this.addProxies);
                    this.proxies.removeAll(this.removeProxies);
                    this.addProxies.clear();
                    this.removeProxies.clear();
                    for (Proxy proxy : this.proxies) {
                        proxy.closeConnection();
                    }
                }
                finally {
                    lock.unlock();
                }
            }
            finally {
                this.addRemoveProxiesLock.unlock();
            }
        }
    }

    private String sendRequest(Proxy proxy, String command, char[] body, int length) throws IOException {
        BufferedWriter writer = proxy.getConnectionWriter();
        writer.write(command);
        writer.write(NEW_LINE);
        writer.write("Content-Length: ");
        writer.write(Integer.toString(length));
        writer.write(NEW_LINE);
        writer.write("User-Agent: ClusterListener/1.0");
        writer.write(NEW_LINE);
        writer.write("Connection: Keep-Alive");
        writer.write(NEW_LINE);
        writer.write(NEW_LINE);
        ((Writer)writer).write(body, 0, length);
        writer.write(NEW_LINE);
        ((Writer)writer).flush();
        return proxy.getConnectionReader().readLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String sendRequest(MCMPRequest request, Proxy proxy) {
        if (proxy.getState() != MCMPServerState.State.OK) {
            return null;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)this.sm.getString("modcluster.request", (Object)request, (Object)proxy));
        }
        String command = request.getRequestType().getCommand();
        boolean wildcard = request.isWildcard();
        String jvmRoute = request.getJvmRoute();
        Map<String, String> parameters = request.getParameters();
        MCMPURLEncoder encoder = Utils.createMCMPURLEncoder();
        try {
            if (jvmRoute != null) {
                encoder.encodeParameter("JVMRoute", jvmRoute, !parameters.isEmpty());
            }
            Iterator<Map.Entry<String, String>> entries = parameters.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry<String, String> entry = entries.next();
                encoder.encodeParameter(entry.getKey(), entry.getValue(), entries.hasNext());
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        Proxy proxy2 = proxy;
        synchronized (proxy2) {
            try {
                int bytes;
                StringBuilder builder = new StringBuilder();
                builder.append(command).append(" ");
                String proxyURL = this.config.getProxyURL();
                if (proxyURL != null) {
                    builder.append(proxyURL);
                }
                if (builder.charAt(builder.length() - 1) != '/') {
                    builder.append('/');
                }
                if (wildcard) {
                    builder.append('*');
                }
                builder.append(" HTTP/1.0");
                String head = builder.toString();
                int length = encoder.getLength();
                char[] body = encoder.getBuffer();
                String line = null;
                try {
                    line = this.sendRequest(proxy, head, body, length);
                }
                catch (IOException e2) {
                    // empty catch block
                }
                if (line == null) {
                    proxy.closeConnection();
                    line = this.sendRequest(proxy, head, body, length);
                }
                BufferedReader reader = proxy.getConnectionReader();
                int status = 500;
                String message = null;
                String errorType = null;
                int contentLength = 0;
                if (line != null) {
                    try {
                        int spaceIndex = line.indexOf(32);
                        String responseStatus = line.substring(spaceIndex + 1, line.indexOf(32, spaceIndex + 1));
                        status = Integer.parseInt(responseStatus);
                        line = reader.readLine();
                        while (line != null && line.length() > 0) {
                            int colon = line.indexOf(58);
                            String headerName = line.substring(0, colon).trim();
                            String headerValue = line.substring(colon + 1).trim();
                            if (!"version".equalsIgnoreCase(headerName)) {
                                if ("type".equalsIgnoreCase(headerName)) {
                                    errorType = headerValue;
                                } else if ("mess".equalsIgnoreCase(headerName)) {
                                    message = headerValue;
                                } else if ("content-length".equalsIgnoreCase(headerName)) {
                                    contentLength = Integer.parseInt(headerValue);
                                }
                            }
                            line = reader.readLine();
                        }
                    }
                    catch (Exception e322) {
                        log.info((Object)this.sm.getString("modcluster.error.parse", (Object)command), (Throwable)e322);
                    }
                }
                if (status == 200) {
                    if (request.getRequestType().getEstablishesServer()) {
                        proxy.setEstablished(true);
                    }
                } else if ("SYNTAX".equals(errorType)) {
                    proxy.setState(MCMPServerState.State.DOWN);
                    log.error((Object)this.sm.getString("modcluster.error.syntax", (Object)command, (Object)proxy, errorType, message));
                } else {
                    proxy.setState(MCMPServerState.State.ERROR);
                    log.error((Object)this.sm.getString("modcluster.error.other", (Object)command, (Object)proxy, errorType, message));
                }
                if (contentLength == 0) {
                    String e322 = null;
                    return e322;
                }
                StringBuilder result = new StringBuilder();
                char[] buffer = new char[512];
                while (contentLength > 0 && (bytes = reader.read(buffer, 0, contentLength > buffer.length ? buffer.length : contentLength)) > 0) {
                    result.append(buffer, 0, bytes);
                    contentLength -= bytes;
                }
                String string = result.toString();
                return string;
            }
            catch (IOException e) {
                proxy.setState(MCMPServerState.State.ERROR);
                if (!proxy.isIoExceptionLogged()) {
                    log.info((Object)this.sm.getString("modcluster.error.io", (Object)command, (Object)proxy), (Throwable)e);
                    proxy.setIoExceptionLogged(true);
                }
                String string2 = null;
                return string2;
            }
            finally {
                if (proxy.getState() != MCMPServerState.State.OK) {
                    proxy.closeConnection();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class VirtualHostImpl
    implements ResetRequestSource.VirtualHost,
    Externalizable {
        private final Set<String> aliases = new LinkedHashSet<String>();
        private final Map<String, ResetRequestSource.Status> contexts = new HashMap<String, ResetRequestSource.Status>();

        @Override
        public Set<String> getAliases() {
            return this.aliases;
        }

        @Override
        public Map<String, ResetRequestSource.Status> getContexts() {
            return this.contexts;
        }

        @Override
        public void readExternal(ObjectInput input) throws IOException {
            int aliases = input.readInt();
            for (int i = 0; i < aliases; ++i) {
                this.aliases.add(input.readUTF());
            }
            ResetRequestSource.Status[] stati = ResetRequestSource.Status.values();
            int contexts = input.readInt();
            for (int i = 0; i < contexts; ++i) {
                this.contexts.put(input.readUTF(), stati[input.readInt()]);
            }
        }

        @Override
        public void writeExternal(ObjectOutput output) throws IOException {
            output.writeInt(this.aliases.size());
            for (String string : this.aliases) {
                output.writeUTF(string);
            }
            output.writeInt(this.contexts.size());
            for (Map.Entry entry : this.contexts.entrySet()) {
                output.writeUTF((String)entry.getKey());
                output.writeInt(((ResetRequestSource.Status)((Object)entry.getValue())).ordinal());
            }
        }
    }

    @Immutable
    private static class MCMPServerStateImpl
    implements MCMPServerState,
    Serializable {
        private static final long serialVersionUID = 5219680414337319908L;
        private final MCMPServerState.State state;
        private final InetAddress address;
        private final int port;
        private final boolean established;

        MCMPServerStateImpl(MCMPServerState source) {
            this.state = source.getState();
            this.address = source.getAddress();
            this.port = source.getPort();
            this.established = source.isEstablished();
        }

        public MCMPServerState.State getState() {
            return this.state;
        }

        public InetAddress getAddress() {
            return this.address;
        }

        public int getPort() {
            return this.port;
        }

        public boolean isEstablished() {
            return this.established;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof MCMPServerStateImpl) {
                MCMPServerStateImpl other = (MCMPServerStateImpl)obj;
                return this.port == other.port && this.address.equals(other.address) && this.state == other.state && this.established == other.established;
            }
            return false;
        }

        public int hashCode() {
            int result = 17;
            result += 23 * (this.address == null ? 0 : this.address.hashCode());
            result += 23 * this.port;
            result += 23 * this.state.hashCode();
            return result += 23 * (this.established ? 0 : 1);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
            sb.append("{address=").append(this.address);
            sb.append(",port=").append(this.port);
            sb.append(",state=").append((Object)this.state);
            sb.append(",established=").append(this.established);
            sb.append("}");
            return sb.toString();
        }
    }

    @ThreadSafe
    private static class Proxy
    implements MCMPServerState {
        public static final int DEFAULT_PORT = 8000;
        private final StringManager sm = StringManager.getManager((String)Constants.Package);
        private final InetAddress address;
        private final int port;
        private final int socketTimeout;
        private final SocketFactory socketFactory;
        private volatile MCMPServerState.State state = MCMPServerState.State.OK;
        private volatile boolean established;
        private volatile boolean ioExceptionLogged;
        @GuardedBy(value="Proxy.this")
        private volatile Socket socket = null;
        @GuardedBy(value="Proxy.this")
        private volatile BufferedReader reader = null;
        @GuardedBy(value="Proxy.this")
        private volatile BufferedWriter writer = null;

        Proxy(InetAddress address, int port, MCMPHandlerConfiguration config) {
            if (address == null) {
                throw new IllegalArgumentException(this.sm.getString("modcluster.error.iae.null", (Object)"address"));
            }
            if (port <= 0) {
                throw new IllegalArgumentException(this.sm.getString("modcluster.error.iae.invalid", (Object)port, (Object)"port"));
            }
            this.address = address;
            this.port = port;
            this.socketFactory = config.isSsl() ? new JSSESocketFactory(config) : SocketFactory.getDefault();
            this.socketTimeout = config.getSocketTimeout();
        }

        public MCMPServerState.State getState() {
            return this.state;
        }

        public InetAddress getAddress() {
            return this.address;
        }

        public int getPort() {
            return this.port;
        }

        public boolean isEstablished() {
            return this.established;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            if (this.address != null) {
                builder.append(this.address.getHostAddress());
            }
            return builder.append(':').append(this.port).toString();
        }

        public boolean equals(Object object) {
            if (!(object instanceof Proxy)) {
                return false;
            }
            Proxy proxy = (Proxy)object;
            InetAddress address = proxy.address;
            return this.port == proxy.port && (this.address != null && address != null ? this.address.equals(address) : this.address == address);
        }

        public int hashCode() {
            int result = 17;
            result += 23 * (this.address == null ? 0 : this.address.hashCode());
            return result += 23 * this.port;
        }

        void setState(MCMPServerState.State state) {
            if (state == null) {
                throw new IllegalArgumentException(this.sm.getString("modcluster.error.iae.null", (Object)"state"));
            }
            this.state = state;
        }

        void setEstablished(boolean established) {
            this.established = established;
        }

        InetAddress getLocalAddress() throws IOException {
            return this.getConnection().getLocalAddress();
        }

        private synchronized Socket getConnection() throws IOException {
            if (this.socket == null || this.socket.isClosed()) {
                this.socket = this.socketFactory.createSocket(this.address, this.port);
                this.socket.setSoTimeout(this.socketTimeout);
            }
            return this.socket;
        }

        synchronized BufferedReader getConnectionReader() throws IOException {
            if (this.reader == null) {
                this.reader = new BufferedReader(new InputStreamReader(this.getConnection().getInputStream()));
            }
            return this.reader;
        }

        synchronized BufferedWriter getConnectionWriter() throws IOException {
            if (this.writer == null) {
                this.writer = new BufferedWriter(new OutputStreamWriter(this.getConnection().getOutputStream()));
            }
            return this.writer;
        }

        synchronized void closeConnection() {
            if (this.reader != null) {
                try {
                    this.reader.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                this.reader = null;
            }
            if (this.writer != null) {
                try {
                    this.writer.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                this.writer = null;
            }
            if (this.socket != null) {
                if (!this.socket.isClosed()) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.socket = null;
            }
        }

        boolean isIoExceptionLogged() {
            return this.ioExceptionLogged;
        }

        void setIoExceptionLogged(boolean ioErrorLogged) {
            this.ioExceptionLogged = ioErrorLogged;
        }
    }
}

