/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.mcmp.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Globals;
import org.apache.catalina.connector.Connector;
import org.apache.coyote.ProtocolHandler;
import org.apache.tomcat.util.IntrospectionUtils;
import org.jboss.modcluster.Utils;
import org.jboss.modcluster.config.BalancerConfiguration;
import org.jboss.modcluster.config.NodeConfiguration;
import org.jboss.modcluster.mcmp.MCMPRequest;
import org.jboss.modcluster.mcmp.MCMPRequestFactory;
import org.jboss.modcluster.mcmp.MCMPRequestType;
import org.jboss.modcluster.mcmp.impl.DefaultMCMPRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMCMPRequestFactory
implements MCMPRequestFactory {
    private static final Map<String, String> EMPTY_MAP = Collections.emptyMap();
    private final MCMPRequest infoRequest = new DefaultMCMPRequest(MCMPRequestType.INFO, false, null, EMPTY_MAP);
    private final MCMPRequest dumpRequest = new DefaultMCMPRequest(MCMPRequestType.DUMP, true, null, EMPTY_MAP);

    @Override
    public MCMPRequest createConfigRequest(Engine engine, NodeConfiguration nodeConfig, BalancerConfiguration balancerConfig) {
        int maxAttempts;
        int workerTimeout;
        String balancer;
        int nodeTimeout;
        int ttl;
        int smax;
        int ping;
        int flushWait;
        Connector connector = Utils.findProxyConnector(engine.getService().findConnectors());
        HashMap<String, String> parameters = new HashMap<String, String>();
        ProtocolHandler handler = connector.getProtocolHandler();
        boolean reverseConnection = Boolean.TRUE.equals(IntrospectionUtils.getProperty((Object)handler, (String)"reverseConnection"));
        boolean ssl = Boolean.TRUE.equals(IntrospectionUtils.getProperty((Object)handler, (String)"SSLEnabled"));
        boolean ajp = Utils.isAJP(connector);
        if (reverseConnection) {
            parameters.put("Reversed", "true");
        }
        parameters.put("Host", Utils.getAddress(connector));
        parameters.put("Port", "" + connector.getPort());
        if (ajp) {
            parameters.put("Type", "ajp");
        } else if (ssl) {
            parameters.put("Type", "https");
        } else {
            parameters.put("Type", "http");
        }
        String domain = nodeConfig.getDomain();
        if (domain != null) {
            parameters.put("Domain", domain);
        }
        if (nodeConfig.getFlushPackets()) {
            parameters.put("flushpackets", "On");
        }
        if ((flushWait = nodeConfig.getFlushWait()) != -1) {
            parameters.put("flushwait", String.valueOf(flushWait));
        }
        if ((ping = nodeConfig.getPing()) != -1) {
            parameters.put("ping", String.valueOf(ping));
        }
        if ((smax = nodeConfig.getSmax()) != -1) {
            parameters.put("smax", String.valueOf(smax));
        }
        if ((ttl = nodeConfig.getTtl()) != -1) {
            parameters.put("ttl", String.valueOf(ttl));
        }
        if ((nodeTimeout = nodeConfig.getNodeTimeout()) != -1) {
            parameters.put("Timeout", String.valueOf(nodeTimeout));
        }
        if ((balancer = nodeConfig.getBalancer()) != null) {
            parameters.put("Balancer", balancer);
        }
        if (!balancerConfig.getStickySession()) {
            parameters.put("StickySession", "No");
        }
        if (!Globals.SESSION_COOKIE_NAME.equals("JSESSIONID")) {
            parameters.put("StickySessionCookie", Globals.SESSION_COOKIE_NAME);
        }
        if (!Globals.SESSION_PARAMETER_NAME.equals("jsessionid")) {
            parameters.put("StickySessionPath", Globals.SESSION_PARAMETER_NAME);
        }
        if (balancerConfig.getStickySessionRemove()) {
            parameters.put("StickySessionRemove", "Yes");
        }
        if (!balancerConfig.getStickySessionForce()) {
            parameters.put("StickySessionForce", "No");
        }
        if ((workerTimeout = balancerConfig.getWorkerTimeout()) != -1) {
            parameters.put("WaitWorker", "" + workerTimeout);
        }
        if ((maxAttempts = balancerConfig.getMaxAttempts()) != -1) {
            parameters.put("Maxattempts", "" + maxAttempts);
        }
        return new DefaultMCMPRequest(MCMPRequestType.CONFIG, false, engine.getJvmRoute(), parameters);
    }

    @Override
    public MCMPRequest createDisableRequest(Context context) {
        return this.createRequest(MCMPRequestType.DISABLE_APP, context);
    }

    @Override
    public MCMPRequest createDisableRequest(Engine engine) {
        return this.createRequest(MCMPRequestType.DISABLE_APP, engine);
    }

    @Override
    public MCMPRequest createEnableRequest(Context context) {
        return this.createRequest(MCMPRequestType.ENABLE_APP, context);
    }

    @Override
    public MCMPRequest createEnableRequest(Engine engine) {
        return this.createRequest(MCMPRequestType.ENABLE_APP, engine);
    }

    @Override
    public MCMPRequest createRemoveRequest(Engine engine) {
        return this.createRequest(MCMPRequestType.REMOVE_APP, engine);
    }

    @Override
    public MCMPRequest createRemoveRequest(Context context) {
        return this.createRequest(MCMPRequestType.REMOVE_APP, context);
    }

    @Override
    public MCMPRequest createStatusRequest(String jvmRoute, int lbf) {
        return new DefaultMCMPRequest(MCMPRequestType.STATUS, false, jvmRoute, Collections.singletonMap("Load", String.valueOf(lbf)));
    }

    @Override
    public MCMPRequest createStopRequest(Context context) {
        return this.createRequest(MCMPRequestType.STOP_APP, context);
    }

    @Override
    public MCMPRequest createDumpRequest() {
        return this.dumpRequest;
    }

    @Override
    public MCMPRequest createInfoRequest() {
        return this.infoRequest;
    }

    private MCMPRequest createRequest(MCMPRequestType type, Context context) {
        return this.createRequest(type, Utils.getJvmRoute(context), Utils.getAliases(context), context.getPath());
    }

    @Override
    public MCMPRequest createRequest(MCMPRequestType type, String jvmRoute, Set<String> aliases, String path) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("Context", "".equals(path) ? "/" : path);
        StringBuilder builder = new StringBuilder();
        Iterator<String> hosts = aliases.iterator();
        while (hosts.hasNext()) {
            builder.append(hosts.next());
            if (!hosts.hasNext()) continue;
            builder.append(',');
        }
        parameters.put("Alias", builder.toString());
        return new DefaultMCMPRequest(type, false, jvmRoute, parameters);
    }

    private MCMPRequest createRequest(MCMPRequestType type, Engine engine) {
        return this.createRequest(type, engine.getJvmRoute());
    }

    private MCMPRequest createRequest(MCMPRequestType type, String jvmRoute) {
        return new DefaultMCMPRequest(type, true, jvmRoute, EMPTY_MAP);
    }
}

