/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.ha;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.apache.catalina.util.StringManager;
import org.jboss.ha.framework.interfaces.HAServiceKeyProvider;
import org.jboss.ha.framework.interfaces.HASingletonMBean;
import org.jboss.ha.framework.interfaces.ResponseFilter;
import org.jboss.logging.Logger;
import org.jboss.modcluster.Constants;
import org.jboss.modcluster.Utils;
import org.jboss.modcluster.ha.ClusteredMCMPHandler;
import org.jboss.modcluster.ha.rpc.ClusteredMCMPHandlerRpcHandler;
import org.jboss.modcluster.ha.rpc.DefaultRpcResponse;
import org.jboss.modcluster.ha.rpc.MCMPServerDiscoveryEvent;
import org.jboss.modcluster.ha.rpc.PeerMCMPDiscoveryStatus;
import org.jboss.modcluster.ha.rpc.RpcResponse;
import org.jboss.modcluster.ha.rpc.RpcResponseFilter;
import org.jboss.modcluster.mcmp.AbstractMCMPHandler;
import org.jboss.modcluster.mcmp.MCMPHandler;
import org.jboss.modcluster.mcmp.MCMPRequest;
import org.jboss.modcluster.mcmp.MCMPServer;
import org.jboss.modcluster.mcmp.MCMPServerState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class ClusteredMCMPHandlerImpl
extends AbstractMCMPHandler
implements ClusteredMCMPHandler {
    static final Object[] NULL_ARGS = new Object[0];
    static final Class<?>[] NULL_TYPES = new Class[0];
    static final Class<?>[] MCMPREQ_TYPES = new Class[]{MCMPRequest.class};
    static final Class<?>[] MCMPREQS_TYPES = new Class[]{List.class};
    static final Class<?>[] DISC_EVENT_TYPES = new Class[]{MCMPServerDiscoveryEvent.class};
    static final Logger log = Logger.getLogger(ClusteredMCMPHandlerImpl.class);
    final HAServiceKeyProvider serviceKeyProvider;
    private final MCMPHandler localHandler;
    private final HASingletonMBean singleton;
    private final ClusteredMCMPHandlerRpcHandler rpcStub = new RpcStub();
    private AtomicReference<ResetState> resetState = new AtomicReference<ResetState>(ResetState.NONE);
    @GuardedBy(value="pendingDiscoveryEvents")
    private List<MCMPServerDiscoveryEvent> pendingDiscoveryEvents = new LinkedList<MCMPServerDiscoveryEvent>();
    private AtomicInteger discoveryEventIndex = new AtomicInteger();
    final StringManager sm = StringManager.getManager((String)Constants.Package);

    public ClusteredMCMPHandlerImpl(MCMPHandler localHandler, HASingletonMBean singleton, HAServiceKeyProvider serviceKeyProvider) {
        this.localHandler = localHandler;
        this.singleton = singleton;
        this.serviceKeyProvider = serviceKeyProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MCMPServerDiscoveryEvent> getPendingDiscoveryEvents() {
        List<MCMPServerDiscoveryEvent> list = this.pendingDiscoveryEvents;
        synchronized (list) {
            return new ArrayList<MCMPServerDiscoveryEvent>(this.pendingDiscoveryEvents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void discoveryEventsReceived(PeerMCMPDiscoveryStatus status) {
        MCMPServerDiscoveryEvent latestEvent = status.getLatestDiscoveryEvent();
        if (latestEvent != null) {
            List<MCMPServerDiscoveryEvent> list = this.pendingDiscoveryEvents;
            synchronized (list) {
                Iterator<MCMPServerDiscoveryEvent> events = this.pendingDiscoveryEvents.iterator();
                while (events.hasNext() && latestEvent.compareTo(events.next()) >= 0) {
                    events.remove();
                }
            }
        }
    }

    @Override
    public Set<MCMPServerState> updateServersFromMasterNode(Set<MCMPServer> masterList) {
        for (MCMPServer mCMPServer : masterList) {
            this.localHandler.addProxy(mCMPServer.getAddress(), mCMPServer.getPort(), mCMPServer.isEstablished());
        }
        for (MCMPServerState mCMPServerState : this.localHandler.getProxyStates()) {
            if (masterList.contains(mCMPServerState)) continue;
            this.localHandler.removeProxy(mCMPServerState.getAddress(), mCMPServerState.getPort());
        }
        this.localHandler.status();
        return this.localHandler.getProxyStates();
    }

    @Override
    public boolean isResetNecessary() {
        return this.resetState.get() == ResetState.REQUIRED;
    }

    @Override
    public void resetInitiated() {
        this.resetState.set(ResetState.PENDING);
    }

    @Override
    public void resetCompleted() {
        this.resetState.compareAndSet(ResetState.PENDING, ResetState.NONE);
    }

    @Override
    public void addProxy(InetAddress address, int port) {
        if (this.singleton.isMasterNode()) {
            this.localHandler.addProxy(address, port);
        } else {
            this.sendDiscoveryEventToPartition(address, port, true);
        }
    }

    @Override
    public void addProxy(InetAddress address, int port, boolean established) {
        this.localHandler.addProxy(address, port, established);
    }

    @Override
    public void removeProxy(InetAddress address, int port) {
        if (this.singleton.isMasterNode()) {
            this.localHandler.removeProxy(address, port);
        } else {
            this.sendDiscoveryEventToPartition(address, port, false);
        }
    }

    @Override
    public Set<MCMPServerState> getProxyStates() {
        return this.localHandler.getProxyStates();
    }

    @Override
    public InetAddress getLocalAddress() throws IOException {
        return this.localHandler.getLocalAddress();
    }

    @Override
    public String getProxyConfiguration() {
        if (this.singleton.isMasterNode()) {
            return this.localHandler.getProxyConfiguration();
        }
        return this.rpcStub.getProxyConfiguration().getResult();
    }

    @Override
    public String getProxyInfo() {
        if (this.singleton.isMasterNode()) {
            return this.localHandler.getProxyInfo();
        }
        return this.rpcStub.getProxyInfo().getResult();
    }

    @Override
    public void init(List<InetSocketAddress> initialProxies) {
        if (this.singleton.isMasterNode()) {
            this.localHandler.init(initialProxies);
        } else {
            this.localHandler.init(new ArrayList<InetSocketAddress>());
            if (initialProxies != null) {
                for (InetSocketAddress proxy : initialProxies) {
                    this.sendDiscoveryEventToPartition(proxy.getAddress(), proxy.getPort(), true);
                }
            }
        }
    }

    @Override
    public boolean isProxyHealthOK() {
        if (this.singleton.isMasterNode()) {
            return this.localHandler.isProxyHealthOK();
        }
        return this.rpcStub.isProxyHealthOK().getResult();
    }

    @Override
    public void markProxiesInError() {
        this.recordRequestFailure();
        if (this.singleton.isMasterNode()) {
            this.localHandler.markProxiesInError();
        } else {
            this.rpcStub.markProxiesInError().getResult();
        }
    }

    @Override
    public void reset() {
        if (this.singleton.isMasterNode()) {
            this.localHandler.reset();
        } else {
            this.rpcStub.reset().getResult();
        }
    }

    @Override
    public Map<MCMPServerState, String> sendRequest(MCMPRequest request) {
        if (this.singleton.isMasterNode()) {
            return this.localHandler.sendRequest(request);
        }
        try {
            return this.rpcStub.sendRequest(request).getResult();
        }
        catch (RuntimeException e) {
            this.recordRequestFailure();
            throw e;
        }
    }

    @Override
    public Map<MCMPServerState, List<String>> sendRequests(List<MCMPRequest> requests) {
        if (this.singleton.isMasterNode()) {
            return this.localHandler.sendRequests(requests);
        }
        try {
            return this.rpcStub.sendRequests(requests).getResult();
        }
        catch (RuntimeException e) {
            this.recordRequestFailure();
            throw e;
        }
    }

    @Override
    public void shutdown() {
        this.localHandler.shutdown();
    }

    @Override
    public void status() {
        log.warn((Object)this.sm.getString("modcluster.error.status.unsupported"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendDiscoveryEventToPartition(InetAddress address, int port, boolean addition) {
        InetSocketAddress socketAddress = new InetSocketAddress(address, port);
        List<MCMPServerDiscoveryEvent> list = this.pendingDiscoveryEvents;
        synchronized (list) {
            MCMPServerDiscoveryEvent event = new MCMPServerDiscoveryEvent(this.serviceKeyProvider.getHAPartition().getClusterNode(), socketAddress, addition, this.discoveryEventIndex.incrementAndGet());
            this.pendingDiscoveryEvents.add(event);
            try {
                this.rpcStub.mcmpServerDiscoveryEvent(event).getResult();
            }
            catch (RuntimeException e) {
                String msg = addition ? "modcluster.error.discovery.add" : "modcluster.error.discovery.remove";
                log.error((Object)this.sm.getString(msg, (Object)address, (Object)port), (Throwable)e);
            }
        }
    }

    void recordRequestFailure() {
        this.resetState.set(ResetState.REQUIRED);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RpcStub
    implements ClusteredMCMPHandlerRpcHandler {
        RpcStub() {
        }

        @Override
        public RpcResponse<String> getProxyConfiguration() {
            return this.invokeRpc("getProxyConfiguration");
        }

        @Override
        public RpcResponse<String> getProxyInfo() {
            return this.invokeRpc("getProxyInfo");
        }

        @Override
        public RpcResponse<Boolean> isProxyHealthOK() {
            return this.invokeRpc("isProxyHealthOk");
        }

        @Override
        public RpcResponse<Void> markProxiesInError() {
            return this.invokeRpc("markProxiesInError");
        }

        @Override
        public RpcResponse<Void> mcmpServerDiscoveryEvent(MCMPServerDiscoveryEvent event) {
            try {
                return this.invokeRpc("mcmpServerDiscoveryEvent", new Object[]{event}, DISC_EVENT_TYPES);
            }
            catch (Exception e) {
                DefaultRpcResponse<Void> response = new DefaultRpcResponse<Void>(null);
                response.setException(e);
                return response;
            }
        }

        @Override
        public RpcResponse<Void> reset() {
            return this.invokeRpc("reset");
        }

        @Override
        public RpcResponse<Map<MCMPServerState, String>> sendRequest(MCMPRequest request) {
            return this.invokeRpc("sendRequest", new Object[]{request}, MCMPREQ_TYPES, true);
        }

        @Override
        public RpcResponse<Map<MCMPServerState, List<String>>> sendRequests(List<MCMPRequest> requests) {
            return this.invokeRpc("sendRequests", new Object[]{requests}, MCMPREQS_TYPES, true);
        }

        private <T> RpcResponse<T> invokeRpc(String methodName) {
            return this.invokeRpc(methodName, NULL_ARGS, NULL_TYPES, false);
        }

        private <T> RpcResponse<T> invokeRpc(String methodName, Object[] args, Class<?>[] types, boolean recordFailure) {
            try {
                return this.invokeRpc(methodName, args, types);
            }
            catch (Exception e) {
                if (recordFailure) {
                    ClusteredMCMPHandlerImpl.this.recordRequestFailure();
                }
                throw Utils.convertToUnchecked(e);
            }
        }

        private <T> RpcResponse<T> invokeRpc(String methodName, Object[] args, Class<?>[] types) throws Exception {
            ArrayList responses = ClusteredMCMPHandlerImpl.this.serviceKeyProvider.getHAPartition().callMethodOnCluster(ClusteredMCMPHandlerImpl.this.serviceKeyProvider.getHAServiceKey(), methodName, args, (Class[])types, false, (ResponseFilter)new RpcResponseFilter());
            Throwable thrown = null;
            for (Object obj : responses) {
                if (obj instanceof RpcResponse) {
                    return (RpcResponse)obj;
                }
                if (obj instanceof Throwable) {
                    if (thrown != null) continue;
                    thrown = (Throwable)obj;
                    continue;
                }
                log.warn((Object)ClusteredMCMPHandlerImpl.this.sm.getString("modcluster.error.rpc.unexpected", obj, (Object)methodName));
            }
            if (thrown != null) {
                throw Utils.convertToUnchecked(thrown);
            }
            throw new IllegalStateException(ClusteredMCMPHandlerImpl.this.sm.getString("modcluster.error.rpc.noresp", (Object)methodName));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ResetState {
        NONE,
        REQUIRED,
        PENDING;

    }
}

