/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.advertise.impl;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.jcip.annotations.GuardedBy;
import org.apache.catalina.util.StringManager;
import org.jboss.logging.Logger;
import org.jboss.modcluster.Constants;
import org.jboss.modcluster.advertise.AdvertiseListener;
import org.jboss.modcluster.advertise.MulticastSocketFactory;
import org.jboss.modcluster.advertise.impl.AdvertisedServer;
import org.jboss.modcluster.config.MCMPHandlerConfiguration;
import org.jboss.modcluster.mcmp.MCMPHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdvertiseListenerImpl
implements AdvertiseListener {
    public static final int DEFAULT_PORT = 23364;
    public static final String DEFAULT_GROUP = "224.0.1.105";
    public static final String DEFAULT_ENCODING = "8859_1";
    public static final String RFC_822_FMT = "EEE, d MMM yyyy HH:mm:ss Z";
    static final Logger log = Logger.getLogger(AdvertiseListenerImpl.class);
    volatile boolean listening = false;
    int advertisePort = 23364;
    InetAddress groupAddress = null;
    private MulticastSocketFactory socketFactory;
    private MulticastSocket socket;
    private boolean daemon = true;
    private String securityKey = null;
    MessageDigest md = null;
    final Map<String, AdvertisedServer> servers = new HashMap<String, AdvertisedServer>();
    final MCMPHandler commHandler;
    private AdvertiseListenerWorker workerThread;
    private StringManager sm = StringManager.getManager((String)Constants.Package);

    private static void digestString(MessageDigest md, String s) {
        int len = s.length();
        byte[] b = new byte[len];
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            b[i] = c < '\u007f' ? (int)c : 63;
        }
        md.update(b);
    }

    public AdvertiseListenerImpl(MCMPHandler commHandler, MCMPHandlerConfiguration config, MulticastSocketFactory socketFactory) {
        this.commHandler = commHandler;
        this.socketFactory = socketFactory;
        try {
            this.setGroupAddress(config.getAdvertiseGroupAddress());
            this.setAdvertisePort(config.getAdvertisePort());
            this.setSecurityKey(config.getAdvertiseSecurityKey());
        }
        catch (IOException e) {
            log.error((Object)this.sm.getString("modcluster.error.startListener"), (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)this.sm.getString("modcluster.error.startListener"), (Throwable)e);
        }
    }

    public void setDaemon(boolean b) {
        this.daemon = b;
    }

    public boolean getDaemon() {
        return this.daemon;
    }

    public void setSecurityKey(String key) throws NoSuchAlgorithmException {
        this.securityKey = key;
        if (this.md == null) {
            this.md = MessageDigest.getInstance("MD5");
        }
    }

    public void setAdvertisePort(int port) {
        this.advertisePort = port > 0 ? port : 23364;
    }

    public int getAdvertisePort() {
        return this.advertisePort;
    }

    public void setGroupAddress(String address) throws UnknownHostException {
        this.groupAddress = InetAddress.getByName(address != null ? address : DEFAULT_GROUP);
    }

    public String getGroupAddress() {
        return this.groupAddress.getHostAddress();
    }

    public Collection<AdvertisedServer> getServers() {
        return this.servers.values();
    }

    public AdvertisedServer getServer(String name) {
        return this.servers.get(name);
    }

    public void removeServer(AdvertisedServer server) {
        this.servers.values().remove(server);
    }

    private synchronized void init() throws IOException {
        if (this.socket == null) {
            MulticastSocket socket = this.socketFactory.createMulticastSocket(this.groupAddress, this.advertisePort);
            socket.setTimeToLive(0);
            socket.joinGroup(this.groupAddress);
            this.socket = socket;
        }
    }

    @Override
    public synchronized void start() throws IOException {
        this.init();
        if (this.workerThread == null) {
            this.workerThread = new AdvertiseListenerWorker(this.socket);
            this.workerThread.setDaemon(this.daemon);
            this.workerThread.start();
            this.listening = true;
            log.info((Object)this.sm.getString("modcluster.advertise.start", (Object)this.groupAddress.getHostAddress(), (Object)String.valueOf(this.advertisePort)));
        }
    }

    @Override
    public synchronized void pause() {
        if (this.workerThread != null) {
            this.workerThread.suspendWorker();
            this.interruptDatagramReader();
        }
    }

    @Override
    public synchronized void resume() {
        if (this.workerThread != null) {
            this.workerThread.resumeWorker();
        }
    }

    public synchronized void interruptDatagramReader() {
        if (this.socket == null) {
            return;
        }
        DatagramPacket packet = this.workerThread.createInterruptPacket(this.groupAddress, this.advertisePort);
        try {
            this.socket.send(packet);
        }
        catch (IOException e) {
            log.warn((Object)"Failed to interrupt socket reception", (Throwable)e);
        }
    }

    @Override
    public synchronized void stop() {
        this.resume();
        if (this.workerThread != null) {
            this.workerThread.interrupt();
            this.interruptDatagramReader();
            this.workerThread = null;
            this.listening = false;
        }
    }

    @Override
    public synchronized void destroy() {
        this.stop();
        if (this.socket != null) {
            try {
                this.socket.leaveGroup(this.groupAddress);
            }
            catch (IOException e) {
                log.warn((Object)e.getMessage(), (Throwable)e);
            }
            this.socket.close();
            this.socket = null;
        }
    }

    boolean verifyDigest(String digest, String server, String date) {
        if (this.md == null) {
            return true;
        }
        if (this.securityKey == null) {
            return true;
        }
        this.md.reset();
        AdvertiseListenerImpl.digestString(this.md, this.securityKey);
        AdvertiseListenerImpl.digestString(this.md, date);
        AdvertiseListenerImpl.digestString(this.md, server);
        byte[] dst = new byte[digest.length() * 2];
        int j = 0;
        for (int i = 0; i < digest.length(); ++i) {
            char ch = digest.charAt(i);
            dst[j++] = (byte)(ch >= 'A' ? (ch & 0xDF) - 65 + 10 : ch - 48);
        }
        return true;
    }

    public boolean isListening() {
        return this.listening;
    }

    class AdvertiseListenerWorker
    extends Thread {
        private final MulticastSocket socket;
        @GuardedBy(value="this")
        private boolean paused = false;
        @GuardedBy(value="this")
        private byte[] secure = this.generateSecure();

        AdvertiseListenerWorker(MulticastSocket socket) {
            this.socket = socket;
        }

        public synchronized void suspendWorker() {
            this.paused = true;
        }

        public synchronized void resumeWorker() {
            if (this.paused) {
                this.paused = false;
                this.secure = this.generateSecure();
                this.notify();
            }
        }

        public synchronized DatagramPacket createInterruptPacket(InetAddress address, int port) {
            return new DatagramPacket(this.secure, this.secure.length, address, port);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            SimpleDateFormat dateFormat = new SimpleDateFormat(AdvertiseListenerImpl.RFC_822_FMT, Locale.US);
            byte[] buffer = new byte[512];
            while (!this.isInterrupted()) {
                try {
                    String message;
                    AdvertiseListenerWorker advertiseListenerWorker = this;
                    synchronized (advertiseListenerWorker) {
                        if (this.paused) {
                            this.wait();
                        }
                    }
                    DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                    this.socket.receive(packet);
                    if (this.matchesSecure(packet) || !(message = new String(packet.getData(), 0, packet.getLength(), AdvertiseListenerImpl.DEFAULT_ENCODING)).startsWith("HTTP/1.")) continue;
                    String[] headers = message.split("\r\n");
                    String date_str = null;
                    Date date = null;
                    int status = 0;
                    String status_desc = null;
                    String digest = null;
                    String server_name = null;
                    AdvertisedServer server = null;
                    boolean added = false;
                    for (int i = 0; i < headers.length; ++i) {
                        if (i == 0) {
                            String[] sline = headers[i].split(" ", 3);
                            if (sline == null || sline.length != 3 || (status = Integer.parseInt(sline[1])) < 100) break;
                            status_desc = sline[2];
                            continue;
                        }
                        String[] hdrv = headers[i].split(": ", 2);
                        if (hdrv == null || hdrv.length != 2) break;
                        if (hdrv[0].equals("Date")) {
                            date_str = hdrv[1];
                            try {
                                date = dateFormat.parse(date_str);
                            }
                            catch (ParseException e) {
                                date = new Date();
                            }
                            continue;
                        }
                        if (hdrv[0].equals("Digest")) {
                            digest = hdrv[1];
                            continue;
                        }
                        if (hdrv[0].equals("Server")) {
                            server_name = hdrv[1];
                            server = AdvertiseListenerImpl.this.servers.get(server_name);
                            if (server != null) continue;
                            server = new AdvertisedServer(server_name);
                            added = true;
                            continue;
                        }
                        if (server == null) continue;
                        server.setParameter(hdrv[0], hdrv[1]);
                    }
                    if (server != null && status > 0) {
                        if (!AdvertiseListenerImpl.this.verifyDigest(digest, server_name, date_str)) continue;
                        server.setDate(date);
                        boolean rc = server.setStatus(status, status_desc);
                        if (added) {
                            AdvertiseListenerImpl.this.servers.put(server_name, server);
                            String proxy = server.getParameter(AdvertisedServer.MANAGER_ADDRESS);
                            if (proxy != null) {
                                AdvertiseListenerImpl.this.commHandler.addProxy(proxy);
                            }
                        } else if (rc) {
                            // empty if block
                        }
                    }
                    AdvertiseListenerImpl.this.listening = true;
                }
                catch (InterruptedException e) {
                    this.interrupt();
                }
                catch (IOException e) {
                    AdvertiseListenerImpl.this.listening = false;
                    Thread.yield();
                }
            }
        }

        private byte[] generateSecure() {
            SecureRandom random = new SecureRandom();
            byte[] secure = new byte[16];
            random.nextBytes(secure);
            secure[0] = 0;
            return secure;
        }

        synchronized boolean matchesSecure(DatagramPacket packet) {
            if (packet.getLength() != this.secure.length) {
                return false;
            }
            byte[] data = packet.getData();
            for (int i = 0; i < this.secure.length; ++i) {
                if (data[i] == this.secure[i]) continue;
                return false;
            }
            return true;
        }
    }
}

