/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.ha;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.util.StringManager;
import org.jboss.beans.metadata.api.annotations.Inject;
import org.jboss.beans.metadata.api.model.FromContext;
import org.jboss.ha.framework.interfaces.CachableMarshalledValue;
import org.jboss.ha.framework.interfaces.ClusterNode;
import org.jboss.ha.framework.interfaces.DistributedReplicantManager;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.interfaces.HAServiceKeyProvider;
import org.jboss.ha.framework.interfaces.HASingletonElectionPolicy;
import org.jboss.ha.framework.server.EventFactory;
import org.jboss.ha.framework.server.HAServiceEvent;
import org.jboss.ha.framework.server.HAServiceEventFactory;
import org.jboss.ha.framework.server.HAServiceRpcHandler;
import org.jboss.ha.framework.server.HASingletonImpl;
import org.jboss.ha.framework.server.SimpleCachableMarshalledValue;
import org.jboss.modcluster.CatalinaEventHandler;
import org.jboss.modcluster.CatalinaEventHandlerAdapter;
import org.jboss.modcluster.Constants;
import org.jboss.modcluster.ServerProvider;
import org.jboss.modcluster.Utils;
import org.jboss.modcluster.advertise.AdvertiseListenerFactory;
import org.jboss.modcluster.advertise.impl.AdvertiseListenerFactoryImpl;
import org.jboss.modcluster.config.BalancerConfiguration;
import org.jboss.modcluster.config.MCMPHandlerConfiguration;
import org.jboss.modcluster.config.NodeConfiguration;
import org.jboss.modcluster.config.ha.HAConfiguration;
import org.jboss.modcluster.config.ha.HAModClusterConfig;
import org.jboss.modcluster.ha.ClusteredMCMPHandler;
import org.jboss.modcluster.ha.ClusteredMCMPHandlerImpl;
import org.jboss.modcluster.ha.HAModClusterServiceMBean;
import org.jboss.modcluster.ha.HASingletonAwareResetRequestSource;
import org.jboss.modcluster.ha.HASingletonAwareResetRequestSourceImpl;
import org.jboss.modcluster.ha.ModClusterServiceDRMEntry;
import org.jboss.modcluster.ha.rpc.ClusteredMCMPHandlerRpcHandler;
import org.jboss.modcluster.ha.rpc.DefaultRpcResponse;
import org.jboss.modcluster.ha.rpc.MCMPServerDiscoveryEvent;
import org.jboss.modcluster.ha.rpc.ModClusterServiceRpcHandler;
import org.jboss.modcluster.ha.rpc.ModClusterServiceStatus;
import org.jboss.modcluster.ha.rpc.PeerMCMPDiscoveryStatus;
import org.jboss.modcluster.ha.rpc.ResetRequestSourceRpcHandler;
import org.jboss.modcluster.ha.rpc.RpcResponse;
import org.jboss.modcluster.load.LoadBalanceFactorProvider;
import org.jboss.modcluster.load.LoadBalanceFactorProviderFactory;
import org.jboss.modcluster.mcmp.MCMPHandler;
import org.jboss.modcluster.mcmp.MCMPRequest;
import org.jboss.modcluster.mcmp.MCMPRequestFactory;
import org.jboss.modcluster.mcmp.MCMPServer;
import org.jboss.modcluster.mcmp.MCMPServerState;
import org.jboss.modcluster.mcmp.ResetRequestSource;
import org.jboss.modcluster.mcmp.impl.DefaultMCMPHandler;
import org.jboss.modcluster.mcmp.impl.DefaultMCMPRequestFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HAModClusterService
extends HASingletonImpl<HAServiceEvent>
implements LifecycleListener,
HAModClusterServiceMBean,
ModClusterServiceRpcHandler<List<RpcResponse<ModClusterServiceStatus>>, MCMPServerState>,
LoadBalanceFactorProviderFactory,
ServerProvider<Server> {
    private static final Class<?>[] CLUSTER_STATUS_COMPLETE_TYPES = new Class[]{Map.class};
    private static final Class<?>[] GET_CLUSTER_COORDINATOR_STATE_TYPES = new Class[]{Set.class};
    final MCMPHandler localHandler;
    final MCMPRequestFactory requestFactory;
    final ClusteredMCMPHandler clusteredHandler;
    final HASingletonAwareResetRequestSource resetRequestSource;
    final Map<ClusterNode, MCMPServerDiscoveryEvent> proxyChangeDigest = new HashMap<ClusterNode, MCMPServerDiscoveryEvent>();
    final ModClusterServiceDRMEntry drmEntry;
    final StringManager sm = StringManager.getManager((String)Constants.Package);
    private final ServerProvider<Server> serverProvider;
    private final LifecycleListener lifecycleListener;
    private final LoadBalanceFactorProvider loadBalanceFactorProvider;
    private final RpcHandler rpcHandler;
    private final String domain;
    private final boolean masterPerDomain;
    volatile int latestLoad;
    volatile int statusCount = 0;
    volatile int processStatusFrequency = 1;

    public HAModClusterService(HAPartition partition, HAModClusterConfig config, LoadBalanceFactorProvider loadFactorProvider) {
        this(partition, config, loadFactorProvider, null);
    }

    public HAModClusterService(HAPartition partition, HAModClusterConfig config, LoadBalanceFactorProvider loadFactorProvider, HASingletonElectionPolicy electionPolicy) {
        super((EventFactory)new HAServiceEventFactory());
        ClusteredCatalinaEventHandler eventHandler;
        assert (partition != null) : this.sm.getString("modcluster.error.iae.null", (Object)"partition");
        assert (loadFactorProvider != null) : this.sm.getString("modcluster.error.iae.null", (Object)"loadFactorProvider");
        assert (config != null) : this.sm.getString("modcluster.error.iae.null", (Object)"config is null");
        this.setHAPartition(partition);
        this.loadBalanceFactorProvider = loadFactorProvider;
        this.requestFactory = new DefaultMCMPRequestFactory();
        this.resetRequestSource = new HASingletonAwareResetRequestSourceImpl(config, config, this, this.requestFactory, this, (HAServiceKeyProvider)this);
        this.localHandler = new DefaultMCMPHandler(config, this.resetRequestSource, this.requestFactory);
        this.clusteredHandler = new ClusteredMCMPHandlerImpl(this.localHandler, this, (HAServiceKeyProvider)this);
        this.serverProvider = eventHandler = new ClusteredCatalinaEventHandler(config, config, config, this.clusteredHandler, this.resetRequestSource, this.requestFactory, this, new AdvertiseListenerFactoryImpl());
        this.lifecycleListener = new CatalinaEventHandlerAdapter(eventHandler);
        this.domain = config.getDomain();
        this.masterPerDomain = config.isMasterPerDomain();
        this.setElectionPolicy(electionPolicy);
        this.drmEntry = new ModClusterServiceDRMEntry(partition.getClusterNode(), null);
        this.rpcHandler = new RpcHandler();
    }

    protected HAModClusterService(HAPartition partition, NodeConfiguration nodeConfig, BalancerConfiguration balancerConfig, MCMPHandlerConfiguration mcmpConfig, HAConfiguration haConfig, MCMPHandler localHandler, ServerProvider<Server> serverProvider, MCMPRequestFactory requestFactory, HASingletonAwareResetRequestSource resetRequestSource, ClusteredMCMPHandler clusteredHandler, LifecycleListener lifecycleListener, LoadBalanceFactorProvider loadFactorProvider, HASingletonElectionPolicy electionPolicy) {
        super((EventFactory)new HAServiceEventFactory());
        this.setHAPartition(partition);
        this.loadBalanceFactorProvider = loadFactorProvider;
        this.localHandler = localHandler;
        this.serverProvider = serverProvider;
        this.requestFactory = requestFactory;
        this.resetRequestSource = resetRequestSource;
        this.clusteredHandler = clusteredHandler;
        this.lifecycleListener = lifecycleListener;
        this.domain = nodeConfig.getDomain();
        this.masterPerDomain = haConfig.isMasterPerDomain();
        this.setElectionPolicy(electionPolicy);
        this.drmEntry = new ModClusterServiceDRMEntry(partition.getClusterNode(), null);
        this.rpcHandler = new RpcHandler();
    }

    @Override
    public Server getServer() {
        return this.serverProvider.getServer();
    }

    public void lifecycleEvent(LifecycleEvent event) {
        this.lifecycleListener.lifecycleEvent(event);
    }

    @Override
    public LoadBalanceFactorProvider createLoadBalanceFactorProvider() {
        return this.loadBalanceFactorProvider;
    }

    @Override
    public void addProxy(String host, int port) {
        this.clusteredHandler.addProxy(host, port);
    }

    @Override
    public void removeProxy(String host, int port) {
        this.clusteredHandler.removeProxy(host, port);
    }

    @Override
    public String getProxyInfo() {
        return this.clusteredHandler.getProxyInfo();
    }

    @Override
    public String getProxyConfiguration() {
        return this.clusteredHandler.getProxyConfiguration();
    }

    @Override
    public void refresh() {
        this.clusteredHandler.markProxiesInError();
    }

    @Override
    public void reset() {
        this.clusteredHandler.reset();
    }

    @Override
    public boolean disable() {
        for (Service service : this.serverProvider.getServer().findServices()) {
            Engine engine = (Engine)service.getContainer();
            MCMPRequest request = this.requestFactory.createDisableRequest(engine);
            this.clusteredHandler.sendRequest(request);
        }
        return this.clusteredHandler.isProxyHealthOK();
    }

    @Override
    public boolean enable() {
        for (Service service : this.serverProvider.getServer().findServices()) {
            Engine engine = (Engine)service.getContainer();
            MCMPRequest request = this.requestFactory.createEnableRequest(engine);
            this.clusteredHandler.sendRequest(request);
        }
        return this.clusteredHandler.isProxyHealthOK();
    }

    @Override
    public boolean disable(String host, String path) {
        Context context = Utils.getContext(Utils.getHost(this.serverProvider.getServer(), host), path);
        MCMPRequest request = this.requestFactory.createDisableRequest(context);
        this.clusteredHandler.sendRequest(request);
        return this.clusteredHandler.isProxyHealthOK();
    }

    @Override
    public boolean enable(String host, String path) {
        Context context = Utils.getContext(Utils.getHost(this.serverProvider.getServer(), host), path);
        MCMPRequest request = this.requestFactory.createEnableRequest(context);
        this.clusteredHandler.sendRequest(request);
        return this.clusteredHandler.isProxyHealthOK();
    }

    public String getDomain() {
        return this.domain;
    }

    @Override
    public int getProcessStatusFrequency() {
        return this.processStatusFrequency;
    }

    @Override
    public void setProcessStatusFrequency(int processStatusFrequency) {
        this.processStatusFrequency = processStatusFrequency;
    }

    public void startSingleton() {
        this.statusCount = this.processStatusFrequency - 1;
    }

    @Inject(fromContext=FromContext.NAME)
    public void setServiceHAName(String haName) {
        super.setServiceHAName(haName);
    }

    protected HAServiceRpcHandler<HAServiceEvent> getRpcHandler() {
        return this.rpcHandler;
    }

    public String getHAServiceKey() {
        String name = this.getServiceHAName();
        return this.domain != null && this.masterPerDomain ? name + ":" + this.domain : name;
    }

    protected Serializable getReplicant() {
        return this.createReplicant(this.drmEntry);
    }

    protected List<ClusterNode> getElectionCandidates() {
        return this.narrowCandidateList(this.lookupDRMEntries());
    }

    List<ClusterNode> narrowCandidateList(Collection<ModClusterServiceDRMEntry> candidates) {
        if (candidates == null) {
            return null;
        }
        ArrayList<ClusterNode> narrowed = new ArrayList<ClusterNode>(candidates.size());
        ModClusterServiceDRMEntry champion = null;
        for (ModClusterServiceDRMEntry candidate : candidates) {
            if (champion == null) {
                champion = candidate;
                narrowed.add(candidate.getPeer());
                continue;
            }
            int compFactor = candidate.compareTo(champion);
            if (compFactor < 0) {
                narrowed.clear();
                champion = candidate;
                narrowed.add(candidate.getPeer());
                continue;
            }
            if (compFactor != 0) continue;
            narrowed.add(candidate.getPeer());
        }
        return narrowed;
    }

    @Override
    public void clusterStatusComplete(Map<ClusterNode, PeerMCMPDiscoveryStatus> statuses) {
        try {
            this.callMethodOnPartition("clusterStatusComplete", new Object[]{statuses}, CLUSTER_STATUS_COMPLETE_TYPES);
        }
        catch (Exception e) {
            this.log.error((Object)this.sm.getString("modcluster.error.status.complete"), (Throwable)e);
        }
    }

    @Override
    public List<RpcResponse<ModClusterServiceStatus>> getClusterCoordinatorState(Set<MCMPServerState> masterList) {
        try {
            return this.callMethodOnPartition("getClusterCoordinatorState", new Object[]{masterList}, GET_CLUSTER_COORDINATOR_STATE_TYPES);
        }
        catch (Exception e) {
            throw Utils.convertToUnchecked(e);
        }
    }

    void updateLocalDRM(ModClusterServiceDRMEntry entry) {
        DistributedReplicantManager drm = this.getHAPartition().getDistributedReplicantManager();
        try {
            drm.add(this.getHAServiceKey(), this.createReplicant(entry));
        }
        catch (Exception e) {
            throw Utils.convertToUnchecked(e);
        }
    }

    List<ModClusterServiceDRMEntry> lookupDRMEntries() {
        DistributedReplicantManager drm = this.getHAPartition().getDistributedReplicantManager();
        List values = drm.lookupReplicants(this.getHAServiceKey());
        if (values == null) {
            return null;
        }
        ArrayList<ModClusterServiceDRMEntry> entries = new ArrayList<ModClusterServiceDRMEntry>(values.size());
        for (CachableMarshalledValue value : values) {
            entries.add(this.toDRMEntry(value));
        }
        return entries;
    }

    ModClusterServiceDRMEntry lookupLocalDRMEntry() {
        DistributedReplicantManager drm = this.getHAPartition().getDistributedReplicantManager();
        return this.toDRMEntry((CachableMarshalledValue)drm.lookupLocalReplicant(this.getHAServiceKey()));
    }

    private Serializable createReplicant(ModClusterServiceDRMEntry entry) {
        return new SimpleCachableMarshalledValue((Serializable)entry);
    }

    private ModClusterServiceDRMEntry toDRMEntry(CachableMarshalledValue value) {
        if (value == null) {
            return null;
        }
        try {
            Object entry = value.get();
            if (!(entry instanceof ModClusterServiceDRMEntry)) {
                value.toByteArray();
                entry = value.get();
            }
            return (ModClusterServiceDRMEntry)entry;
        }
        catch (Exception e) {
            throw Utils.convertToUnchecked(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClusteredCatalinaEventHandler
    extends CatalinaEventHandler {
        private final HAModClusterService coord;

        public ClusteredCatalinaEventHandler(NodeConfiguration nodeConfig, BalancerConfiguration balancerConfig, MCMPHandlerConfiguration mcmpConfig, MCMPHandler clusteredHandler, ResetRequestSource source, MCMPRequestFactory requestFactory, LoadBalanceFactorProviderFactory loadFactorProviderFactory, AdvertiseListenerFactory listenerFactory) {
            super(nodeConfig, balancerConfig, mcmpConfig, clusteredHandler, source, requestFactory, loadFactorProviderFactory, listenerFactory);
            this.coord = HAModClusterService.this;
        }

        @Override
        protected void config(Engine engine) {
            this.config(engine, this.coord.localHandler);
        }

        @Override
        protected void jvmRouteEstablished(Engine engine) {
            this.coord.drmEntry.addJvmRoute(engine.getJvmRoute());
            this.coord.updateLocalDRM(this.coord.drmEntry);
        }

        @Override
        protected void removeAll(Engine engine) {
            super.removeAll(engine);
            this.coord.drmEntry.removeJvmRoute(engine.getJvmRoute());
            this.coord.updateLocalDRM(this.coord.drmEntry);
        }

        @Override
        public void status(Engine engine) {
            this.checkInit();
            this.coord.log.debug((Object)this.coord.sm.getString("modcluster.engine.status", (Object)engine.getName()));
            this.coord.latestLoad = this.getLoadBalanceFactor();
            if (this.coord.isMasterNode()) {
                this.coord.statusCount = (this.coord.statusCount + 1) % this.coord.processStatusFrequency;
                if (this.coord.statusCount == 0) {
                    this.updateClusterStatus();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateClusterStatus() {
            Set<MCMPServerState> masterList = null;
            HashMap<ClusterNode, MCMPServerDiscoveryEvent> latestEvents = null;
            HashMap<ClusterNode, ModClusterServiceDRMEntry> nonresponsive = new HashMap<ClusterNode, ModClusterServiceDRMEntry>();
            HashMap<String, Integer> loadBalanceFactors = new HashMap<String, Integer>();
            HashMap<ClusterNode, PeerMCMPDiscoveryStatus> statuses = new HashMap<ClusterNode, PeerMCMPDiscoveryStatus>();
            ArrayList<MCMPRequest> resetRequests = new ArrayList<MCMPRequest>();
            HAPartition partition = this.coord.getHAPartition();
            boolean resync = false;
            do {
                resync = false;
                this.coord.localHandler.status();
                Map<ClusterNode, MCMPServerDiscoveryEvent> map = this.coord.proxyChangeDigest;
                synchronized (map) {
                    masterList = this.coord.localHandler.getProxyStates();
                    latestEvents = new HashMap<ClusterNode, MCMPServerDiscoveryEvent>(this.coord.proxyChangeDigest);
                }
                List<ModClusterServiceDRMEntry> replicants = this.coord.lookupDRMEntries();
                nonresponsive.clear();
                for (ModClusterServiceDRMEntry modClusterServiceDRMEntry : replicants) {
                    nonresponsive.put(modClusterServiceDRMEntry.getPeer(), modClusterServiceDRMEntry);
                }
                nonresponsive.remove(partition.getClusterNode());
                Object responses = this.coord.getClusterCoordinatorState((Set)masterList);
                resetRequests.clear();
                loadBalanceFactors.clear();
                for (String string : this.coord.drmEntry.getJvmRoutes()) {
                    loadBalanceFactors.put(string, this.coord.latestLoad);
                }
                statuses.clear();
                Iterator iterator = responses.iterator();
                while (iterator.hasNext()) {
                    RpcResponse rpcResponse = (RpcResponse)iterator.next();
                    if (rpcResponse == null) continue;
                    ClusterNode node = rpcResponse.getSender();
                    try {
                        ModClusterServiceDRMEntry removed;
                        ModClusterServiceStatus state = (ModClusterServiceStatus)rpcResponse.getResult();
                        MCMPServerDiscoveryEvent latestEvent = (MCMPServerDiscoveryEvent)latestEvents.get(node);
                        for (MCMPServerDiscoveryEvent event : state.getUnacknowledgedEvents()) {
                            if (latestEvent != null && latestEvent.compareTo(event) >= 0) continue;
                            InetSocketAddress socketAddress = event.getMCMPServer();
                            if (event.isAddition()) {
                                this.coord.localHandler.addProxy(socketAddress.getAddress(), socketAddress.getPort());
                            } else {
                                this.coord.localHandler.removeProxy(socketAddress.getAddress(), socketAddress.getPort());
                            }
                            resync = true;
                        }
                        if (resync) continue;
                        statuses.put(node, new PeerMCMPDiscoveryStatus(node, state.getStates(), latestEvent));
                        List<MCMPRequest> toAdd = state.getResetRequests();
                        if (toAdd != null) {
                            resetRequests.addAll(toAdd);
                        }
                        if ((removed = (ModClusterServiceDRMEntry)nonresponsive.remove(node)) == null) continue;
                        Integer lbf = state.getLoadBalanceFactor();
                        for (String jvmRoute : removed.getJvmRoutes()) {
                            loadBalanceFactors.put(jvmRoute, lbf);
                        }
                    }
                    catch (Exception e) {
                        this.coord.log.warn((Object)this.coord.sm.getString("modcluster.error.rpc.known", (Object)"getClusterCoordinatorState", (Object)node), (Throwable)e);
                    }
                }
            } while (resync);
            Integer lbf = 0;
            for (Map.Entry entry : nonresponsive.entrySet()) {
                ClusterNode clusterNode = (ClusterNode)entry.getKey();
                statuses.put((ClusterNode)entry.getKey(), new PeerMCMPDiscoveryStatus(clusterNode, null, (MCMPServerDiscoveryEvent)latestEvents.get(clusterNode)));
                for (String jvmRoute : ((ModClusterServiceDRMEntry)entry.getValue()).getJvmRoutes()) {
                    loadBalanceFactors.put(jvmRoute, lbf);
                }
            }
            this.coord.localHandler.sendRequests(resetRequests);
            ArrayList<MCMPRequest> statusRequests = new ArrayList<MCMPRequest>();
            for (Map.Entry entry : loadBalanceFactors.entrySet()) {
                statusRequests.add(this.coord.requestFactory.createStatusRequest((String)entry.getKey(), (Integer)entry.getValue()));
            }
            this.coord.localHandler.sendRequests(statusRequests);
            this.notifyClusterStatusComplete(masterList, statuses);
        }

        private void notifyClusterStatusComplete(Set<MCMPServerState> masterList, Map<ClusterNode, PeerMCMPDiscoveryStatus> statuses) {
            boolean updated;
            HAPartition partition = this.coord.getHAPartition();
            HashSet<ModClusterServiceDRMEntry> allStatuses = new HashSet<ModClusterServiceDRMEntry>(statuses.values());
            ModClusterServiceDRMEntry ourCurrentStatus = this.coord.lookupLocalDRMEntry();
            allStatuses.add((PeerMCMPDiscoveryStatus)ourCurrentStatus);
            ClusterNode node = partition.getClusterNode();
            boolean othersFirst = this.coord.narrowCandidateList(allStatuses).contains(node);
            ModClusterServiceDRMEntry newStatus = new ModClusterServiceDRMEntry(node, masterList, this.coord.drmEntry.getJvmRoutes());
            boolean bl = updated = !newStatus.equals(ourCurrentStatus);
            if (othersFirst) {
                this.coord.clusterStatusComplete(statuses);
            }
            if (updated) {
                this.coord.updateLocalDRM(newStatus);
            }
            if (!othersFirst) {
                this.coord.clusterStatusComplete(statuses);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class RpcHandler
    extends HASingletonImpl.RpcHandler
    implements ModClusterServiceRpcHandler<RpcResponse<ModClusterServiceStatus>, MCMPServer>,
    ClusteredMCMPHandlerRpcHandler,
    ResetRequestSourceRpcHandler<RpcResponse<List<MCMPRequest>>> {
        private final HAModClusterService coord;
        private final ClusterNode node;
        private final RpcResponse<Void> voidResponse;

        protected RpcHandler() {
            super((HASingletonImpl)HAModClusterService.this);
            this.coord = HAModClusterService.this;
            this.node = this.coord.getHAPartition().getClusterNode();
            this.voidResponse = new DefaultRpcResponse<Void>(this.node);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RpcResponse<Void> mcmpServerDiscoveryEvent(MCMPServerDiscoveryEvent event) {
            if (!this.coord.isMasterNode()) {
                return null;
            }
            Map<ClusterNode, MCMPServerDiscoveryEvent> map = HAModClusterService.this.proxyChangeDigest;
            synchronized (map) {
                InetSocketAddress socketAddress = event.getMCMPServer();
                if (event.isAddition()) {
                    this.coord.localHandler.addProxy(socketAddress.getAddress(), socketAddress.getPort());
                } else {
                    this.coord.localHandler.removeProxy(socketAddress.getAddress(), socketAddress.getPort());
                }
                HAModClusterService.this.proxyChangeDigest.put(event.getSender(), event);
                return this.voidResponse;
            }
        }

        @Override
        public RpcResponse<ModClusterServiceStatus> getClusterCoordinatorState(Set<MCMPServer> masterList) {
            if (this.coord.isMasterNode()) {
                return null;
            }
            Set<MCMPServerState> ourStates = this.coord.clusteredHandler.updateServersFromMasterNode(masterList);
            boolean needReset = this.coord.clusteredHandler.isResetNecessary();
            Map<String, Set<ResetRequestSource.VirtualHost>> map = Collections.emptyMap();
            List<MCMPRequest> resetRequests = needReset ? this.coord.resetRequestSource.getLocalResetRequests(map) : null;
            List<MCMPServerDiscoveryEvent> events = this.coord.clusteredHandler.getPendingDiscoveryEvents();
            DefaultRpcResponse<ModClusterServiceStatus> response = new DefaultRpcResponse<ModClusterServiceStatus>(this.node);
            response.setResult(new ModClusterServiceStatus(this.coord.latestLoad, ourStates, events, resetRequests));
            if (needReset) {
                this.coord.clusteredHandler.resetInitiated();
            }
            return response;
        }

        @Override
        public void clusterStatusComplete(Map<ClusterNode, PeerMCMPDiscoveryStatus> statuses) {
            HAPartition partition = this.coord.getHAPartition();
            ClusterNode cn = partition.getClusterNode();
            PeerMCMPDiscoveryStatus status = statuses.get(cn);
            if (status != null) {
                this.coord.clusteredHandler.discoveryEventsReceived(status);
                this.coord.clusteredHandler.resetCompleted();
                ModClusterServiceDRMEntry previousStatus = this.coord.lookupLocalDRMEntry();
                if (!status.equals(previousStatus)) {
                    try {
                        this.coord.updateLocalDRM(new ModClusterServiceDRMEntry(cn, status.getMCMPServerStates(), previousStatus.getJvmRoutes()));
                    }
                    catch (Exception e) {
                        this.coord.log.error((Object)HAModClusterService.this.sm.getString("modcluster.error.drm"), (Throwable)e);
                    }
                }
            }
        }

        @Override
        public RpcResponse<String> getProxyConfiguration() {
            if (!this.coord.isMasterNode()) {
                return null;
            }
            DefaultRpcResponse<String> response = new DefaultRpcResponse<String>(this.node);
            response.setResult(this.coord.localHandler.getProxyConfiguration());
            return response;
        }

        @Override
        public RpcResponse<String> getProxyInfo() {
            if (!this.coord.isMasterNode()) {
                return null;
            }
            DefaultRpcResponse<String> response = new DefaultRpcResponse<String>(this.node);
            response.setResult(this.coord.localHandler.getProxyInfo());
            return response;
        }

        @Override
        public RpcResponse<Boolean> isProxyHealthOK() {
            if (!this.coord.isMasterNode()) {
                return null;
            }
            DefaultRpcResponse<Boolean> response = new DefaultRpcResponse<Boolean>(this.node);
            response.setResult(this.coord.localHandler.isProxyHealthOK());
            return response;
        }

        @Override
        public RpcResponse<Void> markProxiesInError() {
            if (!this.coord.isMasterNode()) {
                return null;
            }
            this.coord.localHandler.markProxiesInError();
            return this.voidResponse;
        }

        @Override
        public RpcResponse<Void> reset() {
            if (!this.coord.isMasterNode()) {
                return null;
            }
            this.coord.localHandler.reset();
            return this.voidResponse;
        }

        @Override
        public RpcResponse<Map<MCMPServerState, String>> sendRequest(MCMPRequest request) {
            if (!this.coord.isMasterNode()) {
                return null;
            }
            DefaultRpcResponse<Map<MCMPServerState, String>> response = new DefaultRpcResponse<Map<MCMPServerState, String>>(this.node);
            response.setResult(this.coord.localHandler.sendRequest(request));
            return response;
        }

        @Override
        public RpcResponse<Map<MCMPServerState, List<String>>> sendRequests(List<MCMPRequest> requests) {
            if (!this.coord.isMasterNode()) {
                return null;
            }
            DefaultRpcResponse<Map<MCMPServerState, List<String>>> response = new DefaultRpcResponse<Map<MCMPServerState, List<String>>>(this.node);
            response.setResult(this.coord.localHandler.sendRequests(requests));
            return response;
        }

        @Override
        public RpcResponse<List<MCMPRequest>> getResetRequests(Map<String, Set<ResetRequestSource.VirtualHost>> infoResponse) {
            DefaultRpcResponse<List<MCMPRequest>> response = new DefaultRpcResponse<List<MCMPRequest>>(this.node);
            response.setResult(this.coord.resetRequestSource.getLocalResetRequests(infoResponse));
            return response;
        }
    }
}

