/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5;

import java.io.File;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.operation.EmsOperation;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.core.pluginapi.util.ProcessExecutionUtility;
import org.rhq.core.system.ProcessExecution;
import org.rhq.core.system.ProcessExecutionResults;
import org.rhq.core.system.SystemInfo;
import org.rhq.plugins.jbossas5.ApplicationServerComponent;
import org.rhq.plugins.jbossas5.ApplicationServerShutdownMethod;
import org.rhq.plugins.jbossas5.ApplicationServerSupportedOperations;

public class ApplicationServerOperationsDelegate {
    private static final long STOP_WAIT_MAX = 150000L;
    private static final long STOP_WAIT_INTERVAL = 10000L;
    private static final long STOP_WAIT_FINAL = 30000L;
    private static final long START_WAIT_MAX = 300000L;
    private static final long START_WAIT_INTERVAL = 10000L;
    private final Log log = LogFactory.getLog(ApplicationServerOperationsDelegate.class);
    private static final String SEPARATOR = "\n-----------------------\n";
    static final String DEFAULT_START_SCRIPT = "bin" + File.separator + "run." + (File.separatorChar == '/' ? "sh" : "bat");
    static final String DEFAULT_SHUTDOWN_SCRIPT = "bin" + File.separator + "shutdown." + (File.separatorChar == '/' ? "sh" : "bat");
    private ApplicationServerComponent serverComponent;
    private Configuration pluginConfig;
    private ResourceContext resourceContext;
    private File configPath;
    private SystemInfo systemInfo;

    public ApplicationServerOperationsDelegate(ApplicationServerComponent serverComponent, SystemInfo systemInfo) {
        this.serverComponent = serverComponent;
        this.resourceContext = serverComponent.getResourceContext();
        this.pluginConfig = this.resourceContext.getPluginConfiguration();
        this.systemInfo = systemInfo;
    }

    public OperationResult invoke(ApplicationServerSupportedOperations operation, Configuration parameters) throws InterruptedException {
        String message = null;
        switch (operation) {
            case RESTART: {
                message = this.restart();
                break;
            }
            case SHUTDOWN: {
                message = this.shutdown();
                break;
            }
            case START: {
                message = this.start();
            }
        }
        OperationResult result = new OperationResult(message);
        return result;
    }

    private String start() throws InterruptedException {
        AvailabilityType avail;
        ProcessExecution processExecution;
        File startScriptFile = this.getStartScriptPath();
        this.validateScriptFile(startScriptFile, "startScript");
        String prefix = this.pluginConfig.getSimple("scriptPrefix").getStringValue();
        String configName = this.getConfigurationSet();
        String bindAddress = this.pluginConfig.getSimpleValue("bindAddress", null);
        if (prefix == null || prefix.replaceAll("\\s", "").equals("")) {
            processExecution = ProcessExecutionUtility.createProcessExecution((File)startScriptFile);
            processExecution.getArguments().add("-c");
            processExecution.getArguments().add(configName);
            if (bindAddress != null) {
                processExecution.getArguments().add("-b");
                processExecution.getArguments().add(bindAddress);
            }
        } else {
            StringTokenizer prefixTokenizer = new StringTokenizer(prefix);
            String processName = prefixTokenizer.nextToken();
            File prefixProcess = new File(processName);
            processExecution = ProcessExecutionUtility.createProcessExecution((File)prefixProcess);
            while (prefixTokenizer.hasMoreTokens()) {
                String prefixArgument = prefixTokenizer.nextToken();
                processExecution.getArguments().add(prefixArgument);
            }
            String startScriptArgument = startScriptFile.getAbsolutePath();
            startScriptArgument = startScriptArgument + " -c " + configName;
            if (bindAddress != null) {
                startScriptArgument = startScriptArgument + " -b " + bindAddress;
            }
            processExecution.getArguments().add(startScriptArgument);
        }
        this.initProcessExecution(processExecution, startScriptFile);
        long start = System.currentTimeMillis();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("About to execute the following process: [" + processExecution + "]"));
        }
        ProcessExecutionResults results = this.systemInfo.executeProcess(processExecution);
        this.logExecutionResults(results);
        if (results.getError() == null) {
            avail = this.waitForServerToStart(start);
        } else {
            this.log.error((Object)("Error from process execution while starting the AS instance. Exit code [" + results.getExitCode() + "]"), results.getError());
            avail = this.serverComponent.getAvailability();
        }
        if (avail == AvailabilityType.DOWN) {
            throw new RuntimeException("Server failed to start: " + results.getCapturedOutput());
        }
        return "Server has been started.";
    }

    private String getConfigurationSet() {
        this.configPath = this.resolvePathRelativeToHomeDir(this.getRequiredPropertyValue(this.pluginConfig, "serverHomeDir"));
        if (!this.configPath.exists()) {
            throw new InvalidPluginConfigurationException("Configuration path '" + this.configPath + "' does not exist.");
        }
        return this.pluginConfig.getSimpleValue("serverName", this.configPath.getName());
    }

    private void initProcessExecution(ProcessExecution processExecution, File scriptFile) {
        processExecution.setWorkingDirectory(scriptFile.getParent());
        File javaHomeDir = this.getJavaHomePath();
        if (javaHomeDir == null) {
            throw new IllegalStateException("The 'javaHome' connection property must be set in order to start or stop the application server via script.");
        }
        this.validateJavaHomePathProperty();
        processExecution.getEnvironmentVariables().put("JAVA_HOME", javaHomeDir.getPath());
        processExecution.setCaptureOutput(true);
        processExecution.setWaitForCompletion(1000L);
        processExecution.setKillOnTimeout(false);
    }

    private String shutdown() {
        ApplicationServerShutdownMethod shutdownMethod = Enum.valueOf(ApplicationServerShutdownMethod.class, this.pluginConfig.getSimple("shutdownMethod").getStringValue());
        String result = ApplicationServerShutdownMethod.JMX.equals((Object)shutdownMethod) ? this.shutdownViaJmx() : this.shutdownViaScript();
        AvailabilityType avail = this.waitForServerToShutdown();
        if (avail == AvailabilityType.UP) {
            throw new RuntimeException("Server failed to shutdown");
        }
        return result;
    }

    private String shutdownViaScript() {
        String password;
        String user;
        File shutdownScriptFile = this.getShutdownScriptPath();
        this.validateScriptFile(shutdownScriptFile, "shutdownScript");
        String prefix = this.pluginConfig.getSimple("scriptPrefix").getStringValue();
        ProcessExecution processExecution = ProcessExecutionUtility.createProcessExecution((String)prefix, (File)shutdownScriptFile);
        this.initProcessExecution(processExecution, shutdownScriptFile);
        String server = this.pluginConfig.getSimple("namingURL").getStringValue();
        if (server != null) {
            processExecution.getArguments().add("--server=" + server);
        }
        if ((user = this.pluginConfig.getSimple("principal").getStringValue()) != null) {
            processExecution.getArguments().add("--user=" + user);
        }
        if ((password = this.pluginConfig.getSimple("credentials").getStringValue()) != null) {
            processExecution.getArguments().add("--password=" + password);
        }
        processExecution.getArguments().add("--shutdown");
        processExecution.getEnvironmentVariables().put("NOPAUSE", "1");
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("About to execute the following process: [" + processExecution + "]"));
        }
        ProcessExecutionResults results = this.systemInfo.executeProcess(processExecution);
        this.logExecutionResults(results);
        if (results.getError() != null) {
            throw new RuntimeException("Error executing shutdown script while stopping AS instance. Exit code [" + results.getExitCode() + "]", results.getError());
        }
        return "Server has been shut down.";
    }

    private void logExecutionResults(ProcessExecutionResults results) {
        this.log.info((Object)("Exit code from process execution: " + results.getExitCode()));
        this.log.info((Object)("Output from process execution: \n-----------------------\n" + results.getCapturedOutput() + SEPARATOR));
    }

    private String shutdownViaJmx() {
        String mbeanName = this.pluginConfig.getSimple("shutdownMBeanName").getStringValue();
        String operationName = this.pluginConfig.getSimple("shutdownMBeanOperation").getStringValue();
        EmsConnection connection = this.serverComponent.getEmsConnection();
        if (connection == null) {
            throw new RuntimeException("Can not connect to the server");
        }
        EmsBean bean = connection.getBean(mbeanName);
        EmsOperation operation = bean.getOperation(operationName);
        List params = operation.getParameters();
        int count = params.size();
        if (count == 0) {
            operation.invoke(new Object[0]);
        } else {
            operation.invoke(new Object[]{0});
        }
        return "Server has been shut down.";
    }

    private void validateScriptFile(File scriptFile, String scriptPropertyName) {
        if (!scriptFile.exists()) {
            throw new RuntimeException("Script (" + scriptFile + ") specified via '" + scriptPropertyName + "' connection property does not exist.");
        }
        if (scriptFile.isDirectory()) {
            throw new RuntimeException("Script (" + scriptFile + ") specified via '" + scriptPropertyName + "' connection property is a directory, not a file.");
        }
    }

    private String restart() {
        try {
            this.shutdown();
        }
        catch (Exception e) {
            throw new RuntimeException("Shutdown may have failed: " + e);
        }
        try {
            this.start();
        }
        catch (Exception e) {
            throw new RuntimeException("Re-Startup may have failed: " + e);
        }
        return "Server has been restarted.";
    }

    private AvailabilityType waitForServerToStart(long start) throws InterruptedException {
        AvailabilityType avail;
        while ((avail = this.getAvailability()) == AvailabilityType.DOWN && System.currentTimeMillis() < start + 300000L) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {}
        }
        return avail;
    }

    private AvailabilityType waitForServerToShutdown() {
        for (long wait = 0L; wait < 150000L && AvailabilityType.UP == this.getAvailability(); wait += 10000L) {
            try {
                Thread.sleep(10000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        try {
            Thread.sleep(30000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.getAvailability();
    }

    @NotNull
    public File getStartScriptPath() {
        Configuration pluginConfig = this.serverComponent.getResourceContext().getPluginConfiguration();
        String startScript = pluginConfig.getSimpleValue("startScript", DEFAULT_START_SCRIPT);
        File startScriptFile = this.resolvePathRelativeToHomeDir(startScript);
        return startScriptFile;
    }

    @NotNull
    private File resolvePathRelativeToHomeDir(@NotNull String path) {
        return this.resolvePathRelativeToHomeDir(this.serverComponent.getResourceContext().getPluginConfiguration(), path);
    }

    @NotNull
    private File resolvePathRelativeToHomeDir(Configuration pluginConfig, @NotNull String path) {
        File configDir = new File(path);
        if (!configDir.isAbsolute()) {
            String jbossHomeDir = this.getRequiredPropertyValue(pluginConfig, "homeDir");
            configDir = new File(jbossHomeDir, path);
        }
        return configDir;
    }

    @NotNull
    private String getRequiredPropertyValue(@NotNull Configuration config, @NotNull String propName) {
        String propValue = config.getSimpleValue(propName, null);
        if (propValue == null) {
            throw new IllegalStateException("Required property '" + propName + "' is not set.");
        }
        return propValue;
    }

    @NotNull
    public File getShutdownScriptPath() {
        Configuration pluginConfig = this.serverComponent.getResourceContext().getPluginConfiguration();
        String shutdownScript = pluginConfig.getSimpleValue("shutdownScript", DEFAULT_SHUTDOWN_SCRIPT);
        File shutdownScriptFile = this.resolvePathRelativeToHomeDir(shutdownScript);
        return shutdownScriptFile;
    }

    @Nullable
    public File getJavaHomePath() {
        Configuration pluginConfig = this.serverComponent.getResourceContext().getPluginConfiguration();
        String javaHomePath = pluginConfig.getSimpleValue("javaHome", null);
        if (javaHomePath == null) {
            this.log.warn((Object)"The 'JAVA_HOME' System property is not set - unable to set default value for the 'JAVA_HOME' connection property.");
        }
        File javaHome = javaHomePath != null ? new File(javaHomePath) : null;
        return javaHome;
    }

    void validateJavaHomePathProperty() {
        String javaHome = this.pluginConfig.getSimple("javaHome").getStringValue();
        if (javaHome != null) {
            File javaHomeDir = new File(javaHome);
            if (!javaHomeDir.isAbsolute()) {
                throw new InvalidPluginConfigurationException("javaHome connection property ('" + javaHomeDir + "') is not an absolute path. Note, on Windows, absolute paths must start with the drive letter (e.g. C:).");
            }
            if (!javaHomeDir.exists()) {
                throw new InvalidPluginConfigurationException("javaHome connection property ('" + javaHomeDir + "') does not exist.");
            }
            if (!javaHomeDir.isDirectory()) {
                throw new InvalidPluginConfigurationException("javaHome connection property ('" + javaHomeDir + "') is not a directory.");
            }
        }
    }

    public AvailabilityType getAvailability() {
        try {
            EmsConnection connection = this.serverComponent.getEmsConnection();
            EmsBean bean = connection.getBean("jboss.system:type=ServerConfig");
            File serverHomeViaJNP = (File)bean.getAttribute("ServerHomeDir").refresh();
            if (this.configPath == null) {
                this.getConfigurationSet();
            }
            if (this.configPath.getCanonicalPath().equals(serverHomeViaJNP.getCanonicalPath())) {
                return AvailabilityType.UP;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Availability check for JBAS resource with configPath [" + this.configPath + "] is trying to connect to a different running JBAS which is installed at [" + serverHomeViaJNP + "]. Returning AvailabilityType.DOWN for the former resource."));
            }
            return AvailabilityType.DOWN;
        }
        catch (Exception e) {
            return AvailabilityType.DOWN;
        }
    }
}

