/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5.serviceBinding;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.values.CollectionValue;
import org.jboss.metatype.api.values.CollectionValueSupport;
import org.jboss.metatype.api.values.CompositeValue;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValue;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.DeleteResourceFacet;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.plugins.jbossas5.serviceBinding.ManagerComponent;
import org.rhq.plugins.jbossas5.serviceBinding.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetComponent
implements ResourceComponent<ManagerComponent>,
ConfigurationFacet,
DeleteResourceFacet,
OperationFacet,
MeasurementFacet {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String BINDING_PROPERTY = "binding";
    private static final String RESULTING_BINDINGS_PROPERTY = "resultingBindings";
    private static final String DISPLAY_BINDINGS_OPERATION_NAME = "displayBindings";
    private ResourceContext<ManagerComponent> context;

    public Configuration loadResourceConfiguration() throws Exception {
        Configuration configuration = new Configuration();
        CompositeValue bindingSet = this.getBindingSet();
        if (bindingSet == null) {
            throw new IllegalStateException("Could not find a binding set called " + this.context.getResourceKey());
        }
        for (PropertySimple prop : Util.getProperties(Arrays.asList(Util.BINDING_SET_SIMPLE_PROPERTIES), bindingSet)) {
            configuration.put((Property)prop);
        }
        CollectionValue overrideBindings = (CollectionValue)bindingSet.get("overrideBindings");
        PropertyList overrideBindingsList = new PropertyList("overrideBindings");
        configuration.put((Property)overrideBindingsList);
        for (MetaValue m : overrideBindings.getElements()) {
            CompositeValue binding = (CompositeValue)m;
            PropertyMap bindingMap = new PropertyMap(BINDING_PROPERTY);
            overrideBindingsList.add((Property)bindingMap);
            for (PropertySimple prop : Util.getProperties(Arrays.asList(Util.BINDING_SET_OVERRIDE_PROPERTIES), binding)) {
                bindingMap.put((Property)prop);
            }
        }
        return configuration;
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        try {
            Configuration updatedConfiguration = report.getConfiguration();
            MetaType bindingSetValueMetaType = ((ManagerComponent)this.context.getParentResourceComponent()).getBindingSetValueMetaType();
            CompositeValue currentBindingSet = Util.getBindingSetFromConfiguration(bindingSetValueMetaType, updatedConfiguration);
            ManagerComponent managerResourceComponent = (ManagerComponent)this.context.getParentResourceComponent();
            ManagedComponent bindingManagerComponent = managerResourceComponent.getBindingManager();
            ManagedProperty bindingSetsProperty = bindingManagerComponent.getProperty("bindingSets");
            String thisBindingSetName = managerResourceComponent.getBindingSetNameFromResourceKey(this.context.getResourceKey());
            CollectionValue bindingSets = (CollectionValue)bindingSetsProperty.getValue();
            List<MetaValue> newBindingSets = Util.replaceWithNew(bindingSets, thisBindingSetName, (MetaValue)currentBindingSet);
            CollectionValueSupport newBindingSetsValue = new CollectionValueSupport(bindingSets.getMetaType());
            newBindingSetsValue.setElements(newBindingSets.toArray(new MetaValue[newBindingSets.size()]));
            bindingSetsProperty.setValue((MetaValue)newBindingSetsValue);
            ((ManagerComponent)this.context.getParentResourceComponent()).updateBindingManager(bindingManagerComponent);
            report.setStatus(ConfigurationUpdateStatus.SUCCESS);
        }
        catch (Exception e) {
            this.log.warn((Object)"Failed to update service binding set", (Throwable)e);
            report.setErrorMessageFromThrowable((Throwable)e);
            report.setStatus(ConfigurationUpdateStatus.FAILURE);
            return;
        }
    }

    public AvailabilityType getAvailability() {
        return this.getBindingSet() != null ? AvailabilityType.UP : AvailabilityType.DOWN;
    }

    public void start(ResourceContext<ManagerComponent> context) {
        this.context = context;
    }

    public void stop() {
    }

    public void deleteResource() throws Exception {
        ManagedComponent bindingManagerComponent;
        String activeBindingSetName;
        String thisBindingSetName = ((ManagerComponent)this.context.getParentResourceComponent()).getBindingSetNameFromResourceKey(this.context.getResourceKey());
        if (thisBindingSetName.equals(activeBindingSetName = Util.getValue((SimpleValue)(bindingManagerComponent = ((ManagerComponent)this.context.getParentResourceComponent()).getBindingManager()).getProperty("activeBindingSetName").getValue(), String.class))) {
            throw new IllegalStateException("Cannot delete currently active binding set.");
        }
        ManagedProperty bindingSetsProperty = bindingManagerComponent.getProperty("bindingSets");
        CollectionValue bindingSets = (CollectionValue)bindingSetsProperty.getValue();
        List<MetaValue> newBindingSets = Util.replaceWithNew(bindingSets, thisBindingSetName, null);
        CollectionValueSupport newBindingSetsValue = new CollectionValueSupport(bindingSets.getMetaType());
        newBindingSetsValue.setElements(newBindingSets.toArray(new MetaValue[newBindingSets.size()]));
        bindingSetsProperty.setValue((MetaValue)newBindingSetsValue);
        ((ManagerComponent)this.context.getParentResourceComponent()).updateBindingManager(bindingManagerComponent);
    }

    public OperationResult invokeOperation(String name, Configuration parameters) throws InterruptedException, Exception {
        if (!DISPLAY_BINDINGS_OPERATION_NAME.equals(name)) {
            return null;
        }
        OperationResult result = new OperationResult();
        Configuration currentConfiguration = this.loadResourceConfiguration();
        Configuration bindingManagerConfiguration = ((ManagerComponent)this.context.getParentResourceComponent()).loadResourceConfiguration();
        Configuration bindings = result.getComplexResults();
        PropertyList resultingBindings = new PropertyList(RESULTING_BINDINGS_PROPERTY);
        bindings.put((Property)resultingBindings);
        int portOffset = currentConfiguration.getSimple("portOffset").getIntegerValue();
        String defaultHostName = currentConfiguration.getSimple("defaultHostName").getStringValue();
        Map<String, PropertyMap> overridesMap = this.buildOverridesMap(currentConfiguration.getList("overrideBindings"));
        for (Property p : bindingManagerConfiguration.getList("standardBindings").getList()) {
            PropertyMap standardBinding = (PropertyMap)p;
            PropertyMap bindingMap = new PropertyMap(BINDING_PROPERTY);
            resultingBindings.add((Property)bindingMap);
            for (Util.PropertyDefinition def : Util.BINDING_SET_OVERRIDE_PROPERTIES) {
                Property equivalent = standardBinding.get(def.propertyName);
                if (equivalent == null) continue;
                bindingMap.put(equivalent);
            }
            boolean fixedPort = standardBinding.getSimple("fixedPort").getBooleanValue();
            boolean fixedHostName = standardBinding.getSimple("fixedHostName").getBooleanValue();
            int standardPort = standardBinding.getSimple("port").getIntegerValue();
            String standardHostName = standardBinding.getSimple("hostName").getStringValue();
            PropertySimple resultingPort = bindingMap.getSimple("port");
            PropertySimple resultingHostName = bindingMap.getSimple("hostName");
            int portToSet = fixedPort ? standardPort : standardPort + portOffset;
            String hostNameToSet = fixedHostName ? standardHostName : defaultHostName;
            String fullyQualifiedName = standardBinding.getSimpleValue("fullyQualifiedName", null);
            PropertyMap override = overridesMap.get(fullyQualifiedName);
            if (override != null) {
                overridesMap.remove(fullyQualifiedName);
                portToSet = fixedPort ? portToSet : override.getSimple("port").getIntegerValue();
                String overrideHostName = override.getSimpleValue("hostName", null);
                overrideHostName = overrideHostName == null ? defaultHostName : overrideHostName;
                hostNameToSet = fixedHostName ? hostNameToSet : overrideHostName;
            }
            resultingPort.setIntegerValue(Integer.valueOf(portToSet));
            resultingHostName.setStringValue(hostNameToSet);
        }
        for (PropertyMap override : overridesMap.values()) {
            resultingBindings.add((Property)override);
        }
        return result;
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        Configuration config = this.loadResourceConfiguration();
        for (MeasurementScheduleRequest request : metrics) {
            String requestName = request.getName();
            if (!requestName.equals("name") && !requestName.equals("defaultHostName") && !requestName.equals("portOffset")) continue;
            String value = config.getSimpleValue(requestName, null);
            report.addData(new MeasurementDataTrait(request, value));
        }
    }

    private CompositeValue getBindingSet() {
        String bindingSetName = ((ManagerComponent)this.context.getParentResourceComponent()).getBindingSetNameFromResourceKey(this.context.getResourceKey());
        ManagedComponent bindingManagerComponent = ((ManagerComponent)this.context.getParentResourceComponent()).getBindingManager();
        CollectionValue bindingSets = (CollectionValue)bindingManagerComponent.getProperty("bindingSets").getValue();
        for (CompositeValue bindingSet : bindingSets) {
            String currentName = Util.getValue(bindingSet, "name", String.class);
            if (!bindingSetName.equals(currentName)) continue;
            return bindingSet;
        }
        return null;
    }

    private Map<String, PropertyMap> buildOverridesMap(PropertyList overrides) {
        TreeMap<String, PropertyMap> ret = new TreeMap<String, PropertyMap>();
        for (Property p : overrides.getList()) {
            PropertyMap overrideMap = (PropertyMap)p;
            ret.put(overrideMap.getSimpleValue("fullyQualifiedName", null), overrideMap);
        }
        return ret;
    }
}

