/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.managed.api.ManagedOperation;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.metatype.api.values.CompositeValue;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValue;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.measurement.calltime.CallTimeData;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.plugins.jbossas5.ManagedComponentComponent;

public abstract class AbstractEjbBeanComponent
extends ManagedComponentComponent
implements OperationFacet {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String VIEW_INVOCATION_STATS_OPERATION_NAME = "viewInvocationStats";

    @Override
    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) throws Exception {
        LinkedHashSet<MeasurementScheduleRequest> remainingRequests = new LinkedHashSet<MeasurementScheduleRequest>();
        for (MeasurementScheduleRequest request : requests) {
            String metricName = request.getName();
            try {
                if (metricName.equals("methodInvocationTime")) {
                    InvocationStats invocationStats = this.getInvocationStats();
                    if (invocationStats.methodStats.isEmpty()) continue;
                    CallTimeData callTimeData = this.createCallTimeData(request, invocationStats);
                    report.addData(callTimeData);
                    this.resetInvocationStats();
                    continue;
                }
                remainingRequests.add(request);
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to collect metric '" + metricName + "' for " + this.getResourceDescription() + "."), (Throwable)e);
            }
        }
        super.getValues(report, remainingRequests);
    }

    @Override
    public OperationResult invokeOperation(String name, Configuration parameters) throws Exception {
        OperationResult result;
        if (VIEW_INVOCATION_STATS_OPERATION_NAME.equals(name)) {
            result = new OperationResult();
            PropertyList methodList = new PropertyList("methods");
            result.getComplexResults().put((Property)methodList);
            List<MethodStats> allMethodStats = this.getInvocationStats().methodStats;
            for (MethodStats methodStats : allMethodStats) {
                PropertyMap method = new PropertyMap("method", new Property[]{new PropertySimple("methodName", (Object)methodStats.name), new PropertySimple("count", (Object)methodStats.count), new PropertySimple("minTime", (Object)methodStats.minTime), new PropertySimple("maxTime", (Object)methodStats.maxTime), new PropertySimple("totalTime", (Object)methodStats.totalTime)});
                methodList.add((Property)method);
            }
        } else {
            result = super.invokeOperation(name, parameters);
        }
        return result;
    }

    private InvocationStats getInvocationStats() {
        InvocationStats invocationStats = new InvocationStats();
        ArrayList<MethodStats> allMethodStats = new ArrayList<MethodStats>();
        Configuration pluginConfig = this.getResourceContext().getPluginConfiguration();
        String propName = pluginConfig.getSimple("invocationStatsPropertyName").getStringValue();
        ManagedProperty detypedInvokedStatsProp = this.getManagedComponent().getProperty(propName);
        invocationStats.endTime = System.currentTimeMillis();
        CompositeValue detypedInvokeStatsMetaValue = (CompositeValue)detypedInvokedStatsProp.getValue();
        CompositeValue allMethodStatsMetaValue = (CompositeValue)detypedInvokeStatsMetaValue.get("methodStats");
        Set methodNames = allMethodStatsMetaValue.getMetaType().keySet();
        for (String methodName : methodNames) {
            CompositeValue methodStatsMetaValue = (CompositeValue)allMethodStatsMetaValue.get(methodName);
            MethodStats methodStats = new MethodStats();
            methodStats.name = methodName;
            methodStats.count = Long.parseLong(((SimpleValue)methodStatsMetaValue.get("count")).getValue().toString());
            methodStats.totalTime = Long.parseLong(((SimpleValue)methodStatsMetaValue.get("totalTime")).getValue().toString());
            methodStats.minTime = Long.parseLong(((SimpleValue)methodStatsMetaValue.get("minTime")).getValue().toString());
            methodStats.maxTime = Long.parseLong(((SimpleValue)methodStatsMetaValue.get("maxTime")).getValue().toString());
            allMethodStats.add(methodStats);
        }
        invocationStats.methodStats = allMethodStats;
        SimpleValue lastResetTimeMetaValue = (SimpleValue)((CompositeValue)detypedInvokedStatsProp.getValue()).get("lastResetTime");
        invocationStats.beginTime = Long.valueOf(lastResetTimeMetaValue.getValue().toString());
        return invocationStats;
    }

    private CallTimeData createCallTimeData(MeasurementScheduleRequest schedule, InvocationStats invocationStats) throws Exception {
        CallTimeData callTimeData = new CallTimeData(schedule);
        Date beginDate = new Date(invocationStats.beginTime);
        Date endDate = new Date(invocationStats.endTime);
        for (MethodStats methodStats : invocationStats.methodStats) {
            try {
                callTimeData.addAggregatedCallData(methodStats.name, beginDate, endDate, (double)methodStats.minTime, (double)methodStats.maxTime, (double)methodStats.totalTime, methodStats.count);
            }
            catch (IllegalArgumentException iae) {
                this.log.error((Object)iae);
            }
        }
        return callTimeData;
    }

    private void resetInvocationStats() {
        Set operations = this.getManagedComponent().getOperations();
        for (ManagedOperation operation : operations) {
            if (!operation.getName().equals("resetInvocationStats")) continue;
            operation.invoke(new MetaValue[0]);
            break;
        }
    }

    class MethodStats {
        String name;
        long count;
        long minTime;
        long maxTime;
        long totalTime;

        MethodStats() {
        }
    }

    class InvocationStats {
        List<MethodStats> methodStats;
        long beginTime;
        long endTime;

        InvocationStats() {
        }
    }
}

