/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5;

import com.jboss.jbossnetwork.product.jbpm.handlers.ControlActionFacade;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.deployers.spi.management.deploy.ProgressEvent;
import org.jboss.deployers.spi.management.deploy.ProgressListener;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.metatype.api.values.SimpleValue;
import org.jboss.on.common.jbossas.JBPMWorkflowManager;
import org.jboss.on.common.jbossas.JBossASPaths;
import org.jboss.on.common.jbossas.JmxConnectionHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.support.metadata.InternalVMTypeDescriptor;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.transfer.DeployPackageStep;
import org.rhq.core.domain.content.transfer.DeployPackagesResponse;
import org.rhq.core.domain.content.transfer.RemovePackagesResponse;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.availability.AvailabilityCollectorRunnable;
import org.rhq.core.pluginapi.availability.AvailabilityFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.content.ContentContext;
import org.rhq.core.pluginapi.content.ContentFacet;
import org.rhq.core.pluginapi.content.ContentServices;
import org.rhq.core.pluginapi.event.log.LogFileEventResourceComponentHelper;
import org.rhq.core.pluginapi.inventory.CreateChildResourceFacet;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.plugins.jbossas5.ApplicationServerContentFacetDelegate;
import org.rhq.plugins.jbossas5.ApplicationServerOperationsDelegate;
import org.rhq.plugins.jbossas5.ApplicationServerSupportedOperations;
import org.rhq.plugins.jbossas5.ProfileServiceComponent;
import org.rhq.plugins.jbossas5.connection.AbstractProfileServiceConnectionProvider;
import org.rhq.plugins.jbossas5.connection.LocalProfileServiceConnectionProvider;
import org.rhq.plugins.jbossas5.connection.ProfileServiceConnection;
import org.rhq.plugins.jbossas5.connection.RemoteProfileServiceConnectionProvider;
import org.rhq.plugins.jbossas5.helper.CreateChildResourceFacetDelegate;
import org.rhq.plugins.jbossas5.helper.InPluginControlActionFacade;
import org.rhq.plugins.jbossas5.helper.JBossAS5ConnectionTypeDescriptor;
import org.rhq.plugins.jbossas5.util.ManagedComponentUtils;

public class ApplicationServerComponent
implements ResourceComponent,
ProfileServiceComponent,
CreateChildResourceFacet,
MeasurementFacet,
ConfigurationFacet,
ProgressListener,
ContentFacet,
OperationFacet {
    private static final Pattern METRIC_NAME_PATTERN = Pattern.compile("(.*)\\|(.*)\\|(.*)\\|(.*)");
    private static final Map<String, String> ALTERNATE_METRIC_NAMES = new HashMap<String, String>();
    private static final Map<String, String> VERIFIED_METRIC_NAMES;
    private final Log log = LogFactory.getLog(this.getClass());
    private ResourceContext resourceContext;
    private ProfileServiceConnection connection;
    private JmxConnectionHelper jmxConnectionHelper;
    private ApplicationServerContentFacetDelegate contentFacetDelegate;
    private ApplicationServerOperationsDelegate operationDelegate;
    private LogFileEventResourceComponentHelper logFileEventDelegate;
    private CreateChildResourceFacetDelegate createChildResourceDelegate;
    private AvailabilityCollectorRunnable availCollector;

    public AvailabilityType getAvailability() {
        if (this.availCollector != null) {
            return this.availCollector.getLastKnownAvailability();
        }
        return this.getAvailabilityNow();
    }

    private AvailabilityType getAvailabilityNow() {
        AvailabilityType availability;
        this.connectToProfileService();
        if (this.connection != null) {
            try {
                ManagementView managementView = this.connection.getManagementView();
                managementView.load();
                ManagedComponent serverConfig = (ManagedComponent)managementView.getComponentsForType(new ComponentType("MCBean", "ServerConfig")).iterator().next();
                String reportedServerHomeDirPath = (String)((Object)((SimpleValue)serverConfig.getProperty("serverHomeDir").getValue()).getValue());
                String configuredServerHomeDirPath = this.resourceContext.getPluginConfiguration().getSimpleValue("serverHomeDir", null);
                File reportedServerHomeDir = new File(reportedServerHomeDirPath);
                File configuredServerHomeDir = new File(configuredServerHomeDirPath);
                availability = reportedServerHomeDir.getCanonicalPath().equals(configuredServerHomeDir.getCanonicalPath()) ? AvailabilityType.UP : AvailabilityType.DOWN;
            }
            catch (Exception e) {
                availability = AvailabilityType.DOWN;
            }
        } else {
            availability = AvailabilityType.DOWN;
        }
        return availability;
    }

    public void start(ResourceContext resourceContext) {
        this.resourceContext = resourceContext;
        this.operationDelegate = new ApplicationServerOperationsDelegate(this);
        this.connectToProfileService();
        this.initializeEmsConnection();
        this.logFileEventDelegate = new LogFileEventResourceComponentHelper(this.resourceContext);
        this.logFileEventDelegate.startLogFileEventPollers();
        JBPMWorkflowManager workflowManager = this.createJbpmWorkflowManager(resourceContext);
        File configPath = this.getConfigurationPath();
        this.contentFacetDelegate = new ApplicationServerContentFacetDelegate(workflowManager, configPath, resourceContext.getContentContext());
        this.createChildResourceDelegate = new CreateChildResourceFacetDelegate(this);
        Configuration pc = resourceContext.getPluginConfiguration();
        String availCheckPeriodProp = pc.getSimpleValue("availabilityCheckPeriod", null);
        if (availCheckPeriodProp != null) {
            try {
                long availCheckMillis = (long)Integer.parseInt(availCheckPeriodProp) * 1000L;
                this.availCollector = resourceContext.createAvailabilityCollectorRunnable(new AvailabilityFacet(){

                    public AvailabilityType getAvailability() {
                        return ApplicationServerComponent.this.getAvailabilityNow();
                    }
                }, availCheckMillis);
                this.availCollector.start();
            }
            catch (NumberFormatException nfe) {
                this.log.error((Object)("avail check period config prop was not a valid number. Cause: " + nfe));
                this.availCollector = null;
            }
        }
    }

    public void stop() {
        if (this.availCollector != null) {
            this.availCollector.stop();
            this.availCollector = null;
        }
        this.logFileEventDelegate.stopLogFileEventPollers();
        this.disconnectFromProfileService();
        this.jmxConnectionHelper.closeConnection();
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) {
        ManagementView managementView = this.getConnection().getManagementView();
        for (MeasurementScheduleRequest request : requests) {
            String requestName = request.getName();
            String verifiedMetricName = VERIFIED_METRIC_NAMES.get(requestName);
            String metricName = verifiedMetricName != null ? verifiedMetricName : requestName;
            try {
                Serializable value = null;
                boolean foundProperty = false;
                try {
                    value = ApplicationServerComponent.getMetric(managementView, metricName);
                    foundProperty = true;
                }
                catch (ManagedComponentUtils.PropertyNotFoundException e) {
                    // empty catch block
                }
                if (value == null && (metricName = ALTERNATE_METRIC_NAMES.get(metricName)) != null) {
                    try {
                        value = ApplicationServerComponent.getMetric(managementView, metricName);
                        foundProperty = true;
                    }
                    catch (ManagedComponentUtils.PropertyNotFoundException e) {
                        // empty catch block
                    }
                }
                if (!foundProperty) {
                    ArrayList<String> propertyNames = new ArrayList<String>(2);
                    propertyNames.add(requestName);
                    if (ALTERNATE_METRIC_NAMES.containsKey(requestName)) {
                        propertyNames.add(ALTERNATE_METRIC_NAMES.get(requestName));
                    }
                    throw new IllegalStateException("A property was not found with any of the following names: " + propertyNames);
                }
                if (value == null) {
                    this.log.debug((Object)("Null value returned for metric '" + metricName + "'."));
                    continue;
                }
                VERIFIED_METRIC_NAMES.put(requestName, metricName);
                if (request.getDataType() == DataType.MEASUREMENT) {
                    Number number = (Number)value;
                    report.addData(new MeasurementDataNumeric(request, Double.valueOf(number.doubleValue())));
                    continue;
                }
                if (request.getDataType() != DataType.TRAIT) continue;
                report.addData(new MeasurementDataTrait(request, value.toString()));
            }
            catch (RuntimeException e) {
                this.log.error((Object)("Failed to obtain metric '" + requestName + "'."), (Throwable)e);
            }
        }
    }

    public Configuration loadResourceConfiguration() {
        return null;
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport configurationUpdateReport) {
    }

    public CreateResourceReport createResource(CreateResourceReport createResourceReport) {
        return this.createChildResourceDelegate.createResource(createResourceReport);
    }

    public void progressEvent(ProgressEvent eventInfo) {
        this.log.debug((Object)eventInfo);
    }

    @Override
    @Nullable
    public ProfileServiceConnection getConnection() {
        this.connectToProfileService();
        return this.connection;
    }

    public DeployPackagesResponse deployPackages(Set<ResourcePackageDetails> packages, ContentServices contentServices) {
        return this.contentFacetDelegate.deployPackages(packages, contentServices);
    }

    public Set<ResourcePackageDetails> discoverDeployedPackages(PackageType type) {
        return this.contentFacetDelegate.discoverDeployedPackages(type);
    }

    public List<DeployPackageStep> generateInstallationSteps(ResourcePackageDetails packageDetails) {
        return this.contentFacetDelegate.generateInstallationSteps(packageDetails);
    }

    public RemovePackagesResponse removePackages(Set<ResourcePackageDetails> packages) {
        return this.contentFacetDelegate.removePackages(packages);
    }

    public InputStream retrievePackageBits(ResourcePackageDetails packageDetails) {
        return this.contentFacetDelegate.retrievePackageBits(packageDetails);
    }

    private void connectToProfileService() {
        AbstractProfileServiceConnectionProvider connectionProvider;
        if (this.connection != null) {
            return;
        }
        if (this.runningEmbedded()) {
            connectionProvider = new LocalProfileServiceConnectionProvider();
        } else {
            Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
            String namingURL = pluginConfig.getSimpleValue("namingURL", null);
            ApplicationServerComponent.validateNamingURL(namingURL);
            String principal = pluginConfig.getSimpleValue("principal", null);
            String credentials = pluginConfig.getSimpleValue("credentials", null);
            connectionProvider = new RemoteProfileServiceConnectionProvider(namingURL, principal, credentials);
        }
        if (Thread.interrupted()) {
            this.log.debug((Object)"Ignoring facet timeout in order to reconnect to Profile Service.");
        }
        try {
            this.connection = connectionProvider.connect();
        }
        catch (RuntimeException e) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause instanceof SecurityException) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Failed to connect to Profile Service.", (Throwable)e);
                } else {
                    this.log.warn((Object)("Failed to connect to Profile Service - cause: " + rootCause));
                }
                throw new InvalidPluginConfigurationException("Values of 'principal' and/or 'credentials' connection properties are invalid.", rootCause);
            }
            this.log.debug((Object)"Failed to connect to Profile Service.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectFromProfileService() {
        if (this.connection != null) {
            try {
                this.connection.getConnectionProvider().disconnect();
            }
            catch (RuntimeException e) {
                this.log.debug((Object)"Failed to disconnect from Profile Service.", (Throwable)e);
            }
            finally {
                this.connection = null;
            }
        }
    }

    @NotNull
    private JBossASPaths getJBossASPaths() {
        Configuration pluginConfiguration = this.resourceContext.getPluginConfiguration();
        String homeDir = pluginConfiguration.getSimpleValue("homeDir", null);
        String serverHomeDir = pluginConfiguration.getSimpleValue("serverHomeDir", null);
        return new JBossASPaths(homeDir, serverHomeDir);
    }

    private boolean runningEmbedded() {
        Configuration pluginConfiguration = this.resourceContext.getPluginConfiguration();
        String namingUrl = pluginConfiguration.getSimpleValue("namingURL", null);
        return namingUrl == null;
    }

    @NotNull
    private File resolvePathRelativeToHomeDir(@NotNull String path) {
        File configDir = new File(path);
        if (!configDir.isAbsolute()) {
            Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
            String homeDir = pluginConfig.getSimple("homeDir").getStringValue();
            configDir = new File(homeDir, path);
        }
        return configDir;
    }

    private static void validateNamingURL(String namingURL) {
        URI namingURI;
        try {
            namingURI = new URI(namingURL);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Naming URL '" + namingURL + "' is not valid: " + e.getLocalizedMessage());
        }
        if (!namingURI.isAbsolute()) {
            throw new RuntimeException("Naming URL '" + namingURL + "' is not absolute.");
        }
        if (!namingURI.getScheme().equals("jnp")) {
            throw new RuntimeException("Naming URL '" + namingURL + "' has an invalid protocol - the only valid protocol is 'jnp'.");
        }
    }

    public EmsConnection getEmsConnection() {
        return this.jmxConnectionHelper.getEmsConnection();
    }

    @NotNull
    private static String getRequiredPropertyValue(@NotNull Configuration config, @NotNull String propName) {
        String propValue = config.getSimpleValue(propName, null);
        if (propValue == null) {
            throw new IllegalStateException("Required property '" + propName + "' is not set.");
        }
        return propValue;
    }

    @NotNull
    public ResourceContext getResourceContext() {
        return this.resourceContext;
    }

    public OperationResult invokeOperation(String name, Configuration parameters) throws InterruptedException, Exception {
        ApplicationServerSupportedOperations operation = Enum.valueOf(ApplicationServerSupportedOperations.class, name.toUpperCase());
        return this.operationDelegate.invoke(operation, parameters);
    }

    private void initializeEmsConnection() {
        String connectorDescriptorType;
        Configuration pluginConfiguration = this.resourceContext.getPluginConfiguration();
        Configuration jmxConfig = new Configuration();
        String jbossHomeDir = pluginConfiguration.getSimpleValue("homeDir", null);
        boolean runningEmbedded = this.runningEmbedded();
        if (runningEmbedded) {
            connectorDescriptorType = InternalVMTypeDescriptor.class.getName();
        } else {
            String connectorAddress = pluginConfiguration.getSimpleValue("namingURL", null);
            String connectorPrincipal = pluginConfiguration.getSimpleValue("principal", null);
            String connectorCredentials = pluginConfiguration.getSimpleValue("credentials", null);
            connectorDescriptorType = JBossAS5ConnectionTypeDescriptor.class.getName();
            jmxConfig.put((Property)new PropertySimple("connectorAddress", (Object)connectorAddress));
            jmxConfig.put((Property)new PropertySimple("connectorCredentials", (Object)connectorCredentials));
            jmxConfig.put((Property)new PropertySimple("connectorPrincipal", (Object)connectorPrincipal));
        }
        jmxConfig.put((Property)new PropertySimple("connectorDescriptorType", (Object)connectorDescriptorType));
        jmxConfig.put((Property)new PropertySimple("jbossHomeDir", (Object)jbossHomeDir));
        this.jmxConnectionHelper = new JmxConnectionHelper(!runningEmbedded, this.resourceContext.getTemporaryDirectory());
        EmsConnection conn = this.jmxConnectionHelper.getEmsConnection(jmxConfig);
        if (conn != null) {
            this.log.info((Object)("Successfully obtained a JMX connection to " + jmxConfig.getSimpleValue("connectorAddress", "-n/a-")));
        }
    }

    private JBPMWorkflowManager createJbpmWorkflowManager(ResourceContext resourceContext) {
        ContentContext contentContext = resourceContext.getContentContext();
        ControlActionFacade controlActionFacade = this.initControlActionFacade();
        JBPMWorkflowManager workflowManager = new JBPMWorkflowManager(contentContext, controlActionFacade, this.getJBossASPaths());
        return workflowManager;
    }

    private ControlActionFacade initControlActionFacade() {
        return new InPluginControlActionFacade(this);
    }

    private File getConfigurationPath() {
        Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
        String serverHomeDir = ApplicationServerComponent.getRequiredPropertyValue(pluginConfig, "serverHomeDir");
        File configPath = this.resolvePathRelativeToHomeDir(serverHomeDir);
        if (!configPath.isDirectory()) {
            throw new InvalidPluginConfigurationException("Configuration path '" + configPath + "' does not exist.");
        }
        return configPath;
    }

    private static Serializable getMetric(ManagementView managementView, String metricName) throws ManagedComponentUtils.PropertyNotFoundException {
        ManagedComponent component;
        Matcher matcher = METRIC_NAME_PATTERN.matcher(metricName);
        if (!matcher.matches()) {
            throw new IllegalStateException("Metric name '" + metricName + "' does not match pattern '" + METRIC_NAME_PATTERN + "'.");
        }
        String componentCategory = matcher.group(1);
        String componentSubType = matcher.group(2);
        String componentName = matcher.group(3);
        String propertyName = matcher.group(4);
        ComponentType componentType = new ComponentType(componentCategory, componentSubType);
        if (componentName.equals("*")) {
            component = ManagedComponentUtils.getSingletonManagedComponent(managementView, componentType);
        } else {
            try {
                component = managementView.getComponent(componentName, componentType);
            }
            catch (Exception e) {
                throw new IllegalStateException("Error fetching component " + componentName + "of type " + componentType);
            }
        }
        return ManagedComponentUtils.getSimplePropertyValue(component, propertyName);
    }

    static {
        ALTERNATE_METRIC_NAMES.put("MCBean|JTA|*|transactionCount", "MCBean|JTA|*|numberOfTransactions");
        ALTERNATE_METRIC_NAMES.put("MCBean|JTA|*|commitCount", "MCBean|JTA|*|numberOfCommittedTransactions");
        ALTERNATE_METRIC_NAMES.put("MCBean|JTA|*|rollbackCount", "MCBean|JTA|*|numberOfApplicationRollbacks");
        ALTERNATE_METRIC_NAMES.put("MCBean|ServerConfig|*|partitionName", "MCBean|HAPartition|*|partitionName");
        VERIFIED_METRIC_NAMES = new HashMap<String, String>();
    }
}

