/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.ManagedComponent;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jbossas5.ProfileServiceComponent;
import org.rhq.plugins.jbossas5.util.ConversionUtils;

public class ManagedComponentDiscoveryComponent<P extends ProfileServiceComponent>
implements ResourceDiscoveryComponent<P> {
    private final Log log = LogFactory.getLog(this.getClass());

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<P> discoveryContext) throws Exception {
        Set components;
        ResourceType resourceType = discoveryContext.getResourceType();
        this.log.trace((Object)("Discovering " + resourceType.getName() + " Resources..."));
        ManagementView managementView = ((ProfileServiceComponent)discoveryContext.getParentResourceComponent()).getConnection().getManagementView();
        managementView.load();
        ComponentType componentType = this.getComponentType(discoveryContext);
        try {
            components = managementView.getComponentsForType(componentType);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to get component types for " + resourceType + ".", e);
        }
        if (resourceType.isSingleton() && components.size() > 1) {
            throw new IllegalStateException("Discovered multiple [" + componentType + "] managed components during [" + resourceType + "] discovery, but expected to find no more than one - components were: " + components);
        }
        HashSet<DiscoveredResourceDetails> discoveredResources = new HashSet<DiscoveredResourceDetails>(components.size());
        for (ManagedComponent component : components) {
            String resourceKey;
            if (!this.accept(discoveryContext, component)) continue;
            String resourceName = this.getResourceName(component);
            if (resourceName == null) {
                resourceName = component.getName();
            }
            if ((resourceKey = this.getResourceKey(component)) == null) {
                resourceKey = component.getName();
            }
            String version = this.getResourceVersion(component);
            DiscoveredResourceDetails resource = new DiscoveredResourceDetails(resourceType, resourceKey, resourceName, version, resourceType.getDescription(), discoveryContext.getDefaultPluginConfiguration(), null);
            resource.getPluginConfiguration().put((Property)new PropertySimple("componentName", (Object)resourceKey));
            discoveredResources.add(resource);
        }
        this.log.trace((Object)("Discovered " + discoveredResources.size() + " " + resourceType.getName() + " Resources."));
        return discoveredResources;
    }

    protected ComponentType getComponentType(ResourceDiscoveryContext<P> discoveryContext) {
        ResourceType resourceType = discoveryContext.getResourceType();
        return ConversionUtils.getComponentType(resourceType);
    }

    protected String getResourceName(ManagedComponent component) {
        return component.getName();
    }

    protected String getResourceKey(ManagedComponent component) {
        return component.getName();
    }

    protected String getResourceVersion(ManagedComponent component) {
        return null;
    }

    protected boolean accept(ResourceDiscoveryContext<P> discoveryContext, ManagedComponent component) {
        return true;
    }
}

