/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.deployers.spi.management.deploy.DeploymentManager;
import org.jboss.deployers.spi.management.deploy.DeploymentProgress;
import org.jboss.deployers.spi.management.deploy.DeploymentStatus;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.managed.api.ManagedOperation;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.RunState;
import org.jboss.metatype.api.values.ArrayValue;
import org.jboss.metatype.api.values.CollectionValue;
import org.jboss.metatype.api.values.CompositeValue;
import org.jboss.metatype.api.values.EnumValue;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.DeleteResourceFacet;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.plugins.jbossas5.AbstractManagedComponent;
import org.rhq.plugins.jbossas5.ApplicationServerComponent;
import org.rhq.plugins.jbossas5.ProfileServiceComponent;
import org.rhq.plugins.jbossas5.util.ConversionUtils;
import org.rhq.plugins.jbossas5.util.DebugUtils;
import org.rhq.plugins.jbossas5.util.DeploymentUtils;
import org.rhq.plugins.jbossas5.util.ResourceComponentUtils;
import org.rhq.plugins.jbossas5.util.ResourceTypeUtils;

public class ManagedComponentComponent
extends AbstractManagedComponent
implements ConfigurationFacet,
DeleteResourceFacet,
OperationFacet,
MeasurementFacet {
    private static final Log LOG = LogFactory.getLog(ManagedComponentComponent.class);
    protected static final char PREFIX_DELIMITER = '|';
    private static final long AVAIL_REFRESH_INTERVAL = 900000L;
    private long availRefreshInterval = 900000L;
    private volatile long lastComponentRefresh = 0L;
    private RunState runState;
    private String componentName;
    private ComponentType componentType;

    public AvailabilityType getAvailability() {
        boolean refresh;
        long timeSinceComponentRefresh = System.currentTimeMillis() - this.lastComponentRefresh;
        boolean bl = refresh = timeSinceComponentRefresh > this.availRefreshInterval;
        if (this.runState == null || refresh) {
            if (LOG.isDebugEnabled() && this.runState != null && this.lastComponentRefresh > 0L) {
                LOG.debug((Object)("The availability refresh interval for [resourceKey: " + this.getResourceContext().getResourceKey() + ", type: " + this.componentType + ", name: " + this.componentName + "] has been exceeded by " + (timeSinceComponentRefresh - this.availRefreshInterval) + " ms. Reloading managed component..."));
            }
            ManagedComponent managedComponent = this.getManagedComponent();
            this.runState = managedComponent.getRunState();
        }
        return this.getAvailabilityForRunState(this.runState);
    }

    protected AvailabilityType getAvailabilityForRunState(RunState runState) {
        if (runState == RunState.RUNNING) {
            return AvailabilityType.UP;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Returning DOWN avail for " + this.componentType + " component '" + this.componentName + "' with runState [" + runState + "]."));
        }
        return AvailabilityType.DOWN;
    }

    @Override
    public void start(ResourceContext<ProfileServiceComponent<?>> resourceContext) throws Exception {
        super.start(resourceContext);
        this.componentType = ConversionUtils.getComponentType(this.getResourceContext().getResourceType());
        Configuration pluginConfig = resourceContext.getPluginConfiguration();
        this.componentName = pluginConfig.getSimple("componentName").getStringValue();
        this.initAvailRefreshInterval(resourceContext);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Started ResourceComponent for " + this.getResourceDescription() + ", managing " + this.componentType + " component '" + this.componentName + "'."));
        }
    }

    @Override
    public void stop() {
        super.stop();
    }

    public Configuration loadResourceConfiguration() {
        Configuration resourceConfig;
        ManagedComponent managedComponent = this.getManagedComponent();
        try {
            Map managedProperties = managedComponent.getProperties();
            Map<String, PropertySimple> customProps = ResourceComponentUtils.getCustomProperties(this.getResourceContext().getPluginConfiguration());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("*** AFTER LOAD:\n" + DebugUtils.convertPropertiesToString(managedProperties)));
            }
            resourceConfig = ConversionUtils.convertManagedObjectToConfiguration(managedProperties, customProps, this.getResourceContext().getResourceType());
        }
        catch (Exception e) {
            RunState runState = managedComponent.getRunState();
            if (runState == RunState.RUNNING) {
                LOG.error((Object)("Failed to load configuration for " + this.getResourceDescription() + "."), (Throwable)e);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Failed to load configuration for " + this.getResourceDescription() + ", but managed component is not in the RUNNING state."), (Throwable)e);
            }
            throw new RuntimeException(ThrowableUtil.getAllMessages((Throwable)e));
        }
        return resourceConfig;
    }

    public void updateResourceConfigurationChangesOnly(ConfigurationUpdateReport configurationUpdateReport) {
        Configuration existing = this.loadResourceConfiguration();
        Configuration config = configurationUpdateReport.getConfiguration();
        ConfigurationDefinition configDefCopy = ManagedComponentComponent.copyConfigurationDefinition(this.getResourceContext().getResourceType().getResourceConfigurationDefinition());
        for (Property prop : config.getAllProperties().values()) {
            if (!(prop instanceof PropertySimple) || !(prop instanceof PropertySimple)) continue;
            PropertySimple propSimple = (PropertySimple)prop;
            String val1 = propSimple.getStringValue();
            String val2 = existing.getSimpleValue(propSimple.getName());
            if (val1 == null && val2 == null) {
                configDefCopy.getPropertyDefinitions().remove(propSimple.getName());
            }
            if (val1 != null) {
                if (!val1.equals(val2)) continue;
                configDefCopy.getPropertyDefinitions().remove(propSimple.getName());
                continue;
            }
            if (val2 == null || !val2.equals(val1)) continue;
            configDefCopy.getPropertyDefinitions().remove(propSimple.getName());
        }
        this.updateResourceConfiguration(configurationUpdateReport, configDefCopy);
    }

    protected void updateResourceConfiguration(ConfigurationUpdateReport configurationUpdateReport, ConfigurationDefinition resourceConfigurationDefinition) {
        Configuration resourceConfig = configurationUpdateReport.getConfiguration();
        Configuration pluginConfig = this.getResourceContext().getPluginConfiguration();
        try {
            ManagedComponent managedComponent = this.getManagedComponent();
            Map managedProperties = managedComponent.getProperties();
            Map<String, PropertySimple> customProps = ResourceComponentUtils.getCustomProperties(pluginConfig);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("*** BEFORE UPDATE:\n" + DebugUtils.convertPropertiesToString(managedProperties)));
            }
            ConversionUtils.convertConfigurationToManagedProperties(managedProperties, resourceConfig, resourceConfigurationDefinition, customProps, true);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("*** AFTER UPDATE:\n" + DebugUtils.convertPropertiesToString(managedProperties)));
            }
            this.updateComponent(managedComponent);
            configurationUpdateReport.setStatus(ConfigurationUpdateStatus.SUCCESS);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to update configuration for " + this.getResourceDescription() + "."), (Throwable)e);
            configurationUpdateReport.setStatus(ConfigurationUpdateStatus.FAILURE);
            configurationUpdateReport.setErrorMessage(ThrowableUtil.getAllMessages((Throwable)e));
        }
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport configurationUpdateReport) {
        this.updateResourceConfiguration(configurationUpdateReport, this.getResourceContext().getResourceType().getResourceConfigurationDefinition());
    }

    public void deleteResource() throws Exception {
        DeploymentManager deploymentManager = this.getConnection().getDeploymentManager();
        if (!deploymentManager.isRedeploySupported()) {
            throw new UnsupportedOperationException("Deletion of " + this.getResourceContext().getResourceType().getName() + " Resources is not currently supported.");
        }
        ManagedComponent managedComponent = this.getManagedComponent();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removing " + this.getResourceDescription() + " with component " + ManagedComponentComponent.toString(managedComponent) + "..."));
        }
        ManagementView managementView = this.getConnection().getManagementView();
        managementView.removeComponent(managedComponent);
        ManagedDeployment parentDeployment = managedComponent.getDeployment();
        if (parentDeployment.getComponents().size() > 1 || !parentDeployment.getChildren().isEmpty()) {
            DeploymentProgress progress;
            DeploymentStatus status;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Redeploying parent deployment '" + parentDeployment.getName() + "' in order to complete removal of component " + ManagedComponentComponent.toString(managedComponent) + "..."));
            }
            if ((status = DeploymentUtils.run(progress = deploymentManager.redeploy(parentDeployment.getName()))).isFailed()) {
                LOG.error((Object)("Failed to redeploy parent deployment '" + parentDeployment.getName() + "during removal of component " + ManagedComponentComponent.toString(managedComponent) + " - removal may not persist when the app server is restarted."), (Throwable)status.getFailure());
            }
        } else {
            DeploymentProgress progress;
            DeploymentStatus status;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Undeploying parent deployment '" + parentDeployment.getName() + "' in order to complete removal of component " + ManagedComponentComponent.toString(managedComponent) + "..."));
            }
            if ((status = DeploymentUtils.run(progress = deploymentManager.remove(new String[]{(parentDeployment = managementView.getDeployment(parentDeployment.getName())).getName()}))).isFailed()) {
                LOG.error((Object)("Failed to undeploy parent deployment '" + parentDeployment.getName() + "during removal of component " + ManagedComponentComponent.toString(managedComponent) + " - removal may not persist when the app server is restarted."), (Throwable)status.getFailure());
            }
        }
        managementView.load();
    }

    public OperationResult invokeOperation(String name, Configuration parameters) throws Exception {
        return this.invokeOperation(this.getManagedComponent(), name, parameters);
    }

    protected OperationResult invokeOperation(ManagedComponent managedComponent, String name, Configuration parameters) throws Exception {
        boolean availCheck;
        OperationDefinition operationDefinition = this.getOperationDefinition(name);
        ManagedOperation managedOperation = this.getManagedOperation(managedComponent, operationDefinition);
        MetaValue[] parameterMetaValues = ConversionUtils.convertOperationsParametersToMetaValues(managedOperation, parameters, operationDefinition);
        MetaValue resultMetaValue = managedOperation.invoke(parameterMetaValues);
        OperationResult result = new OperationResult();
        ConversionUtils.convertManagedOperationResults(managedOperation, resultMetaValue, result.getComplexResults(), operationDefinition);
        boolean bl = availCheck = name.toLowerCase().equals("stop") || name.toLowerCase().contains("start");
        if (availCheck) {
            this.getResourceContext().getAvailabilityContext().requestAvailabilityCheck();
        }
        return result;
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        this.getValues(this.getManagedComponent(), report, metrics);
    }

    protected void getValues(ManagedComponent managedComponent, MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        RunState runState = managedComponent.getRunState();
        for (MeasurementScheduleRequest request : metrics) {
            try {
                String value = this.getMeasurement(managedComponent, request.getName());
                this.addValueToMeasurementReport(report, request, value);
            }
            catch (Exception e) {
                if (runState == RunState.RUNNING) {
                    LOG.error((Object)("Failed to collect metric for " + request), (Throwable)e);
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Failed to collect metric for " + request + ", but managed component is not in the RUNNING state."), (Throwable)e);
            }
        }
    }

    protected String getMeasurement(ManagedComponent component, String metricName) throws Exception {
        if ("runState".equals(metricName)) {
            return component.getRunState().name();
        }
        Object value = this.getSimpleValue(component, metricName);
        return value == null ? null : ManagedComponentComponent.toString(value);
    }

    protected void updateComponent(ManagedComponent managedComponent) throws Exception {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Updating " + this.getResourceDescription() + " with component " + ManagedComponentComponent.toString(managedComponent) + "..."));
        }
        ManagementView managementView = this.getConnection().getManagementView();
        managementView.updateComponent(managedComponent);
        managementView.load();
    }

    @Nullable
    protected Object getSimpleValue(ManagedComponent managedComponent, MeasurementScheduleRequest request) {
        String metricName = request.getName();
        return this.getSimpleValue(managedComponent, metricName);
    }

    @Nullable
    protected Object getSimpleValue(ManagedComponent managedComponent, String metricName) {
        MetaValue metaValue;
        int pipeIndex = metricName.indexOf(124);
        String compositePropName = pipeIndex == -1 ? metricName : metricName.substring(pipeIndex + 1);
        int dotIndex = compositePropName.indexOf(46);
        String metricPropName = dotIndex == -1 ? compositePropName : compositePropName.substring(0, dotIndex);
        ManagedProperty metricProp = managedComponent.getProperty(metricPropName);
        if (metricProp == null) {
            return null;
        }
        if (dotIndex == -1) {
            metaValue = metricProp.getValue();
        } else {
            CompositeValue compositeValue = (CompositeValue)metricProp.getValue();
            String key = compositePropName.substring(dotIndex + 1);
            metaValue = compositeValue.get(key);
        }
        return ManagedComponentComponent.getInnerValue(metaValue);
    }

    @Nullable
    protected ManagedProperty getManagedProperty(ManagedComponent managedComponent, MeasurementScheduleRequest request) {
        String metricName = request.getName();
        int pipeIndex = metricName.indexOf(124);
        String compositePropName = pipeIndex == -1 ? metricName : metricName.substring(pipeIndex + 1);
        int dotIndex = compositePropName.indexOf(46);
        String metricPropName = dotIndex == -1 ? compositePropName : compositePropName.substring(0, dotIndex);
        return managedComponent.getProperty(metricPropName);
    }

    @Nullable
    protected static Object getInnerValue(MetaValue metaValue) {
        ArrayList<Object> value;
        if (metaValue == null) {
            return null;
        }
        if (metaValue.getMetaType().isSimple()) {
            SimpleValue simpleValue = (SimpleValue)metaValue;
            value = simpleValue.getValue();
        } else if (metaValue.getMetaType().isEnum()) {
            EnumValue enumValue = (EnumValue)metaValue;
            value = enumValue.getValue();
        } else if (metaValue.getMetaType().isArray()) {
            ArrayValue arrayValue = (ArrayValue)metaValue;
            value = arrayValue.getValue();
        } else if (metaValue.getMetaType().isCollection()) {
            CollectionValue collectionValue = (CollectionValue)metaValue;
            ArrayList<Object> list = new ArrayList<Object>();
            for (MetaValue element : collectionValue.getElements()) {
                list.add(ManagedComponentComponent.getInnerValue(element));
            }
            value = list;
        } else {
            value = metaValue.toString();
        }
        return value;
    }

    protected void addValueToMeasurementReport(MeasurementReport report, MeasurementScheduleRequest request, Object value) {
        if (value == null) {
            return;
        }
        String stringValue = ManagedComponentComponent.toString(value);
        DataType dataType = request.getDataType();
        switch (dataType) {
            case MEASUREMENT: {
                try {
                    MeasurementDataNumeric dataNumeric = new MeasurementDataNumeric(request, Double.valueOf(stringValue));
                    report.addData(dataNumeric);
                }
                catch (NumberFormatException e) {
                    LOG.error((Object)("Profile service did not return a numeric value as expected for metric [" + request.getName() + "] - value returned was " + value + "."), (Throwable)e);
                }
                break;
            }
            case TRAIT: {
                MeasurementDataTrait dataTrait = new MeasurementDataTrait(request, stringValue);
                report.addData(dataTrait);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported measurement data type: " + dataType);
            }
        }
    }

    protected ComponentType getComponentType() {
        return this.componentType;
    }

    protected String getComponentName() {
        return this.componentName;
    }

    @NotNull
    protected ManagedComponent getManagedComponent() {
        ManagedComponent managedComponent;
        try {
            ManagementView managementView = this.getConnection().getManagementView();
            managedComponent = this.getManagedComponent(managementView);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load [" + this.componentType + "] ManagedComponent [" + this.componentName + "].", e);
        }
        this.lastComponentRefresh = System.currentTimeMillis();
        if (managedComponent == null) {
            throw new IllegalStateException("Failed to find [" + this.componentType + "] ManagedComponent named [" + this.componentName + "].");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Retrieved " + ManagedComponentComponent.toString(managedComponent) + "."));
        }
        return managedComponent;
    }

    protected ManagedComponent getManagedComponent(ManagementView managementView) throws Exception {
        if (null == managementView) {
            throw new IllegalArgumentException("managementView can not be null");
        }
        return managementView.getComponent(this.componentName, this.componentType);
    }

    @NotNull
    private OperationDefinition getOperationDefinition(String operationName) {
        ResourceType resourceType = this.getResourceContext().getResourceType();
        OperationDefinition operationDefinition = ResourceTypeUtils.getOperationDefinition(resourceType, operationName);
        if (operationDefinition == null) {
            throw new IllegalStateException("Operation named '" + operationName + "' is not defined for Resource type '" + resourceType.getName() + "' in the '" + resourceType.getPlugin() + "' plugin's descriptor.");
        }
        return operationDefinition;
    }

    @NotNull
    private ManagedOperation getManagedOperation(ManagedComponent managedComponent, OperationDefinition operationDefinition) {
        Set operations = managedComponent.getOperations();
        for (ManagedOperation operation : operations) {
            int paramCount;
            ConfigurationDefinition paramsConfigDef = operationDefinition.getParametersConfigurationDefinition();
            int n = paramCount = paramsConfigDef != null ? paramsConfigDef.getPropertyDefinitions().size() : 0;
            if (!operation.getName().equals(operationDefinition.getName()) || operation.getParameters().length != paramCount) continue;
            return operation;
        }
        throw new IllegalStateException("ManagedOperation named '" + operationDefinition.getName() + "' not found on ManagedComponent [" + managedComponent + "].");
    }

    private static String toString(ManagedComponent managedComponent) {
        Map properties = managedComponent.getProperties();
        return managedComponent.getClass().getSimpleName() + "@" + System.identityHashCode(managedComponent) + "[" + "type=" + managedComponent.getType() + ", name=" + managedComponent.getName() + ", properties=" + properties.getClass().getSimpleName() + "@" + System.identityHashCode(properties) + "]";
    }

    private static String toString(@NotNull Object value) {
        if (value.getClass().isArray()) {
            StringBuilder buffer = new StringBuilder();
            int lastIndex = Array.getLength(value) - 1;
            for (int i = 0; i < Array.getLength(value); ++i) {
                buffer.append(String.valueOf(Array.get(value, i)));
                if (i == lastIndex) break;
                buffer.append(", ");
            }
            return buffer.toString();
        }
        return value.toString();
    }

    private void initAvailRefreshInterval(ResourceContext<ProfileServiceComponent<?>> context) {
        ProfileServiceComponent component = (ProfileServiceComponent)context.getParentResourceComponent();
        while (component != null && !(component instanceof ApplicationServerComponent)) {
            component = (ProfileServiceComponent)component.getResourceContext().getParentResourceComponent();
        }
        if (component == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Failed to find parent " + ApplicationServerComponent.class.getSimpleName() + ". Using default component refresh interval, " + 900000L + " ms"));
            }
            return;
        }
        String interval = component.getResourceContext().getPluginConfiguration().getSimpleValue("serviceAvailabilityRefreshInterval", Long.toString(900000L));
        this.availRefreshInterval = Long.parseLong(interval) * 1000L * 60L;
    }

    static ConfigurationDefinition copyConfigurationDefinition(ConfigurationDefinition configurationDefinition) {
        ConfigurationDefinition configDefCopy = new ConfigurationDefinition(configurationDefinition.getName(), configurationDefinition.getDescription());
        configDefCopy.setConfigurationFormat(configurationDefinition.getConfigurationFormat());
        configDefCopy.setPropertyDefinitions(new HashMap(configurationDefinition.getPropertyDefinitions()));
        return configDefCopy;
    }

    public static interface Config {
        public static final String COMPONENT_TYPE = "componentType";
        public static final String COMPONENT_SUBTYPE = "componentSubtype";
        public static final String COMPONENT_NAME = "componentName";
        public static final String TEMPLATE_NAME = "templateName";
        public static final String COMPONENT_NAME_PROPERTY = "componentNameProperty";
    }
}

