/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.deployers.spi.management.deploy.DeploymentManager;
import org.jboss.deployers.spi.management.deploy.DeploymentProgress;
import org.jboss.deployers.spi.management.deploy.DeploymentStatus;
import org.rhq.core.domain.content.PackageDetailsKey;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.transfer.ContentResponseResult;
import org.rhq.core.domain.content.transfer.DeployIndividualPackageResponse;
import org.rhq.core.domain.content.transfer.DeployPackageStep;
import org.rhq.core.domain.content.transfer.DeployPackagesResponse;
import org.rhq.core.domain.content.transfer.RemovePackagesResponse;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.content.ContentFacet;
import org.rhq.core.pluginapi.content.ContentServices;
import org.rhq.core.pluginapi.inventory.DeleteResourceFacet;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.core.util.ZipUtil;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.core.util.file.JarContentFileInfo;
import org.rhq.plugins.jbossas5.AbstractManagedDeploymentComponent;
import org.rhq.plugins.jbossas5.util.DeploymentUtils;

public class StandaloneManagedDeploymentComponent
extends AbstractManagedDeploymentComponent
implements MeasurementFacet,
ContentFacet,
DeleteResourceFacet {
    private static final String CUSTOM_PATH_TRAIT = "custom.path";
    private static final String CUSTOM_EXPLODED_TRAIT = "custom.exploded";
    public static final String RHQ_SHA256 = "RHQ-Sha256";
    private static final String PKG_TYPE_FILE = "file";
    private static final String ARCHITECTURE = "noarch";
    private final Log log = LogFactory.getLog(this.getClass());

    @Override
    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) throws Exception {
        HashSet<MeasurementScheduleRequest> remainingRequests = new HashSet<MeasurementScheduleRequest>();
        for (MeasurementScheduleRequest request : requests) {
            String metricName = request.getName();
            if (metricName.equals(CUSTOM_PATH_TRAIT)) {
                MeasurementDataTrait trait = new MeasurementDataTrait(request, this.deploymentFile.getPath());
                report.addData(trait);
                continue;
            }
            if (metricName.equals(CUSTOM_EXPLODED_TRAIT)) {
                boolean exploded = this.deploymentFile.isDirectory();
                MeasurementDataTrait trait = new MeasurementDataTrait(request, exploded ? "yes" : "no");
                report.addData(trait);
                continue;
            }
            remainingRequests.add(request);
        }
        super.getValues(report, remainingRequests);
    }

    public InputStream retrievePackageBits(ResourcePackageDetails packageDetails) {
        File packageFile = new File(packageDetails.getName());
        try {
            File fileToSend;
            if (!packageFile.exists() && this.deploymentFile != null) {
                packageFile = this.deploymentFile;
            }
            if (packageFile.isDirectory()) {
                fileToSend = File.createTempFile("rhq", ".zip");
                ZipUtil.zipFileOrDirectory((File)packageFile, (File)fileToSend);
            } else {
                fileToSend = packageFile;
            }
            return new BufferedInputStream(new FileInputStream(fileToSend));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to retrieve package bits for " + packageDetails, e);
        }
    }

    public Set<ResourcePackageDetails> discoverDeployedPackages(PackageType packageType) {
        if (!this.deploymentFile.exists()) {
            throw new IllegalStateException("Deployment file '" + this.deploymentFile + "' for " + this.getResourceDescription() + " does not exist.");
        }
        String fileName = this.deploymentFile.getName();
        JarContentFileInfo fileInfo = new JarContentFileInfo(this.deploymentFile);
        String sha256 = this.getSHA256(fileInfo);
        String version = this.getVersion(fileInfo, sha256);
        PackageDetailsKey key = new PackageDetailsKey(fileName, version, PKG_TYPE_FILE, ARCHITECTURE);
        ResourcePackageDetails packageDetails = new ResourcePackageDetails(key);
        packageDetails.setFileName(fileName);
        packageDetails.setLocation(this.deploymentFile.getPath());
        if (!this.deploymentFile.isDirectory()) {
            packageDetails.setFileSize(Long.valueOf(this.deploymentFile.length()));
        }
        packageDetails.setFileCreatedDate(null);
        packageDetails.setSHA256(sha256);
        packageDetails.setInstallationTimestamp(Long.valueOf(System.currentTimeMillis()).longValue());
        HashSet<ResourcePackageDetails> packages = new HashSet<ResourcePackageDetails>();
        packages.add(packageDetails);
        return packages;
    }

    private String getSHA256(JarContentFileInfo fileInfo) {
        String sha256;
        block3: {
            sha256 = null;
            try {
                sha256 = fileInfo.getAttributeValue(RHQ_SHA256, null);
                if (null == sha256) {
                    sha256 = new MessageDigestGenerator("SHA-256").calcDigestString(fileInfo.getContentFile());
                }
            }
            catch (IOException iex) {
                if (!this.log.isDebugEnabled()) break block3;
                this.log.debug((Object)("Problem calculating digest of package [" + fileInfo.getContentFile().getPath() + "]." + iex.getMessage()));
            }
        }
        return sha256;
    }

    private String getVersion(JarContentFileInfo fileInfo, String sha256) {
        String version = "0";
        String manifestVersion = fileInfo.getVersion(null);
        if (null != manifestVersion && null != sha256) {
            version = manifestVersion + " [sha256=" + sha256 + "]";
        } else if (null != sha256) {
            version = "[sha256=" + sha256 + "]";
        } else if (null != manifestVersion) {
            version = manifestVersion;
        }
        return version;
    }

    public RemovePackagesResponse removePackages(Set<ResourcePackageDetails> packages) {
        throw new UnsupportedOperationException("Cannot remove the package backing an EAR/WAR resource.");
    }

    public List<DeployPackageStep> generateInstallationSteps(ResourcePackageDetails packageDetails) {
        return null;
    }

    public DeployPackagesResponse deployPackages(Set<ResourcePackageDetails> packages, ContentServices contentServices) {
        DeploymentProgress progress;
        DeploymentManager deploymentManager;
        File tempFile;
        String resourceTypeName = this.getResourceContext().getResourceType().getName();
        if (packages.size() != 1) {
            this.log.warn((Object)("Request to update " + resourceTypeName + " file contained multiple packages: " + packages));
            DeployPackagesResponse response = new DeployPackagesResponse(ContentResponseResult.FAILURE);
            response.setOverallRequestErrorMessage("Only one " + resourceTypeName + " can be updated at a time.");
            return response;
        }
        ResourcePackageDetails packageDetails = packages.iterator().next();
        this.log.debug((Object)("Updating EAR/WAR file '" + this.deploymentFile + "' using [" + packageDetails + "]..."));
        if (!this.deploymentFile.exists()) {
            return this.failApplicationDeployment("Could not find application to update at location: " + this.deploymentFile, packageDetails);
        }
        this.log.debug((Object)"Writing new EAR/WAR bits to temporary file...");
        try {
            tempFile = this.writeNewAppBitsToTempFile(contentServices, packageDetails);
        }
        catch (Exception e) {
            return this.failApplicationDeployment("Error writing new application bits to temporary file - cause: " + e, packageDetails);
        }
        this.log.debug((Object)("Wrote new EAR/WAR bits to temporary file '" + tempFile + "'."));
        boolean deployExploded = this.deploymentFile.isDirectory();
        File tempDir = this.getResourceContext().getTemporaryDirectory();
        File backupDir = new File(tempDir, "deployBackup");
        File backupOfOriginalFile = new File(backupDir, this.deploymentFile.getName());
        this.log.debug((Object)("Backing up existing EAR/WAR '" + this.deploymentFile + "' to '" + backupOfOriginalFile + "'..."));
        try {
            if (backupOfOriginalFile.exists()) {
                FileUtils.forceDelete((File)backupOfOriginalFile);
            }
            if (this.deploymentFile.isDirectory()) {
                FileUtils.copyDirectory((File)this.deploymentFile, (File)backupOfOriginalFile, (boolean)true);
            } else {
                FileUtils.copyFile((File)this.deploymentFile, (File)backupOfOriginalFile, (boolean)true);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to backup existing " + resourceTypeName + "'" + this.deploymentFile + "' to '" + backupOfOriginalFile + "'.");
        }
        try {
            deploymentManager = this.getConnection().getDeploymentManager();
            progress = deploymentManager.stop(new String[]{this.deploymentName});
            DeploymentUtils.run(progress);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to stop deployment [" + this.deploymentName + "].", e);
        }
        try {
            deploymentManager = this.getConnection().getDeploymentManager();
            progress = deploymentManager.remove(new String[]{this.deploymentName});
            DeploymentUtils.run(progress);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to remove deployment [" + this.deploymentName + "].", e);
        }
        this.log.debug((Object)("Deploying '" + tempFile + "'..."));
        deploymentManager = this.getConnection().getDeploymentManager();
        try {
            DeploymentUtils.deployArchive(deploymentManager, tempFile, deployExploded);
        }
        catch (Exception e) {
            this.log.debug((Object)"Redeploy failed - rolling back to original archive...", (Throwable)e);
            String errorMessage = ThrowableUtil.getAllMessages((Throwable)e);
            try {
                if (this.deploymentFile.exists()) {
                    try {
                        FileUtils.forceDelete((File)this.deploymentFile);
                    }
                    catch (IOException e1) {
                        this.log.debug((Object)("Failed to delete application file '" + this.deploymentFile + "' that failed to deploy."), (Throwable)e1);
                    }
                }
                DeploymentUtils.deployArchive(deploymentManager, backupOfOriginalFile, deployExploded);
                errorMessage = errorMessage + " ***** ROLLED BACK TO ORIGINAL APPLICATION FILE. *****";
            }
            catch (Exception e1) {
                this.log.debug((Object)"Rollback failed!", (Throwable)e1);
                errorMessage = errorMessage + " ***** FAILED TO ROLLBACK TO ORIGINAL APPLICATION FILE. *****: " + ThrowableUtil.getAllMessages((Throwable)e1);
            }
            this.log.info((Object)("Failed to update " + resourceTypeName + " file '" + this.deploymentFile + "' using [" + packageDetails + "]."));
            return this.failApplicationDeployment(errorMessage, packageDetails);
        }
        this.deleteBackupOfOriginalFile(backupOfOriginalFile);
        DeployPackagesResponse response = new DeployPackagesResponse(ContentResponseResult.SUCCESS);
        DeployIndividualPackageResponse packageResponse = new DeployIndividualPackageResponse(packageDetails.getKey(), ContentResponseResult.SUCCESS);
        response.addPackageResponse(packageResponse);
        this.log.debug((Object)("Updated " + resourceTypeName + " file '" + this.deploymentFile + "' successfully - returning response [" + response + "]..."));
        return response;
    }

    public void deleteResource() throws Exception {
        this.log.debug((Object)("Deleting " + this.getResourceDescription() + "..."));
        DeploymentManager deploymentManager = this.getConnection().getDeploymentManager();
        try {
            this.getManagedDeployment();
        }
        catch (Exception e) {
            this.log.warn((Object)("Cannot delete the deployment [" + this.deploymentName + "], since it no longer exists"));
            return;
        }
        this.log.debug((Object)("Stopping deployment [" + this.deploymentName + "]..."));
        DeploymentProgress progress = deploymentManager.stop(new String[]{this.deploymentName});
        DeploymentStatus stopStatus = DeploymentUtils.run(progress);
        if (stopStatus.isFailed()) {
            this.log.error((Object)("Failed to stop deployment '" + this.deploymentName + "'."), (Throwable)stopStatus.getFailure());
            throw new Exception("Failed to stop deployment '" + this.deploymentName + "' - cause: " + stopStatus.getFailure());
        }
        this.log.debug((Object)("Removing deployment [" + this.deploymentName + "]..."));
        progress = deploymentManager.remove(new String[]{this.deploymentName});
        DeploymentStatus removeStatus = DeploymentUtils.run(progress);
        if (removeStatus.isFailed()) {
            this.log.error((Object)("Failed to remove deployment '" + this.deploymentName + "'."), (Throwable)removeStatus.getFailure());
            throw new Exception("Failed to remove deployment '" + this.deploymentName + "' - cause: " + removeStatus.getFailure());
        }
        ManagementView managementView = this.getConnection().getManagementView();
        managementView.load();
    }

    private DeployPackagesResponse failApplicationDeployment(String errorMessage, ResourcePackageDetails packageDetails) {
        DeployPackagesResponse response = new DeployPackagesResponse(ContentResponseResult.FAILURE);
        DeployIndividualPackageResponse packageResponse = new DeployIndividualPackageResponse(packageDetails.getKey(), ContentResponseResult.FAILURE);
        packageResponse.setErrorMessage(errorMessage);
        response.addPackageResponse(packageResponse);
        return response;
    }

    private void deleteBackupOfOriginalFile(File backupOfOriginalFile) {
        this.log.debug((Object)("Deleting backup of original file '" + backupOfOriginalFile + "'..."));
        try {
            FileUtils.forceDelete((File)backupOfOriginalFile);
        }
        catch (Exception e) {
            this.log.warn((Object)("Failed to delete backup of original file: " + backupOfOriginalFile));
        }
    }

    private File writeNewAppBitsToTempFile(ContentServices contentServices, ResourcePackageDetails packageDetails) throws Exception {
        File tempDir = this.getResourceContext().getTemporaryDirectory();
        File tempFile = new File(tempDir, this.deploymentFile.getName());
        OutputStream tempOutputStream = null;
        try {
            tempOutputStream = new BufferedOutputStream(new FileOutputStream(tempFile));
            long bytesWritten = contentServices.downloadPackageBits(this.getResourceContext().getContentContext(), packageDetails.getKey(), tempOutputStream, true);
            this.log.debug((Object)("Wrote " + bytesWritten + " bytes to '" + tempFile + "'."));
        }
        catch (IOException e) {
            this.log.error((Object)("Error writing updated application bits to temporary location: " + tempFile), (Throwable)e);
            throw e;
        }
        finally {
            if (tempOutputStream != null) {
                try {
                    tempOutputStream.close();
                }
                catch (IOException e) {
                    this.log.error((Object)"Error closing temporary output stream", (Throwable)e);
                }
            }
        }
        if (!tempFile.exists()) {
            this.log.error((Object)("Temporary file for application update not written to: " + tempFile));
            throw new Exception();
        }
        return tempFile;
    }
}

