/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbosscache3;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jbossas5.ProfileServiceComponent;
import org.rhq.plugins.jbosscache3.JBossCacheComponent;
import org.rhq.plugins.jbosscache3.JBossCacheDetailComponent;

public class JBossCacheDetailDiscoveryComponent
implements ResourceDiscoveryComponent<ProfileServiceComponent<?>> {
    public static String CACHE_JMX_NAME = "jmx-resource";
    private final Log log = LogFactory.getLog(this.getClass());
    private ProfileServiceComponent parentComponent;

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<ProfileServiceComponent<?>> context) throws InvalidPluginConfigurationException, Exception {
        ResourceType resourceType = context.getResourceType();
        this.log.trace((Object)("Discovering " + resourceType.getName() + " Resources..."));
        this.parentComponent = (ProfileServiceComponent)context.getParentResourceComponent();
        Configuration parentPluginConfig = context.getParentResourceContext().getPluginConfiguration();
        if (parentPluginConfig.get(JBossCacheComponent.CACHE_SEARCH_STRING) == null) {
            throw new InvalidPluginConfigurationException("Invalid plugin configuration in JBossCache component.");
        }
        String beanName = parentPluginConfig.getSimple(JBossCacheComponent.CACHE_SEARCH_STRING).getStringValue();
        Configuration defaultConfig = context.getDefaultPluginConfiguration();
        EmsConnection connection = this.parentComponent.getEmsConnection();
        HashSet<DiscoveredResourceDetails> resources = new HashSet<DiscoveredResourceDetails>();
        String jmxName = defaultConfig.getSimple(CACHE_JMX_NAME).getStringValue();
        beanName = beanName + (jmxName == null || jmxName.equals("") ? "" : "," + jmxName);
        EmsBean emsBean = connection.getBean(beanName);
        if (emsBean == null) {
            connection.refresh();
            emsBean = connection.getBean(beanName);
        }
        if (emsBean != null) {
            Configuration conf = new Configuration();
            conf.put((Property)new PropertySimple(JBossCacheDetailComponent.CACHE_DETAIL_BEAN_NAME, (Object)beanName));
            conf.put((Property)new PropertySimple(CACHE_JMX_NAME, (Object)jmxName));
            resources.add(new DiscoveredResourceDetails(resourceType, beanName, resourceType.getName(), "", "JBoss Cache", conf, null));
        }
        this.log.trace((Object)("Discovered " + resources.size() + " " + resourceType.getName() + " Resources."));
        return resources;
    }
}

