/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.plugins.tomcat.helper;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TomcatConfig {
    private static HashMap<File, TomcatConfig> cache = null;
    private String address;
    private String port;
    private long lastModified = 0L;

    private TomcatConfig() {
    }

    public static synchronized TomcatConfig getConfig(File configXML) {
        if (cache == null) {
            cache = new HashMap();
        }
        TomcatConfig cfg = cache.get(configXML);
        long lastModified = configXML.lastModified();
        if (cfg == null || lastModified != cfg.lastModified) {
            cfg = new TomcatConfig();
            cfg.lastModified = lastModified;
            cache.put(configXML, cfg);
            try {
                cfg.read(configXML);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return cfg;
    }

    public String getPort() {
        return this.port;
    }

    public String getAddress() {
        return this.address;
    }

    private void read(File file) throws IOException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            this.parse(is);
        }
        catch (SAXException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (ParserConfigurationException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void parse(InputStream is) throws IOException, SAXException, ParserConfigurationException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = factory.newSAXParser();
        TomcatConnectorHandler handler = new TomcatConnectorHandler();
        parser.parse(is, (DefaultHandler)handler);
        this.port = handler.getPort();
        this.address = handler.getAddress();
    }

    public static void main(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            TomcatConfig cfg = TomcatConfig.getConfig(new File(args[i]));
            System.out.println("Port=" + cfg.getPort() + " [" + args[i] + "]");
        }
    }

    static class TomcatConnectorHandler
    extends DefaultHandler {
        private String address;
        private String port;

        TomcatConnectorHandler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (!qName.equals("Connector")) {
                return;
            }
            if (attributes.getValue("protocolHandlerClassName") != null) {
                return;
            }
            if (attributes.getValue("protocol") != null && !attributes.getValue("protocol").toLowerCase().contains("http")) {
                return;
            }
            String scheme = attributes.getValue("scheme");
            if ("https".equals(scheme)) {
                return;
            }
            String className = attributes.getValue("className");
            if (className != null && (className.endsWith("WarpConnector") || className.endsWith("Ajp13Connector"))) {
                return;
            }
            this.port = attributes.getValue("port");
            this.address = attributes.getValue("address");
        }

        protected String getPort() {
            return this.port;
        }

        protected String getAddress() {
            return this.address;
        }
    }
}

