/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.plugins.tomcat;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jboss.on.plugins.tomcat.TomcatServerComponent;
import org.jboss.on.plugins.tomcat.helper.CreateResourceHelper;
import org.jboss.on.plugins.tomcat.helper.FileContentDelegate;
import org.jboss.on.plugins.tomcat.helper.TomcatApplicationDeployer;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.content.PackageDetailsKey;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.content.ContentContext;
import org.rhq.core.pluginapi.content.ContentServices;
import org.rhq.core.pluginapi.inventory.ApplicationServerComponent;
import org.rhq.core.pluginapi.inventory.CreateChildResourceFacet;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.plugins.jmx.MBeanResourceComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TomcatVHostComponent
extends MBeanResourceComponent<TomcatServerComponent>
implements ApplicationServerComponent,
CreateChildResourceFacet {
    public static final String CONFIG_ALIASES = "aliases";
    public static final String CONFIG_APP_BASE = "appBase";
    public static final String CONFIG_UNPACK_WARS = "unpackWARs";
    public static final String CONTENT_CONFIG_EXPLODE_ON_DEPLOY = "explodeOnDeploy";
    public static final String PLUGIN_CONFIG_NAME = "name";

    public Configuration loadResourceConfiguration() {
        Configuration configuration = super.loadResourceConfiguration();
        try {
            this.resetConfig(CONFIG_ALIASES, configuration);
        }
        catch (Exception e) {
            log.error((Object)"Failed to reset role property value", (Throwable)e);
        }
        return configuration;
    }

    private void resetConfig(String property, Configuration configuration) {
        EmsAttribute attribute = this.getEmsBean().getAttribute(property);
        Object valueObject = attribute.refresh();
        String[] vals = (String[])valueObject;
        if (vals.length > 0) {
            String delim = "";
            StringBuilder sb = new StringBuilder();
            for (String val : vals) {
                sb.append(delim);
                sb.append(val);
                delim = "\n";
            }
            configuration.put((Property)new PropertySimple(property, (Object)sb.toString()));
        } else {
            configuration.put((Property)new PropertySimple(property, null));
        }
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        Configuration reportConfiguration = report.getConfiguration();
        PropertySimple newAliases = reportConfiguration.getSimple(CONFIG_ALIASES);
        this.resetConfig(CONFIG_ALIASES, reportConfiguration);
        PropertySimple currentAliases = reportConfiguration.getSimple(CONFIG_ALIASES);
        reportConfiguration.remove(CONFIG_ALIASES);
        super.updateResourceConfiguration(report);
        reportConfiguration.put((Property)newAliases);
        if (ConfigurationUpdateStatus.SUCCESS != report.getStatus()) {
            return;
        }
        try {
            this.consolidateSettings(newAliases, currentAliases, "addAlias", "removeAlias", "alias");
        }
        catch (Exception e) {
            newAliases.setErrorMessage(ThrowableUtil.getStackAsString((Throwable)e));
            report.setErrorMessage("Failed setting resource configuration - see property error messages for details");
            log.info((Object)"Failure setting Tomcat VHost aliases configuration value", (Throwable)e);
        }
        try {
            this.storeConfig();
        }
        catch (Exception e) {
            report.setErrorMessage("Failed to persist configuration change.  Changes will not survive Tomcat restart unless a successful Store Configuration operation is performed.");
        }
    }

    void storeConfig() throws Exception {
        ((TomcatServerComponent)this.getResourceContext().getParentResourceComponent()).storeConfig();
    }

    private void consolidateSettings(PropertySimple newVals, PropertySimple currentVals, String addOp, String removeOp, String arg) throws Exception {
        String currentValsLongString = currentVals.getStringValue();
        String newValsLongString = newVals.getStringValue();
        StringTokenizer tokenizer = null;
        Configuration opConfig = null;
        if (null != newValsLongString) {
            tokenizer = new StringTokenizer(newValsLongString, "\n");
            opConfig = new Configuration();
            while (tokenizer.hasMoreTokens()) {
                String newVal = tokenizer.nextToken().trim();
                if (null != currentValsLongString && currentValsLongString.contains(newVal)) continue;
                opConfig.put((Property)new PropertySimple(arg, (Object)newVal));
                try {
                    this.invokeOperation(addOp, opConfig);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Could not add " + arg + "=" + newVal + ". Please check spelling/existence.");
                }
            }
        }
        if (null != currentValsLongString) {
            tokenizer = new StringTokenizer(currentValsLongString, "\n");
            while (tokenizer.hasMoreTokens()) {
                String currentVal = tokenizer.nextToken().trim();
                if (null != newValsLongString && newValsLongString.contains(currentVal)) continue;
                opConfig.put((Property)new PropertySimple(arg, (Object)currentVal));
                try {
                    this.invokeOperation(removeOp, opConfig);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Could not remove " + arg + "=" + currentVal + ". Please check spelling/existence.");
                }
            }
        }
    }

    public File getCatalinaBase() {
        return ((TomcatServerComponent)this.getResourceContext().getParentResourceComponent()).getCatalinaBase();
    }

    public String getName() {
        return this.getResourceContext().getPluginConfiguration().getSimpleValue(PLUGIN_CONFIG_NAME, "localhost");
    }

    public File getConfigurationPath() {
        String appBase = (String)this.getEmsBean().getAttribute(CONFIG_APP_BASE).getValue();
        if (null == appBase) {
            appBase = "webapps";
        }
        return new File(this.getCatalinaBase(), appBase);
    }

    private boolean isUnpackWars() {
        Boolean unpackWars = (Boolean)this.getEmsBean().getAttribute(CONFIG_UNPACK_WARS).getValue();
        return null != unpackWars && unpackWars != false;
    }

    public CreateResourceReport createResource(CreateResourceReport report) {
        String resourceTypeName = report.getResourceType().getName();
        try {
            if (!"Tomcat Web Application (WAR)".equals(resourceTypeName)) {
                throw new UnsupportedOperationException("Unsupported Resource type: " + resourceTypeName);
            }
            this.warCreate(report);
        }
        catch (Exception e) {
            CreateResourceHelper.setErrorOnReport(report, e);
        }
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void warCreate(CreateResourceReport report) throws Exception {
        File path;
        ResourcePackageDetails details = report.getPackageDetails();
        PackageDetailsKey key = details.getKey();
        String archiveName = key.getName();
        if (!archiveName.toLowerCase().endsWith(".war")) {
            CreateResourceHelper.setErrorOnReport(report, "Deployed file must have a .war extension");
            return;
        }
        Configuration deployTimeConfiguration = details.getDeploymentTimeConfiguration();
        if (null == deployTimeConfiguration) {
            CreateResourceHelper.setErrorOnReport(report, "Explode On Deploy property is required. Deploy configuration missing.");
            return;
        }
        PropertySimple explodeOnDeployProp = deployTimeConfiguration.getSimple(CONTENT_CONFIG_EXPLODE_ON_DEPLOY);
        if (null == explodeOnDeployProp || null == explodeOnDeployProp.getBooleanValue()) {
            CreateResourceHelper.setErrorOnReport(report, "Explode On Deploy property is required.");
            return;
        }
        boolean explodeOnDeploy = this.isUnpackWars() || explodeOnDeployProp.getBooleanValue() != false;
        File deployDir = this.getConfigurationPath();
        String contextRoot = archiveName.substring(0, archiveName.length() - 4);
        if (explodeOnDeploy) {
            archiveName = contextRoot;
        }
        if ((path = new File(deployDir, archiveName)).exists()) {
            CreateResourceHelper.setErrorOnReport(report, "A web application named " + path.getName() + " is already deployed with path " + path + ".");
            return;
        }
        File tempDir = this.getResourceContext().getTemporaryDirectory();
        File tempFile = new File(tempDir.getAbsolutePath(), "tomcat-war.bin");
        ContentContext contentContext = this.getResourceContext().getContentContext();
        ContentServices contentServices = contentContext.getContentServices();
        BufferedOutputStream osForTempDir = null;
        try {
            osForTempDir = new BufferedOutputStream(new FileOutputStream(tempFile));
            contentServices.downloadPackageBitsForChildResource(contentContext, "Tomcat Web Application (WAR)", key, (OutputStream)osForTempDir);
        }
        finally {
            if (null != osForTempDir) {
                try {
                    ((OutputStream)osForTempDir).close();
                }
                catch (IOException e) {
                    log.error((Object)"Error closing temporary output stream", (Throwable)e);
                }
            }
        }
        boolean valid = this.isWebApplication(tempFile);
        if (!valid) {
            CreateResourceHelper.setErrorOnReport(report, "Expected a Tomcat Web Application (WAR) file, but its format/content did not match");
            return;
        }
        FileContentDelegate fileContent = new FileContentDelegate(deployDir, details.getPackageTypeName());
        BufferedInputStream isForTempDir = new BufferedInputStream(new FileInputStream(tempFile));
        fileContent.createContent(path, isForTempDir, explodeOnDeploy);
        String objectName = "Catalina:j2eeType=WebModule,J2EEApplication=none,J2EEServer=none,name=//" + this.getName() + "/" + contextRoot;
        report.setResourceName(archiveName);
        report.setResourceKey(CreateResourceHelper.getCanonicalName(objectName));
        report.setStatus(CreateResourceStatus.SUCCESS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWebApplication(File file) {
        String testFile = "WEB-INF/web.xml";
        boolean result = false;
        if (file.isDirectory()) {
            result = new File(file, testFile).exists();
        } else {
            JarFile jfile = null;
            try {
                jfile = new JarFile(file);
                JarEntry entry = jfile.getJarEntry(testFile);
                result = null != entry;
            }
            catch (Exception e) {
                log.info((Object)e.getMessage());
                result = false;
            }
            finally {
                if (jfile != null) {
                    try {
                        jfile.close();
                    }
                    catch (IOException e) {
                        log.info((Object)("Exception when trying to close the war file: " + e.getMessage()));
                    }
                }
            }
        }
        return result;
    }

    public TomcatApplicationDeployer getDeployer() {
        TomcatApplicationDeployer deployer = null;
        EmsConnection connection = null;
        try {
            connection = this.getEmsConnection();
            if (null != connection) {
                deployer = new TomcatApplicationDeployer(connection, this.getName());
            }
        }
        catch (Throwable e) {
            log.error((Object)("Unable to access Deployer MBean required for creation and deletion of managed resources - this should never happen. Cause: " + e));
        }
        return deployer;
    }

    void undeployWar(String contextRoot) throws TomcatApplicationDeployer.DeployerException {
        TomcatApplicationDeployer deployer = this.getDeployer();
        if (null == deployer) {
            throw new IllegalStateException("Unable to undeploy " + contextRoot + ", because Deployer MBean could " + "not be accessed - this should never happen.");
        }
        deployer.undeploy(contextRoot);
    }
}

