/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.plugins.tomcat;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.on.plugins.tomcat.TomcatVHostComponent;
import org.jboss.on.plugins.tomcat.helper.CreateResourceHelper;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jmx.MBeanResourceDiscoveryComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TomcatWarDiscoveryComponent
extends MBeanResourceDiscoveryComponent<TomcatVHostComponent> {
    public static final String PLUGIN_CONFIG_NAME = "name";
    private static final List<String> EMS_ATTRIBUTE_DOC_BASE = Arrays.asList("docBase");
    private static final List<String> EMS_ATTRIBUTE_PATH = Arrays.asList("path");
    private static final Pattern PATTERN_NAME = Pattern.compile("//(.*)(/.*)");
    private static final String RT_LOG_FILE_NAME_SUFFIX = "_rt.log";
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<TomcatVHostComponent> context) {
        TomcatVHostComponent parentComponent;
        Set resources = super.discoverResources(context);
        HashSet<DiscoveredResourceDetails> result = new HashSet<DiscoveredResourceDetails>();
        TomcatVHostComponent applicationServerComponent = parentComponent = (TomcatVHostComponent)context.getParentResourceComponent();
        String deployDirectoryPath = applicationServerComponent.getConfigurationPath().getPath();
        String parentHost = parentComponent.getName();
        Matcher m = PATTERN_NAME.matcher("");
        for (DiscoveredResourceDetails resource : resources) {
            resource.setResourceKey(CreateResourceHelper.getCanonicalName(resource.getResourceKey()));
            Configuration pluginConfiguration = resource.getPluginConfiguration();
            String name = pluginConfiguration.getSimpleValue(PLUGIN_CONFIG_NAME, "");
            m.reset(name);
            if (m.matches()) {
                String host = m.group(1);
                if (!host.equalsIgnoreCase(parentHost)) continue;
                EmsConnection connection = ((TomcatVHostComponent)context.getParentResourceComponent()).getEmsConnection();
                EmsBean warBean = connection.getBean(resource.getResourceKey());
                List contextRootAttribs = warBean.refreshAttributes(EMS_ATTRIBUTE_PATH);
                String contextRoot = (String)((EmsAttribute)contextRootAttribs.get(0)).getValue();
                List docBaseAttribs = warBean.refreshAttributes(EMS_ATTRIBUTE_DOC_BASE);
                String docBase = (String)((EmsAttribute)docBaseAttribs.get(0)).getValue();
                File docBaseFile = new File(docBase);
                String filename = docBaseFile.isAbsolute() ? docBase : deployDirectoryPath + File.separator + docBase;
                try {
                    filename = new File(filename).getCanonicalPath();
                }
                catch (IOException e) {
                    this.log.warn((Object)("Unexpected discovered web application path: " + filename));
                }
                if ("".equals(contextRoot)) {
                    contextRoot = "/";
                }
                pluginConfiguration.put((Property)new PropertySimple("vHost", (Object)host));
                pluginConfiguration.put((Property)new PropertySimple("contextRoot", (Object)contextRoot));
                pluginConfiguration.put((Property)new PropertySimple("filename", (Object)filename));
                pluginConfiguration.put((Property)new PropertySimple("responseTimeLogFile", (Object)this.getResponseTimeLogFile(parentComponent.getCatalinaBase(), host, contextRoot)));
                resource.setResourceName(resource.getResourceName().replace("{contextRoot}", "/".equals(contextRoot) ? docBase : contextRoot));
                result.add(resource);
                continue;
            }
            this.log.warn((Object)("Skipping discovered web application with unexpected name: " + name));
        }
        Set<DiscoveredResourceDetails> undeployedWarResources = this.discoverUndeployed(context, result);
        result.addAll(undeployedWarResources);
        return result;
    }

    private Set<DiscoveredResourceDetails> discoverUndeployed(ResourceDiscoveryContext<TomcatVHostComponent> context, Set<DiscoveredResourceDetails> deployed) {
        WebAppFileFilter filter;
        Configuration defaultConfiguration = context.getDefaultPluginConfiguration();
        TomcatVHostComponent vhost = (TomcatVHostComponent)context.getParentResourceComponent();
        File deployDirectory = vhost.getConfigurationPath();
        File[] files = deployDirectory.listFiles(filter = new WebAppFileFilter());
        if (null == files || 0 == files.length) {
            return new HashSet<DiscoveredResourceDetails>(0);
        }
        ResourceType resourceType = context.getResourceType();
        String vhostName = vhost.getName();
        HashSet<DiscoveredResourceDetails> resources = new HashSet<DiscoveredResourceDetails>(files.length);
        for (File file : files) {
            String resourceKey;
            if (!vhost.isWebApplication(file)) continue;
            String resourceName = defaultConfiguration.getSimple("nameTemplate").getStringValue();
            String description = defaultConfiguration.getSimple("descriptionTemplate").getStringValue();
            String fileName = file.getName();
            String contextRoot = file.isDirectory() ? fileName : fileName.substring(0, fileName.length() - 4);
            contextRoot = "ROOT".equals(contextRoot) ? "/" : "/" + contextRoot;
            resourceName = resourceName.replace("{contextRoot}", contextRoot);
            String name = "//" + vhostName + contextRoot;
            String objectName = resourceKey = this.determineResourceKey(defaultConfiguration, name);
            DiscoveredResourceDetails resource = new DiscoveredResourceDetails(resourceType, resourceKey, resourceName, "", description, null, null);
            if (deployed.contains(resource)) continue;
            Configuration pluginConfiguration = resource.getPluginConfiguration();
            pluginConfiguration.put((Property)new PropertySimple(PLUGIN_CONFIG_NAME, (Object)name));
            pluginConfiguration.put((Property)new PropertySimple("objectName", (Object)objectName));
            pluginConfiguration.put((Property)new PropertySimple("vHost", (Object)vhost.getName()));
            pluginConfiguration.put((Property)new PropertySimple("contextRoot", (Object)contextRoot));
            try {
                pluginConfiguration.put((Property)new PropertySimple("filename", (Object)file.getCanonicalPath()));
            }
            catch (IOException e) {
                pluginConfiguration.put((Property)new PropertySimple("filename", (Object)file.getAbsolutePath()));
            }
            pluginConfiguration.put((Property)new PropertySimple("responseTimeLogFile", (Object)this.getResponseTimeLogFile(vhost.getCatalinaBase(), vhost.getName(), contextRoot)));
            resources.add(resource);
        }
        return resources;
    }

    private String determineResourceKey(Configuration defaultConfiguration, String name) {
        String template = defaultConfiguration.getSimple("objectName").getStringValue();
        String resourceKey = template.replaceAll("%name%", name);
        return CreateResourceHelper.getCanonicalName(resourceKey);
    }

    private String getResponseTimeLogFile(File installPath, String vHost, String contextRoot) {
        String result;
        File logsDir = new File(installPath, "logs/rt");
        String rtLogFileName = null;
        rtLogFileName = this.isLocalhost(vHost) ? (this.isRoot(contextRoot) ? "ROOT" : contextRoot.substring(1)) + RT_LOG_FILE_NAME_SUFFIX : vHost + (this.isRoot(contextRoot) ? "/ROOT" : contextRoot) + RT_LOG_FILE_NAME_SUFFIX;
        rtLogFileName = rtLogFileName.replace('/', '_');
        File rtLogFile = new File(logsDir, rtLogFileName);
        try {
            result = rtLogFile.getCanonicalPath();
        }
        catch (IOException e) {
            result = rtLogFile.getPath();
        }
        return result;
    }

    private boolean isLocalhost(String vHost) {
        return "localhost".equals(vHost) || "127.0.0.1".equals(vHost);
    }

    private boolean isRoot(String contextRoot) {
        return "/".equals(contextRoot);
    }

    private static class WebAppFileFilter
    implements FileFilter {
        public boolean accept(File pathname) {
            return pathname.isDirectory() || pathname.getPath().toLowerCase().endsWith(".war");
        }
    }
}

