/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.plugins.tomcat;

import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.on.plugins.tomcat.TomcatServerComponent;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.plugins.jmx.MBeanResourceComponent;
import org.rhq.plugins.jmx.util.ObjectNameQueryUtility;

public class TomcatConnectorComponent
extends MBeanResourceComponent<TomcatServerComponent<?>> {
    public static final String CONFIG_PROTOCOL = "protocol";
    public static final String CONFIG_V5_KEEP_ALIVE_TIMEOUT = "keepAliveTimeout";
    public static final String PLUGIN_CONFIG_ADDRESS = "address";
    public static final String PLUGIN_CONFIG_CONNECTOR = "connector";
    public static final String PLUGIN_CONFIG_HANDLER = "handler";
    public static final String PLUGIN_CONFIG_NAME = "name";
    public static final String PLUGIN_CONFIG_PORT = "port";
    public static final String PLUGIN_CONFIG_SHARED_EXECUTOR = "sharedExecutorName";
    public static final String UNKNOWN = "?";
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public AvailabilityType getAvailability() {
        AvailabilityType result = super.getAvailability();
        if (AvailabilityType.UP == result) {
            ObjectNameQueryUtility queryUtility;
            String objectName = this.getGlobalRequestProcessorName();
            EmsConnection connection = this.getEmsConnection();
            List beans = connection.queryBeans((queryUtility = new ObjectNameQueryUtility(objectName)).getTranslatedQuery());
            result = beans.isEmpty() ? AvailabilityType.DOWN : AvailabilityType.UP;
        }
        return result;
    }

    public void start(ResourceContext<TomcatServerComponent<?>> context) {
        if (UNKNOWN.equals(context.getPluginConfiguration().getSimple(PLUGIN_CONFIG_HANDLER).getStringValue())) {
            throw new InvalidPluginConfigurationException("The connector is not listening for requests on the configured port. This is most likely due to the configured port being in use at Tomcat startup. In some cases (AJP connectors) Tomcat will assign an open port. This happens most often when there are multiple Tomcat servers running on the same platform. Check your Tomcat configuration for conflicts: " + context.getResourceKey());
        }
        super.start(context);
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) {
        this.getEmsConnection();
        for (MeasurementScheduleRequest request : requests) {
            String req = request.getName();
            req = this.switchConnectorThreadpoolName(req);
            req = this.getAttributeName(req);
            String beanName = req.substring(0, req.lastIndexOf(58));
            String attributeName = req.substring(req.lastIndexOf(58) + 1);
            try {
                EmsBean eBean = this.loadBean(beanName);
                if (eBean == null) {
                    this.log.warn((Object)("Bean " + beanName + " not found, skipping ..."));
                    continue;
                }
                EmsAttribute attribute = eBean.getAttribute(attributeName);
                Object valueObject = attribute.refresh();
                Number value = (Number)valueObject;
                report.addData(new MeasurementDataNumeric(request, Double.valueOf(value.doubleValue())));
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to obtain measurement [" + req + "]"), (Throwable)e);
            }
        }
    }

    private String switchConnectorThreadpoolName(String property) {
        Configuration pluginConfiguration = this.getResourceContext().getPluginConfiguration();
        String sharedExecutorName = pluginConfiguration.getSimpleValue(PLUGIN_CONFIG_SHARED_EXECUTOR, "");
        if (sharedExecutorName == null || sharedExecutorName.trim().isEmpty()) {
            return property;
        }
        String NON_SHARED_THREADS_ACTIVE = "Catalina:type=ThreadPool,name=%name%:currentThreadsBusy";
        String NON_SHARED_THREADS_ALLOCATED = "Catalina:type=ThreadPool,name=%name%:currentThreadCount";
        String NON_SHARED_THREADS_MAX = "Catalina:type=ThreadPool,name=%name%:maxThreads";
        String SHARED_THREADS_ACTIVE = "Catalina:type=Executor,name=XXX:activeCount";
        String SHARED_THREADS_ALLOCATED = "Catalina:type=Executor,name=XXX:poolSize";
        String SHARED_THREADS_MAX = "Catalina:type=Executor,name=XXX:maxThreads";
        if (property.equals("Catalina:type=ThreadPool,name=%name%:currentThreadsBusy")) {
            property = "Catalina:type=Executor,name=XXX:activeCount";
        } else if (property.equals("Catalina:type=ThreadPool,name=%name%:currentThreadCount")) {
            property = "Catalina:type=Executor,name=XXX:poolSize";
        } else if (property.equals("Catalina:type=ThreadPool,name=%name%:maxThreads")) {
            property = "Catalina:type=Executor,name=XXX:maxThreads";
        } else {
            return property;
        }
        property = property.replace("XXX", sharedExecutorName);
        return property;
    }

    protected String getAttributeName(String property) {
        String theProperty = this.replaceGlobalRequestProcessorNameProps(property);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Finding metrics for: " + theProperty));
        }
        return theProperty;
    }

    private String getGlobalRequestProcessorName() {
        return this.replaceGlobalRequestProcessorNameProps("Catalina:type=GlobalRequestProcessor,name=%name%");
    }

    private String replaceGlobalRequestProcessorNameProps(String property) {
        Configuration pluginConfiguration = this.getResourceContext().getPluginConfiguration();
        String name = pluginConfiguration.getSimple(PLUGIN_CONFIG_NAME).getStringValue();
        String result = property.replace("%name%", name);
        return result;
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        ResourceContext context = this.getResourceContext();
        ConfigurationDefinition configDef = context.getResourceType().getResourceConfigurationDefinition();
        String protocol = report.getConfiguration().getSimpleValue(CONFIG_PROTOCOL, null);
        if (null == protocol || protocol.toUpperCase().contains("HTTP")) {
            for (PropertyDefinition propDef : configDef.getPropertiesInGroup("AJP")) {
                report.getConfiguration().remove(propDef.getName());
            }
        }
        if (null == protocol || protocol.toUpperCase().contains("AJP")) {
            for (PropertyDefinition propDef : configDef.getPropertiesInGroup("HTTP")) {
                report.getConfiguration().remove(propDef.getName());
            }
            for (PropertyDefinition propDef : configDef.getPropertiesInGroup("HTTP SSL")) {
                report.getConfiguration().remove(propDef.getName());
            }
        }
        if (((TomcatServerComponent)this.getResourceContext().getParentResourceComponent()).getResourceContext().getVersion().startsWith("5")) {
            report.getConfiguration().remove(CONFIG_V5_KEEP_ALIVE_TIMEOUT);
        }
        EmsBean bean = super.getEmsBean();
        block10: for (String key : report.getConfiguration().getSimpleProperties().keySet()) {
            PropertySimple pro;
            PropertySimple prop;
            EmsAttribute attribute = bean.getAttribute(key);
            if (attribute == null) {
                this.log.debug((Object)("Removing " + key + " does correspond to an attribut"));
                report.getConfiguration().remove(key);
                continue;
            }
            PropertyDefinitionSimple def = configDef.getPropertyDefinitionSimple(key);
            if (def.isRequired() || !((prop = report.getConfiguration().getSimple(key)) instanceof PropertySimple) || (pro = prop).getStringValue() != null && (pro.getStringValue() == null || !pro.getStringValue().equals("null"))) continue;
            String p = context.getResourceType().getResourceConfigurationDefinition().getDefaultTemplate().getConfiguration().getSimpleValue(key);
            this.log.debug((Object)("Using default value for " + key + " value: " + def.getDefaultValue()));
            switch (def.getType()) {
                case INTEGER: {
                    pro.setIntegerValue(Integer.valueOf(p));
                    continue block10;
                }
                case LONG: {
                    pro.setLongValue(Long.valueOf(Long.valueOf(p)));
                    continue block10;
                }
                case BOOLEAN: {
                    pro.setBooleanValue(Boolean.valueOf(p));
                }
            }
            if (p != null) {
                pro.setStringValue(p);
                continue;
            }
            if (pro.getStringValue() == null) continue;
            pro.setStringValue(null);
        }
        super.updateResourceConfiguration(report);
        if (ConfigurationUpdateStatus.SUCCESS != report.getStatus()) {
            return;
        }
        try {
            this.storeConfig();
        }
        catch (Exception e) {
            report.setErrorMessage("Failed to persist configuration change.  Changes will not survive Tomcat restart unless a successful Store Configuration operation is performed.");
        }
    }

    void storeConfig() throws Exception {
        ((TomcatServerComponent)this.getResourceContext().getParentResourceComponent()).storeConfig();
    }
}

