/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimerTask;
import org.jboss.logging.Logger;
import org.jboss.remoting.ClientHolder;
import org.jboss.remoting.ConnectionNotifier;
import org.jboss.remoting.util.TimerUtil;
import org.jboss.util.id.GUID;

public class Lease {
    private ConnectionNotifier notifier = null;
    private String clientSessionId = null;
    private long leasePeriod = -1L;
    private String locatorURL = null;
    private Map requestPayload = null;
    private LeaseTimerTask leaseTimerTask = null;
    private long leaseWindow = -1L;
    private long pingStart = -1L;
    private Map clientLeases = null;
    private Object lock = new Object();
    private String leasePingerId;
    private boolean stopped;
    private boolean leaseUpdated = false;
    private long lastUpdate;
    private boolean useClientConnectionIdentity;
    private static final Logger log = Logger.getLogger((Class)Lease.class);
    private static final boolean isTraceEnabled = log.isTraceEnabled();
    protected String leaseId = new GUID().toString();

    public Lease(String clientSessionId, long leasePeriod, String locatorurl, Map requestPayload, ConnectionNotifier notifier, Map clientLeases) {
        this.clientSessionId = clientSessionId;
        this.leasePeriod = leasePeriod;
        this.notifier = notifier;
        this.locatorURL = locatorurl;
        if (requestPayload != null) {
            this.requestPayload = (Map)requestPayload.get("ClientHolderKey");
            this.leasePingerId = (String)requestPayload.get("leasePingerId");
            String s = (String)requestPayload.get("timeStamp");
            if (s != null) {
                this.lastUpdate = Long.valueOf(s);
                this.useClientConnectionIdentity = true;
                if (isTraceEnabled) {
                    log.trace((Object)(this + " initialized with lastUpdate: " + this.lastUpdate));
                }
            }
            if (isTraceEnabled) {
                log.trace((Object)(this + " initialized with requestPayload: " + this.requestPayload));
            }
            if (isTraceEnabled) {
                log.trace((Object)("leasePingerId: " + this.leasePingerId));
            }
        }
        this.leaseWindow = leasePeriod * 2L;
        this.clientLeases = clientLeases;
    }

    public void startLease() {
        if (isTraceEnabled) {
            log.trace((Object)("Starting lease for client invoker (session id = " + this.clientSessionId + ") with lease window time of " + this.leaseWindow));
        }
        this.leaseTimerTask = new LeaseTimerTask();
        TimerUtil.schedule(this.leaseTimerTask, this.leaseWindow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLease(long leasePeriod, Map requestMap) {
        if (requestMap != null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.useClientConnectionIdentity) {
                    if (isTraceEnabled) {
                        log.trace((Object)(this + " requestMap: " + requestMap));
                    }
                    long time = 0L;
                    String timeString = (String)requestMap.get("timeStamp");
                    time = Long.valueOf(timeString);
                    if (isTraceEnabled) {
                        log.trace((Object)(this + " last update: " + this.lastUpdate + ", this update: " + time));
                    }
                    if (time >= this.lastUpdate) {
                        this.lastUpdate = time;
                        this.doUpdate(requestMap);
                    } else {
                        if (isTraceEnabled) {
                            log.trace((Object)(this + " updating lease but not client list"));
                        }
                        this.leaseUpdated = true;
                    }
                } else {
                    this.doUpdate(requestMap);
                }
            }
        } else if (isTraceEnabled) {
            log.trace((Object)(this + " requestPayload == null"));
        }
    }

    public void updateLease(long leasePeriod) {
        long pingDuration;
        this.leaseUpdated = true;
        if (leasePeriod != this.leasePeriod) {
            this.leasePeriod = leasePeriod;
            this.leaseWindow = leasePeriod * 2L;
            this.stopLease();
            this.startLease();
            if (isTraceEnabled) {
                log.trace((Object)("Lease for client invoker (session id = " + this.clientSessionId + ") updated with new lease window of " + this.leaseWindow + ".  Resetting timer."));
            }
        } else if (this.pingStart != -1L && (double)(pingDuration = System.currentTimeMillis() - this.pingStart) > 0.75 * (double)this.leaseWindow) {
            this.leaseWindow = pingDuration * 2L;
            this.stopLease();
            this.leaseTimerTask = new LeaseTimerTask();
            TimerUtil.schedule(this.leaseTimerTask, this.leaseWindow);
        }
        this.pingStart = System.currentTimeMillis();
    }

    public void terminateLease(String sessionId) {
        if (this.clientSessionId.equals(sessionId)) {
            if (isTraceEnabled) {
                log.trace((Object)(this + " Terminating lease group for session id " + sessionId));
            }
            this.stopLease();
            this.notifyClientTermination(null);
        } else {
            if (isTraceEnabled) {
                log.trace((Object)(this + " Terminating individual lease for session id " + sessionId));
            }
            this.notifyClientTermination(sessionId);
        }
    }

    public void terminateLeaseUponFailure(String sessionId) {
        if (this.clientSessionId.equals(sessionId)) {
            if (isTraceEnabled) {
                log.trace((Object)(this + " Terminating lease group for session id " + sessionId));
            }
            this.stopLease();
            this.notifyClientLost();
        } else {
            log.warn((Object)(this + " Expected invoker session id: " + sessionId));
            this.notifyClientLost();
        }
    }

    public String toString() {
        String hash = Integer.toHexString(System.identityHashCode(this));
        return "Lease[" + hash + ":" + this.clientSessionId + ":" + this.leasePingerId + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyClientTermination(String sessionId) {
        HashMap localRequestPayload = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.requestPayload != null) {
                localRequestPayload = new HashMap(this.requestPayload);
                if (sessionId != null) {
                    this.requestPayload.remove(sessionId);
                }
            }
        }
        if (localRequestPayload != null) {
            Object clientHolderObj;
            if (sessionId != null) {
                object = this.lock;
                synchronized (object) {
                    if (this.stopped) {
                        if (isTraceEnabled) {
                            log.trace((Object)(this + " already stopped"));
                        }
                        return;
                    }
                }
                clientHolderObj = localRequestPayload.get(sessionId);
                if (clientHolderObj != null && clientHolderObj instanceof ClientHolder) {
                    ClientHolder clientHolder = (ClientHolder)clientHolderObj;
                    this.notifier.connectionTerminated(this.locatorURL, clientHolder.getSessionId(), clientHolder.getConfig());
                    if (isTraceEnabled) {
                        log.trace((Object)(this + " Notified connection listener of lease termination due to disconnect from client (client session id = " + clientHolder.getSessionId()));
                    }
                }
            } else {
                clientHolderObj = this.lock;
                synchronized (clientHolderObj) {
                    if (this.stopped) {
                        if (isTraceEnabled) {
                            log.trace((Object)(this + " already stopped"));
                        }
                        return;
                    }
                    this.stopped = true;
                }
                Collection clientHoldersCol = localRequestPayload.values();
                if (clientHoldersCol != null && clientHoldersCol.size() > 0) {
                    Iterator itr = clientHoldersCol.iterator();
                    while (itr.hasNext()) {
                        Object val = itr.next();
                        if (val == null || !(val instanceof ClientHolder)) continue;
                        ClientHolder clientHolder = (ClientHolder)val;
                        this.notifier.connectionTerminated(this.locatorURL, clientHolder.getSessionId(), clientHolder.getConfig());
                        if (!isTraceEnabled) continue;
                        log.trace((Object)(this + " Notified connection listener of lease termination due to disconnect from client (client session id = " + clientHolder.getSessionId()));
                    }
                }
            }
        } else {
            log.warn((Object)(this + " Tried to terminate lease for session id " + sessionId + ", but no collection of clients have been set."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyClientLost() {
        HashMap localRequestPayload = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.stopped) {
                if (isTraceEnabled) {
                    log.trace((Object)(this + " already stopped"));
                }
                return;
            }
            this.stopped = true;
            if (this.requestPayload != null) {
                localRequestPayload = new HashMap(this.requestPayload);
            }
        }
        if (localRequestPayload != null) {
            Collection clientHoldersCol = localRequestPayload.values();
            if (isTraceEnabled) {
                log.trace((Object)(this + " notifying listeners about " + clientHoldersCol.size() + " expired client(s)"));
            }
            if (clientHoldersCol != null && clientHoldersCol.size() > 0) {
                Iterator itr = clientHoldersCol.iterator();
                while (itr.hasNext()) {
                    Object val = itr.next();
                    if (val == null || !(val instanceof ClientHolder)) continue;
                    ClientHolder clientHolder = (ClientHolder)val;
                    this.notifier.connectionLost(this.locatorURL, clientHolder.getSessionId(), clientHolder.getConfig());
                    if (!isTraceEnabled) continue;
                    log.trace((Object)(this + " Notified connection listener of lease expired due to lost connection from client (client session id = " + clientHolder.getSessionId()));
                }
            }
        } else {
            if (isTraceEnabled) {
                log.trace((Object)(this + " requestPayload == null, calling ConnectionNotifier.connectionLost()"));
            }
            this.notifier.connectionLost(this.locatorURL, this.clientSessionId, null);
        }
    }

    protected String getLeasePingerId() {
        return this.leasePingerId;
    }

    protected String getLeaseId() {
        return this.leaseId;
    }

    private void stopLease() {
        this.leaseTimerTask.cancel();
    }

    private void doUpdate(Map requestMap) {
        this.requestPayload = (Map)requestMap.get("ClientHolderKey");
        if (isTraceEnabled) {
            log.trace((Object)(this + " updating: new Client list:"));
            Collection clientHoldersCol = this.requestPayload.values();
            Iterator itr = clientHoldersCol.iterator();
            while (itr.hasNext()) {
                Object val = itr.next();
                if (val == null || !(val instanceof ClientHolder)) continue;
                ClientHolder clientHolder = (ClientHolder)val;
                log.trace((Object)(this.leasePingerId + ":  " + clientHolder.getSessionId()));
            }
        }
        this.updateLease(this.leasePeriod);
    }

    private class LeaseTimerTask
    extends TimerTask {
        private LeaseTimerTask() {
        }

        public void run() {
            if (Lease.this.leaseUpdated) {
                Lease.this.leaseUpdated = false;
            } else {
                try {
                    if (isTraceEnabled) {
                        log.trace((Object)(Lease.this + " did not receive ping: " + Lease.this.clientSessionId));
                    }
                    Lease.this.stopLease();
                    Lease.this.notifyClientLost();
                    if (Lease.this.clientLeases != null) {
                        Lease.this.clientLeases.remove(Lease.this.clientSessionId);
                    }
                    if (isTraceEnabled) {
                        log.trace((Object)(Lease.this + " removed lease:" + Lease.this.clientSessionId));
                    }
                }
                catch (Throwable thr) {
                    log.error((Object)"Error terminating client lease and sending notification of lost client.", thr);
                }
            }
        }
    }
}

