/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.socket;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Timer;
import java.util.TimerTask;
import org.jboss.logging.Logger;

public class TimedOutputStream
extends OutputStream {
    private static Timer timer = new Timer(true);
    private static Logger log = Logger.getLogger((Class)TimedOutputStream.class);
    private OutputStream os;
    private int outputTimeout;
    private Socket socket;
    private OutputTimerTask timerTask;
    private Object lock = new Object();

    public TimedOutputStream(OutputStream os, Socket socket, int outputTimeout) {
        this.os = os;
        this.socket = socket;
        this.outputTimeout = outputTimeout;
    }

    public void close() throws IOException {
        this.os.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int b) throws IOException {
        Object object;
        Object object2 = this.lock;
        synchronized (object2) {
            block14: {
                if (this.timerTask == null) {
                    try {
                        this.timerTask = new OutputTimerTask(this);
                        timer.schedule((TimerTask)this.timerTask, this.outputTimeout);
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("scheduled OutputTimerTask: " + this.outputTimeout));
                        }
                    }
                    catch (IllegalStateException e) {
                        timer = new Timer(true);
                        timer.schedule((TimerTask)new OutputTimerTask(this), this.outputTimeout);
                        if (!log.isTraceEnabled()) break block14;
                        log.trace((Object)("scheduled OutputTimerTask: " + this.outputTimeout));
                    }
                }
            }
        }
        try {
            this.os.write(b);
            Object var6_5 = null;
            object = this.lock;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            Object object3 = this.lock;
            synchronized (object3) {
                this.timerTask.cancel();
                this.timerTask = null;
            }
            throw throwable;
        }
        synchronized (object) {
            this.timerTask.cancel();
            this.timerTask = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] b, int off, int len) throws IOException {
        Object object;
        Object object2 = this.lock;
        synchronized (object2) {
            block14: {
                if (this.timerTask == null) {
                    try {
                        this.timerTask = new OutputTimerTask(this);
                        timer.schedule((TimerTask)this.timerTask, this.outputTimeout);
                        if (log.isTraceEnabled()) {
                            log.trace((Object)(this + " scheduled " + this.timerTask + ": " + this.outputTimeout));
                        }
                    }
                    catch (IllegalStateException e) {
                        timer = new Timer(true);
                        timer.schedule((TimerTask)new OutputTimerTask(this), this.outputTimeout);
                        if (!log.isTraceEnabled()) break block14;
                        log.trace((Object)(this + " scheduled " + this.timerTask + ": " + this.outputTimeout));
                    }
                }
            }
        }
        try {
            this.os.write(b, off, len);
            Object var8_7 = null;
            object = this.lock;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            Object object3 = this.lock;
            synchronized (object3) {
                this.timerTask.cancel();
                this.timerTask = null;
            }
            throw throwable;
        }
        synchronized (object) {
            this.timerTask.cancel();
            this.timerTask = null;
        }
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void setSocket(Socket socket) {
        this.socket = socket;
    }

    static class OutputTimerTask
    extends TimerTask {
        private TimedOutputStream tos;

        public OutputTimerTask(TimedOutputStream tos) {
            this.tos = tos;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                block8: {
                    try {
                        Socket mySocket = this.tos.getSocket();
                        if (mySocket == null) break block8;
                        boolean on = true;
                        int soLingerDuration = 0;
                        log.debug((Object)(this + " socketWrite TIMEOUT: set soLinger(ON,0): " + this.tos));
                        mySocket.setSoLinger(on, soLingerDuration);
                    }
                    catch (IOException e) {
                        log.debug((Object)(" socketWrite TIMEOUT: Attempting to set linger on socket stream [" + this.tos + "], Exception [" + e.toString() + "]"));
                        Object var5_6 = null;
                        log.debug((Object)(this + " socketWrite TIMEOUT: close(): " + this.tos));
                        try {}
                        catch (Exception e2) {
                            log.error((Object)"Failed to close() socket stream Exception: ", (Throwable)e2);
                            this.tos = null;
                            return;
                        }
                        this.tos.close();
                        log.debug((Object)(this + " socketWrite TIMEOUT: close() completed."));
                        this.tos = null;
                        return;
                    }
                }
                Object var5_5 = null;
                log.debug((Object)(this + " socketWrite TIMEOUT: close(): " + this.tos));
                try {
                    this.tos.close();
                }
                catch (Exception e2) {
                    log.error((Object)"Failed to close() socket stream Exception: ", (Throwable)e2);
                    this.tos = null;
                    return;
                }
                log.debug((Object)(this + " socketWrite TIMEOUT: close() completed."));
                this.tos = null;
                return;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                log.debug((Object)(this + " socketWrite TIMEOUT: close(): " + this.tos));
                try {}
                catch (Exception e2) {
                    log.error((Object)"Failed to close() socket stream Exception: ", (Throwable)e2);
                    this.tos = null;
                    return;
                }
                this.tos.close();
                log.debug((Object)(this + " socketWrite TIMEOUT: close() completed."));
                this.tos = null;
                throw throwable;
            }
        }

        public boolean cancel() {
            this.tos = null;
            return super.cancel();
        }
    }
}

