/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.io.IOException;
import org.jboss.remoting3.ServiceNotFoundException;
import org.jboss.remoting3.ServiceURI;
import org.jboss.remoting3.spi.ConnectionHandler;
import org.jboss.remoting3.spi.ConnectionHandlerContext;
import org.jboss.remoting3.spi.RequestHandler;
import org.jboss.remoting3.spi.RequestHandlerConnector;
import org.jboss.xnio.Cancellable;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.OptionMap;
import org.jboss.xnio.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LocalConnectionHandler
implements ConnectionHandler {
    private final ConnectionHandlerContext connectionHandlerContext;

    public LocalConnectionHandler(ConnectionHandlerContext connectionHandlerContext) {
        this.connectionHandlerContext = connectionHandlerContext;
    }

    @Override
    public Cancellable open(String serviceType, String groupName, Result<RequestHandler> result) {
        RequestHandler handler = this.connectionHandlerContext.openService(serviceType, groupName, OptionMap.EMPTY);
        if (handler == null) {
            result.setException((IOException)new ServiceNotFoundException(ServiceURI.create(serviceType, groupName, null)));
        } else {
            result.setResult((Object)handler);
        }
        return IoUtils.nullCancellable();
    }

    @Override
    public RequestHandlerConnector createConnector(final RequestHandler localHandler) {
        return new RequestHandlerConnector(){

            @Override
            public Cancellable createRequestHandler(Result<RequestHandler> result) throws SecurityException {
                result.setResult((Object)localHandler);
                return IoUtils.nullCancellable();
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.connectionHandlerContext.remoteClosed();
    }
}

