/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.NioByteOutput;
import org.jboss.remoting3.remote.InboundRequest;
import org.jboss.remoting3.remote.OutboundReplyBufferWriter;
import org.jboss.remoting3.remote.RemoteConnectionHandler;
import org.jboss.remoting3.spi.ReplyHandler;
import org.jboss.xnio.Pool;

final class OutboundReplyHandler
implements ReplyHandler {
    private final int rid;
    private final AtomicBoolean done = new AtomicBoolean();
    private InboundRequest inboundRequest;

    public OutboundReplyHandler(InboundRequest inboundRequest, int rid) {
        this.inboundRequest = inboundRequest;
        this.rid = rid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleReply(Object reply) throws IOException {
        if (!this.done.getAndSet(true)) {
            RemoteConnectionHandler connectionHandler = this.inboundRequest.getRemoteConnectionHandler();
            Marshaller marshaller = connectionHandler.getMarshallerFactory().createMarshaller(connectionHandler.getMarshallingConfiguration());
            marshaller.start((ByteOutput)new NioByteOutput((NioByteOutput.BufferWriter)new OutboundReplyBufferWriter(this.inboundRequest, this.rid, false)));
            RemoteConnectionHandler old = RemoteConnectionHandler.setCurrent(connectionHandler);
            try {
                marshaller.writeObject(reply);
                marshaller.finish();
            }
            finally {
                RemoteConnectionHandler.setCurrent(old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleException(IOException exception) throws IOException {
        if (!this.done.getAndSet(true)) {
            RemoteConnectionHandler connectionHandler = this.inboundRequest.getRemoteConnectionHandler();
            boolean ok = false;
            try {
                Marshaller marshaller = connectionHandler.getMarshallerFactory().createMarshaller(connectionHandler.getMarshallingConfiguration());
                marshaller.start((ByteOutput)new NioByteOutput((NioByteOutput.BufferWriter)new OutboundReplyBufferWriter(this.inboundRequest, this.rid, true)));
                RemoteConnectionHandler old = RemoteConnectionHandler.setCurrent(connectionHandler);
                try {
                    marshaller.writeObject((Object)exception);
                    marshaller.finish();
                }
                finally {
                    RemoteConnectionHandler.setCurrent(old);
                }
                ok = true;
            }
            finally {
                if (!ok) {
                    Pool<ByteBuffer> bufferPool = connectionHandler.getBufferPool();
                    ByteBuffer buffer = (ByteBuffer)bufferPool.allocate();
                    try {
                        buffer.putInt(0);
                        buffer.put((byte)11);
                        buffer.putInt(this.rid);
                        buffer.flip();
                        connectionHandler.getRemoteConnection().sendBlocking(buffer);
                    }
                    finally {
                        bufferPool.free((Object)buffer);
                    }
                }
            }
        }
    }

    public void handleCancellation() throws IOException {
        this.setDone();
    }

    public void setDone() {
        this.done.set(true);
    }
}

