/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import org.jboss.marshalling.NioByteInput;
import org.jboss.marshalling.util.IntKeyMap;
import org.jboss.remoting3.ReplyException;
import org.jboss.remoting3.ServiceNotFoundException;
import org.jboss.remoting3.ServiceURI;
import org.jboss.remoting3.remote.AbstractMessageHandler;
import org.jboss.remoting3.remote.InboundClient;
import org.jboss.remoting3.remote.InboundReplyExceptionTask;
import org.jboss.remoting3.remote.InboundReplyInputHandler;
import org.jboss.remoting3.remote.InboundReplyTask;
import org.jboss.remoting3.remote.InboundRequest;
import org.jboss.remoting3.remote.InboundRequestTask;
import org.jboss.remoting3.remote.OutboundClient;
import org.jboss.remoting3.remote.OutboundRequest;
import org.jboss.remoting3.remote.OutboundRequestHandler;
import org.jboss.remoting3.remote.RemoteConnection;
import org.jboss.remoting3.remote.RemoteConnectionHandler;
import org.jboss.remoting3.spi.ReplyHandler;
import org.jboss.remoting3.spi.RequestHandler;
import org.jboss.remoting3.spi.SpiUtils;
import org.jboss.xnio.Buffers;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.OptionMap;
import org.jboss.xnio.Pool;
import org.jboss.xnio.channels.MessageHandler;

final class RemoteMessageHandler
extends AbstractMessageHandler
implements MessageHandler {
    private final RemoteConnection connection;
    private final RemoteConnectionHandler remoteConnectionHandler;

    RemoteMessageHandler(RemoteConnectionHandler remoteConnectionHandler, RemoteConnection connection) {
        super(connection);
        this.remoteConnectionHandler = remoteConnectionHandler;
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(ByteBuffer buffer) {
        byte cmd = buffer.get();
        RemoteConnectionHandler connectionHandler = this.remoteConnectionHandler;
        switch (cmd) {
            case 1: {
                int id = buffer.getInt();
                String serviceType = Buffers.getModifiedUtf8Z((ByteBuffer)buffer);
                String groupName = Buffers.getModifiedUtf8Z((ByteBuffer)buffer);
                RequestHandler handler = connectionHandler.getConnectionContext().openService(serviceType, groupName, OptionMap.EMPTY);
                Pool<ByteBuffer> bufferPool = connectionHandler.getBufferPool();
                ByteBuffer outBuf = (ByteBuffer)bufferPool.allocate();
                try {
                    outBuf.putInt(0);
                    if (handler == null) {
                        outBuf.put((byte)2);
                    } else {
                        IntKeyMap<InboundClient> inboundClients;
                        InboundClient inboundClient = new InboundClient(connectionHandler, handler);
                        IntKeyMap<InboundClient> intKeyMap = inboundClients = connectionHandler.getInboundClients();
                        synchronized (intKeyMap) {
                            inboundClients.put(id, (Object)inboundClient);
                        }
                        outBuf.put((byte)3);
                    }
                    outBuf.putInt(id);
                    outBuf.flip();
                    try {
                        this.connection.sendBlocking(outBuf);
                    }
                    catch (IOException e) {
                        RemoteConnectionHandler.log.trace("Send failed: %s", (Object)e);
                    }
                    return;
                }
                finally {
                    bufferPool.free((Object)outBuf);
                }
            }
            case 2: {
                OutboundClient client;
                IntKeyMap<OutboundClient> outboundClients;
                int id = buffer.getInt();
                Object handler = outboundClients = connectionHandler.getOutboundClients();
                synchronized (handler) {
                    client = (OutboundClient)outboundClients.remove(id);
                }
                if (client == null) {
                    RemoteConnectionHandler.log.trace("Received service-not-found for unknown client %d", (Object)id);
                    return;
                }
                handler = client;
                synchronized (handler) {
                    client.getResult().setException((IOException)new ServiceNotFoundException(ServiceURI.create(client.getServiceType(), client.getGroupName(), null)));
                    client.setState(OutboundClient.State.CLOSED);
                }
                return;
            }
            case 3: {
                OutboundClient client;
                IntKeyMap<OutboundClient> outboundClients;
                int id = buffer.getInt();
                Object handler = outboundClients = connectionHandler.getOutboundClients();
                synchronized (handler) {
                    client = (OutboundClient)outboundClients.get(id);
                }
                if (client == null) {
                    RemoteConnectionHandler.log.trace("Received service-client-opened for unknown client %d", (Object)id);
                    return;
                }
                handler = client;
                synchronized (handler) {
                    client.setState(OutboundClient.State.ESTABLISHED);
                    client.setResult(new OutboundRequestHandler(client));
                }
                return;
            }
            case 4: {
                InboundClient client;
                IntKeyMap<InboundClient> inboundClients;
                int id = buffer.getInt();
                Object handler = inboundClients = connectionHandler.getInboundClients();
                synchronized (handler) {
                    client = (InboundClient)inboundClients.remove(id);
                }
                if (client == null) {
                    RemoteConnectionHandler.log.trace("Received client-closed for unknown client %d", (Object)id);
                    return;
                }
                handler = client;
                synchronized (handler) {
                    IoUtils.safeClose((Closeable)client.getHandler());
                }
                return;
            }
            case 5: {
                NioByteInput byteInput;
                InboundRequest inboundRequest;
                int cid;
                int rid = buffer.getInt();
                byte flags = buffer.get();
                IntKeyMap<InboundRequest> inboundRequests = connectionHandler.getInboundRequests();
                boolean start = false;
                Object object = inboundRequests;
                synchronized (object) {
                    if ((flags & 1) != 0) {
                        cid = buffer.getInt();
                        inboundRequest = new InboundRequest(connectionHandler, rid);
                        start = true;
                        inboundRequests.put(rid, (Object)inboundRequest);
                        RemoteConnectionHandler.log.trace("Received first request message %s for %s", (Object)buffer, (Object)inboundRequest);
                    } else {
                        cid = 0;
                        inboundRequest = (InboundRequest)inboundRequests.get(rid);
                        RemoteConnectionHandler.log.trace("Received subsequent request message %s for %s", (Object)buffer, (Object)inboundRequest);
                    }
                    if (inboundRequest == null) {
                        RemoteConnectionHandler.log.trace("Received request for unknown request ID %d", (Object)rid);
                    }
                }
                object = inboundRequest;
                synchronized (object) {
                    if (start) {
                        connectionHandler.getConnectionContext().getConnectionProviderContext().getExecutor().execute(new InboundRequestTask(connectionHandler, inboundRequest, rid, cid));
                    }
                    byteInput = inboundRequest.getByteInput();
                }
                byteInput.push(buffer);
                return;
            }
            case 6: {
                InboundRequest inboundRequest;
                IntKeyMap<InboundRequest> inboundRequests;
                int rid = buffer.getInt();
                Object byteInput = inboundRequests = connectionHandler.getInboundRequests();
                synchronized (byteInput) {
                    inboundRequest = (InboundRequest)inboundRequests.remove(rid);
                }
                if (inboundRequest == null) {
                    RemoteConnectionHandler.log.trace("Received request-abort for unknown request ID %d", (Object)rid);
                    return;
                }
                byteInput = inboundRequest;
                synchronized (byteInput) {
                    inboundRequest.getReplyHandler().setDone();
                    inboundRequest.getByteInput().pushException((IOException)new InterruptedIOException("Request aborted"));
                }
                return;
            }
            case 7: {
                OutboundRequest outboundRequest;
                IntKeyMap<OutboundRequest> outboundRequests;
                int rid = buffer.getInt();
                Object byteInput = outboundRequests = connectionHandler.getOutboundRequests();
                synchronized (byteInput) {
                    outboundRequest = (OutboundRequest)outboundRequests.get(rid);
                }
                if (outboundRequest == null) {
                    RemoteConnectionHandler.log.trace("Received request-ack-chunk for unknown request ID %d", (Object)rid);
                    return;
                }
                byteInput = outboundRequest;
                synchronized (byteInput) {
                    outboundRequest.ack();
                }
                return;
            }
            case 8: {
                NioByteInput byteInput;
                OutboundRequest outboundRequest;
                IntKeyMap<OutboundRequest> outboundRequests;
                int rid = buffer.getInt();
                byte flags = buffer.get();
                Object cid = outboundRequests = connectionHandler.getOutboundRequests();
                synchronized (cid) {
                    outboundRequest = (OutboundRequest)outboundRequests.get(rid);
                }
                if (outboundRequest == null) {
                    RemoteConnectionHandler.log.trace("Received reply for unknown request ID %d", (Object)rid);
                    return;
                }
                cid = outboundRequest;
                synchronized (cid) {
                    if ((flags & 1) != 0) {
                        RemoteConnectionHandler.log.trace("Received first reply message %s for %s", (Object)buffer, (Object)outboundRequest);
                        byteInput = new NioByteInput((NioByteInput.InputHandler)new InboundReplyInputHandler(outboundRequest, rid));
                        outboundRequest.setByteInput(byteInput);
                        connectionHandler.getConnectionContext().getConnectionProviderContext().getExecutor().execute(new InboundReplyTask(connectionHandler, outboundRequest));
                    } else {
                        RemoteConnectionHandler.log.trace("Received subsequent reply message %s for %s", (Object)buffer, (Object)outboundRequest);
                        byteInput = outboundRequest.getByteInput();
                    }
                }
                byteInput.push(buffer);
                return;
            }
            case 10: {
                InboundRequest inboundRequest;
                IntKeyMap<InboundRequest> inboundRequests;
                int rid = buffer.getInt();
                Object byteInput = inboundRequests = connectionHandler.getInboundRequests();
                synchronized (byteInput) {
                    inboundRequest = (InboundRequest)inboundRequests.get(rid);
                }
                if (inboundRequest == null) {
                    RemoteConnectionHandler.log.trace("Received reply-ack-chunk for unknown request ID %d", (Object)rid);
                    return;
                }
                byteInput = inboundRequest;
                synchronized (byteInput) {
                    inboundRequest.ack();
                }
                return;
            }
            case 9: {
                NioByteInput byteInput;
                OutboundRequest outboundRequest;
                IntKeyMap<OutboundRequest> outboundRequests;
                int rid = buffer.getInt();
                byte flags = buffer.get();
                Object cid = outboundRequests = connectionHandler.getOutboundRequests();
                synchronized (cid) {
                    outboundRequest = (OutboundRequest)outboundRequests.get(rid);
                }
                if (outboundRequest == null) {
                    RemoteConnectionHandler.log.trace("Received reply-exception for unknown request ID %d", (Object)rid);
                    return;
                }
                cid = outboundRequest;
                synchronized (cid) {
                    if ((flags & 1) != 0) {
                        byteInput = new NioByteInput((NioByteInput.InputHandler)new InboundReplyInputHandler(outboundRequest, rid));
                        outboundRequest.setByteInput(byteInput);
                        connectionHandler.getConnectionContext().getConnectionProviderContext().getExecutor().execute(new InboundReplyExceptionTask(connectionHandler, outboundRequest));
                    } else {
                        byteInput = outboundRequest.getByteInput();
                    }
                }
                byteInput.push(buffer);
                return;
            }
            case 11: {
                ReplyHandler replyHandler;
                OutboundRequest outboundRequest;
                NioByteInput outboundRequests;
                int rid = buffer.getInt();
                NioByteInput byteInput = outboundRequests = connectionHandler.getOutboundRequests();
                synchronized (byteInput) {
                    outboundRequest = (OutboundRequest)outboundRequests.get(rid);
                }
                if (outboundRequest == null) {
                    RemoteConnectionHandler.log.trace("Received reply-exception-abort for unknown request ID %d", (Object)rid);
                    return;
                }
                OutboundRequest cid = outboundRequest;
                synchronized (cid) {
                    byteInput = outboundRequest.getByteInput();
                    replyHandler = outboundRequest.getInboundReplyHandler();
                }
                ReplyException re = new ReplyException("Reply exception was aborted");
                if (byteInput != null) {
                    byteInput.pushException((IOException)re);
                }
                if (replyHandler != null) {
                    SpiUtils.safeHandleException(replyHandler, re);
                }
                return;
            }
        }
        RemoteConnectionHandler.log.error("Received invalid packet type on %s, closing", (Object)connectionHandler);
        IoUtils.safeClose((Closeable)connectionHandler);
    }
}

