/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Marshalling;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.remote.AbstractMessageHandler;
import org.jboss.remoting3.remote.RemoteConnection;
import org.jboss.remoting3.remote.RemoteConnectionHandler;
import org.jboss.remoting3.remote.RemoteMessageHandler;
import org.jboss.remoting3.spi.ConnectionHandler;
import org.jboss.remoting3.spi.ConnectionHandlerContext;
import org.jboss.remoting3.spi.ConnectionHandlerFactory;
import org.jboss.remoting3.spi.ConnectionProviderContext;
import org.jboss.xnio.Buffers;
import org.jboss.xnio.IoUtils;

final class ServerAuthenticationHandler
extends AbstractMessageHandler {
    private final RemoteConnection remoteConnection;
    private final SaslServer saslServer;
    private final ConnectionProviderContext connectionProviderContext;

    ServerAuthenticationHandler(RemoteConnection remoteConnection, SaslServer saslServer, ConnectionProviderContext connectionProviderContext) {
        super(remoteConnection);
        this.saslServer = saslServer;
        this.remoteConnection = remoteConnection;
        this.connectionProviderContext = connectionProviderContext;
    }

    public void handleMessage(ByteBuffer buffer) {
        switch (buffer.get()) {
            case 14: {
                RemoteConnectionHandler.log.trace("Received SASL response");
                try {
                    byte[] challenge;
                    try {
                        challenge = this.saslServer.evaluateResponse(Buffers.take((ByteBuffer)buffer, (int)buffer.remaining()));
                    }
                    catch (SaslException e) {
                        RemoteConnectionHandler.log.trace((Throwable)e, "Server authentication failed", new Object[0]);
                        this.remoteConnection.sendAuthReject("Authentication failed");
                        this.remoteConnection.flushBlocking();
                        return;
                    }
                    boolean complete = this.saslServer.isComplete();
                    if (complete) {
                        RemoteConnectionHandler.log.trace("Sending SASL complete");
                        this.remoteConnection.sendAuthMessage((byte)15, challenge);
                        this.connectionProviderContext.accept(new ConnectionHandlerFactory(){

                            public ConnectionHandler createInstance(ConnectionHandlerContext connectionContext) {
                                MarshallerFactory marshallerFactory = Marshalling.getMarshallerFactory((String)"river");
                                final RemoteConnectionHandler connectionHandler = new RemoteConnectionHandler(connectionContext, ServerAuthenticationHandler.this.remoteConnection, marshallerFactory);
                                ServerAuthenticationHandler.this.remoteConnection.addCloseHandler(new CloseHandler<Object>(){

                                    @Override
                                    public void handleClose(Object closed) {
                                        IoUtils.safeClose((Closeable)connectionHandler);
                                    }
                                });
                                ServerAuthenticationHandler.this.remoteConnection.setMessageHandler(new RemoteMessageHandler(connectionHandler, ServerAuthenticationHandler.this.remoteConnection));
                                return connectionHandler;
                            }
                        });
                        break;
                    }
                    RemoteConnectionHandler.log.trace("Sending subsequent SASL challenge");
                    this.remoteConnection.sendAuthMessage((byte)13, challenge);
                }
                catch (IOException e) {
                    RemoteConnectionHandler.log.trace((Throwable)e, "Failed to send auth message", new Object[0]);
                    IoUtils.safeClose((Closeable)this.remoteConnection);
                }
                break;
            }
            default: {
                RemoteConnectionHandler.log.warn("Server received invalid message on %s", (Object)this.remoteConnection);
                IoUtils.safeClose((Closeable)this.remoteConnection);
            }
        }
    }

    public void handleEof() {
        IoUtils.safeClose((Closeable)this.remoteConnection);
    }

    public void handleException(IOException e) {
        IoUtils.safeClose((Closeable)this.remoteConnection);
    }
}

