/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.spi;

import java.io.Closeable;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.HandleableCloseable;
import org.jboss.remoting3.NotOpenException;
import org.jboss.remoting3.spi.SpiUtils;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHandleableCloseable<T extends HandleableCloseable<T>>
implements HandleableCloseable<T> {
    private static final Logger log = Logger.getLogger((String)"org.jboss.remoting.resource");
    private static final boolean LEAK_DEBUGGING;
    private final Executor executor;
    private final StackTraceElement[] backtrace;
    private final Object closeLock = new Object();
    private Thread closingThread;
    private State state = State.OPEN;
    private Map<HandleableCloseable.Key, CloseHandler<? super T>> closeHandlers = null;

    protected AbstractHandleableCloseable(Executor executor) {
        if (executor == null) {
            throw new NullPointerException("executor is null");
        }
        this.executor = executor;
        this.backtrace = LEAK_DEBUGGING ? new Throwable().getStackTrace() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isOpen() {
        Object object = this.closeLock;
        synchronized (object) {
            return this.state == State.OPEN;
        }
    }

    protected void closeAction() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Map<HandleableCloseable.Key, CloseHandler<T>> closeHandlers;
        Object object = this.closeLock;
        synchronized (object) {
            switch (this.state) {
                case OPEN: {
                    this.state = State.CLOSING;
                    this.closingThread = Thread.currentThread();
                    closeHandlers = this.closeHandlers;
                    this.closeHandlers = null;
                    break;
                }
                case CLOSING: 
                case CLOSED: {
                    return;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        if (closeHandlers != null) {
            log.trace("Closed %s", (Object)this);
            if (closeHandlers != null) {
                for (CloseHandler<? super T> closeHandler : closeHandlers.values()) {
                    AbstractHandleableCloseable.runCloseTask(this.executor, new CloseHandlerTask(closeHandler));
                }
            }
        }
        try {
            this.closeAction();
        }
        finally {
            object = this.closeLock;
            synchronized (object) {
                this.state = State.CLOSED;
                this.closingThread = null;
                this.closeLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitClosed() throws InterruptedException {
        Object object = this.closeLock;
        synchronized (object) {
            while (this.state != State.CLOSED) {
                this.closeLock.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitClosedUninterruptibly() {
        boolean intr = false;
        try {
            Object object = this.closeLock;
            synchronized (object) {
                while (this.state != State.CLOSED) {
                    try {
                        this.closeLock.wait();
                    }
                    catch (InterruptedException e) {
                        intr = true;
                    }
                }
            }
        }
        finally {
            if (intr) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HandleableCloseable.Key addCloseHandler(CloseHandler<? super T> handler) {
        if (handler == null) {
            throw new NullPointerException("handler is null");
        }
        Object object = this.closeLock;
        synchronized (object) {
            if (this.state == State.OPEN) {
                KeyImpl key = new KeyImpl(this);
                Map<HandleableCloseable.Key, CloseHandler<T>> closeHandlers = this.closeHandlers;
                if (closeHandlers == null) {
                    IdentityHashMap<HandleableCloseable.Key, CloseHandler<T>> newMap = new IdentityHashMap<HandleableCloseable.Key, CloseHandler<T>>();
                    this.closeHandlers = newMap;
                    newMap.put(key, handler);
                } else {
                    closeHandlers.put(key, handler);
                }
                return key;
            }
        }
        AbstractHandleableCloseable.runCloseTask(this.executor, new CloseHandlerTask(handler));
        return new NullKey();
    }

    private static void runCloseTask(Executor executor, Runnable task) {
        try {
            executor.execute(task);
        }
        catch (RejectedExecutionException ree) {
            task.run();
        }
    }

    protected Executor getExecutor() {
        return this.executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            if (!this.isOpen()) {
                if (LEAK_DEBUGGING) {
                    LeakThrowable t = new LeakThrowable();
                    t.setStackTrace(this.backtrace);
                    log.warn((Throwable)t, "Leaked a %s instance: %s", (Object)this.getClass().getName(), (Object)this);
                } else {
                    log.warn("Leaked a %s instance: %s", (Object)this.getClass().getName(), (Object)this);
                }
                IoUtils.safeClose((Closeable)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkOpen() throws NotOpenException {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.state != State.OPEN) {
                throw new NotOpenException(this.toString() + " is not open");
            }
        }
    }

    static {
        boolean b = false;
        try {
            b = Boolean.parseBoolean(AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("jboss.remoting.leakdebugging", "false");
                }
            }));
        }
        catch (SecurityException se) {
            b = false;
        }
        LEAK_DEBUGGING = b;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CloseHandlerTask
    implements Runnable {
        private final CloseHandler<? super T> handler;

        private CloseHandlerTask(CloseHandler<? super T> handler) {
            this.handler = handler;
        }

        @Override
        public void run() {
            SpiUtils.safeHandleClose(this.handler, AbstractHandleableCloseable.this);
        }
    }

    private static final class LeakThrowable
    extends Throwable {
        public String toString() {
            return "a leaked reference";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class KeyImpl<T extends HandleableCloseable<T>>
    implements HandleableCloseable.Key {
        private final AbstractHandleableCloseable<T> instance;

        private KeyImpl(AbstractHandleableCloseable<T> instance) {
            this.instance = instance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            Object object = ((AbstractHandleableCloseable)this.instance).closeLock;
            synchronized (object) {
                Map closeHandlers = ((AbstractHandleableCloseable)this.instance).closeHandlers;
                if (closeHandlers != null) {
                    closeHandlers.remove(this);
                }
            }
        }
    }

    private static final class NullKey
    implements HandleableCloseable.Key {
        private NullKey() {
        }

        public void remove() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        OPEN,
        CLOSING,
        CLOSED;

    }
}

