/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.spi;

import java.io.Serializable;
import org.jboss.marshalling.ClassExternalizerFactory;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.ObjectResolver;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.ProviderDescriptor;
import org.jboss.remoting3.security.ServerAuthenticationProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProtocolServiceType<T>
implements Serializable {
    private final Class<T> valueClass;
    private final String name;
    private final transient int index;
    private static final long serialVersionUID = -4972423526582260641L;
    private final String description;
    public static final ProtocolServiceType<ProviderDescriptor> MARSHALLER_PROVIDER_DESCRIPTOR;
    public static final ProtocolServiceType<ClassTable> CLASS_TABLE;
    public static final ProtocolServiceType<ObjectTable> OBJECT_TABLE;
    public static final ProtocolServiceType<ClassResolver> CLASS_RESOLVER;
    public static final ProtocolServiceType<ObjectResolver> OBJECT_RESOLVER;
    public static final ProtocolServiceType<ClassExternalizerFactory> CLASS_EXTERNALIZER_FACTORY;
    public static final ProtocolServiceType<ServerAuthenticationProvider> SERVER_AUTHENTICATION_PROVIDER;
    private static final ProtocolServiceType<?>[] SERVICE_TYPES;

    private ProtocolServiceType(Class<T> type, String name, String description, int index) {
        this.valueClass = type;
        this.name = name;
        this.description = description;
        this.index = index;
    }

    public Class<T> getValueClass() {
        return this.valueClass;
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    protected Object readResolve() {
        try {
            return ProtocolServiceType.class.getField(this.name).get(null);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot resolve service type object", e);
        }
    }

    public static ProtocolServiceType<?>[] getServiceTypes() {
        return (ProtocolServiceType[])SERVICE_TYPES.clone();
    }

    public static ProtocolServiceType<?> getServiceType(int index) {
        return SERVICE_TYPES[index];
    }

    public String getDescription() {
        return this.description;
    }

    static {
        int index = 0;
        ProtocolServiceType[] protocolServiceTypeArray = new ProtocolServiceType[7];
        MARSHALLER_PROVIDER_DESCRIPTOR = new ProtocolServiceType<ProviderDescriptor>(ProviderDescriptor.class, "MARSHALLER_FACTORY", "Marshaller factory", index++);
        protocolServiceTypeArray[0] = MARSHALLER_PROVIDER_DESCRIPTOR;
        CLASS_TABLE = new ProtocolServiceType<ClassTable>(ClassTable.class, "CLASS_TABLE", "Class table", index++);
        protocolServiceTypeArray[1] = CLASS_TABLE;
        OBJECT_TABLE = new ProtocolServiceType<ObjectTable>(ObjectTable.class, "OBJECT_TABLE", "Object table", index++);
        protocolServiceTypeArray[2] = OBJECT_TABLE;
        CLASS_RESOLVER = new ProtocolServiceType<ClassResolver>(ClassResolver.class, "CLASS_RESOLVER", "Class resolver", index++);
        protocolServiceTypeArray[3] = CLASS_RESOLVER;
        OBJECT_RESOLVER = new ProtocolServiceType<ObjectResolver>(ObjectResolver.class, "OBJECT_RESOLVER", "Object resolver", index++);
        protocolServiceTypeArray[4] = OBJECT_RESOLVER;
        CLASS_EXTERNALIZER_FACTORY = new ProtocolServiceType<ClassExternalizerFactory>(ClassExternalizerFactory.class, "CLASS_EXTERNALIZER_FACTORY", "Class externalizer factory", index++);
        protocolServiceTypeArray[5] = CLASS_EXTERNALIZER_FACTORY;
        SERVER_AUTHENTICATION_PROVIDER = new ProtocolServiceType<ServerAuthenticationProvider>(ServerAuthenticationProvider.class, "SERVER_AUTHENTICATION_PROVIDER", "Server authentication provider", index++);
        protocolServiceTypeArray[6] = SERVER_AUTHENTICATION_PROVIDER;
        SERVICE_TYPES = protocolServiceTypeArray;
    }
}

