/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.spi;

import java.io.IOException;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.RequestCancelHandler;
import org.jboss.remoting3.RequestContext;
import org.jboss.remoting3.spi.ReplyHandler;
import org.jboss.xnio.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SpiUtils {
    private static final Logger heLog = Logger.getLogger((String)"org.jboss.remoting.handler-errors");

    private SpiUtils() {
    }

    public static void safeHandleException(ReplyHandler replyHandler, IOException exception) {
        try {
            if (replyHandler != null) {
                replyHandler.handleException(exception);
            }
        }
        catch (Throwable t) {
            heLog.debug(t, "Failed to properly handle exception", new Object[0]);
        }
    }

    public static <O> void safeHandleReply(ReplyHandler replyHandler, O reply) {
        try {
            if (replyHandler != null) {
                replyHandler.handleReply(reply);
            }
        }
        catch (Throwable t) {
            heLog.debug(t, "Failed to properly handle reply", new Object[0]);
        }
    }

    public static void safeHandleCancellation(ReplyHandler replyHandler) {
        try {
            if (replyHandler != null) {
                replyHandler.handleCancellation();
            }
        }
        catch (Throwable t) {
            heLog.debug(t, "Failed to properly handle cancellation", new Object[0]);
        }
    }

    public static <O> void safeNotifyCancellation(RequestCancelHandler<O> handler, RequestContext<O> requestContext) {
        try {
            if (handler != null && requestContext != null) {
                handler.notifyCancel(requestContext);
            }
        }
        catch (Throwable t) {
            heLog.error(t, "Request cancel handler threw an exception", new Object[0]);
        }
    }

    public static <T> void safeHandleClose(CloseHandler<? super T> handler, T closed) {
        try {
            if (handler != null && closed != null) {
                handler.handleClose(closed);
            }
        }
        catch (Throwable t) {
            heLog.error(t, "Close handler threw an exception", new Object[0]);
        }
    }
}

